/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutomotiveModel
extends APINode {
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="automotive_model_id")
    private String mAutomotiveModelId = null;
    @SerializedName(value="availability")
    private String mAvailability = null;
    @SerializedName(value="body_style")
    private String mBodyStyle = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="custom_label_0")
    private String mCustomLabel0 = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="drivetrain")
    private String mDrivetrain = null;
    @SerializedName(value="exterior_color")
    private String mExteriorColor = null;
    @SerializedName(value="finance_description")
    private String mFinanceDescription = null;
    @SerializedName(value="finance_type")
    private String mFinanceType = null;
    @SerializedName(value="fuel_type")
    private String mFuelType = null;
    @SerializedName(value="generation")
    private String mGeneration = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="interior_color")
    private String mInteriorColor = null;
    @SerializedName(value="interior_upholstery")
    private String mInteriorUpholstery = null;
    @SerializedName(value="make")
    private String mMake = null;
    @SerializedName(value="model")
    private String mModel = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="transmission")
    private String mTransmission = null;
    @SerializedName(value="trim")
    private String mTrim = null;
    @SerializedName(value="unit_price")
    private Object mUnitPrice = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="year")
    private Long mYear = null;
    protected static Gson gson = null;

    AutomotiveModel() {
    }

    public AutomotiveModel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AutomotiveModel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AutomotiveModel fetch() throws APIException {
        AutomotiveModel newInstance = AutomotiveModel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AutomotiveModel fetchById(Long id, APIContext context) throws APIException {
        return AutomotiveModel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AutomotiveModel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AutomotiveModel.fetchByIdAsync(id.toString(), context);
    }

    public static AutomotiveModel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AutomotiveModel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AutomotiveModel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AutomotiveModel>(context, "", "/", "GET", AutomotiveModel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AutomotiveModel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AutomotiveModel>(context, "", "/", "GET", AutomotiveModel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AutomotiveModel loadJSON(String json, APIContext context, String header) {
        AutomotiveModel automotiveModel = (AutomotiveModel)AutomotiveModel.getGson().fromJson(json, AutomotiveModel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(automotiveModel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        automotiveModel.context = context;
        automotiveModel.rawValue = json;
        automotiveModel.header = header;
        return automotiveModel;
    }

    public static APINodeList<AutomotiveModel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AutomotiveModel> automotiveModels = new APINodeList<AutomotiveModel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        automotiveModels.add(AutomotiveModel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return automotiveModels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            automotiveModels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        automotiveModels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            automotiveModels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            automotiveModels.add(AutomotiveModel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                automotiveModels.add(AutomotiveModel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            automotiveModels.add(AutomotiveModel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return automotiveModels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        automotiveModels.add(AutomotiveModel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return automotiveModels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        automotiveModels.add(AutomotiveModel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return automotiveModels;
                }
                automotiveModels.clear();
                automotiveModels.add(AutomotiveModel.loadJSON(json, context, header));
                return automotiveModels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AutomotiveModel.getGson().toJson((Object)this);
    }

    public APIRequestGetAugmentedRealitiesMetadata getAugmentedRealitiesMetadata() {
        return new APIRequestGetAugmentedRealitiesMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldAutomotiveModelId() {
        return this.mAutomotiveModelId;
    }

    public String getFieldAvailability() {
        return this.mAvailability;
    }

    public String getFieldBodyStyle() {
        return this.mBodyStyle;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldCustomLabel0() {
        return this.mCustomLabel0;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDrivetrain() {
        return this.mDrivetrain;
    }

    public String getFieldExteriorColor() {
        return this.mExteriorColor;
    }

    public String getFieldFinanceDescription() {
        return this.mFinanceDescription;
    }

    public String getFieldFinanceType() {
        return this.mFinanceType;
    }

    public String getFieldFuelType() {
        return this.mFuelType;
    }

    public String getFieldGeneration() {
        return this.mGeneration;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldInteriorColor() {
        return this.mInteriorColor;
    }

    public String getFieldInteriorUpholstery() {
        return this.mInteriorUpholstery;
    }

    public String getFieldMake() {
        return this.mMake;
    }

    public String getFieldModel() {
        return this.mModel;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldTransmission() {
        return this.mTransmission;
    }

    public String getFieldTrim() {
        return this.mTrim;
    }

    public Object getFieldUnitPrice() {
        return this.mUnitPrice;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public Long getFieldYear() {
        return this.mYear;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AutomotiveModel copyFrom(AutomotiveModel instance) {
        this.mApplinks = instance.mApplinks;
        this.mAutomotiveModelId = instance.mAutomotiveModelId;
        this.mAvailability = instance.mAvailability;
        this.mBodyStyle = instance.mBodyStyle;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCurrency = instance.mCurrency;
        this.mCustomLabel0 = instance.mCustomLabel0;
        this.mDescription = instance.mDescription;
        this.mDrivetrain = instance.mDrivetrain;
        this.mExteriorColor = instance.mExteriorColor;
        this.mFinanceDescription = instance.mFinanceDescription;
        this.mFinanceType = instance.mFinanceType;
        this.mFuelType = instance.mFuelType;
        this.mGeneration = instance.mGeneration;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mInteriorColor = instance.mInteriorColor;
        this.mInteriorUpholstery = instance.mInteriorUpholstery;
        this.mMake = instance.mMake;
        this.mModel = instance.mModel;
        this.mPrice = instance.mPrice;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mTitle = instance.mTitle;
        this.mTransmission = instance.mTransmission;
        this.mTrim = instance.mTrim;
        this.mUnitPrice = instance.mUnitPrice;
        this.mUrl = instance.mUrl;
        this.mYear = instance.mYear;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AutomotiveModel> getParser() {
        return new APIRequest.ResponseParser<AutomotiveModel>(){

            @Override
            public APINodeList<AutomotiveModel> parseResponse(String response, APIContext context, APIRequest<AutomotiveModel> request, String header) throws APIException.MalformedResponseException {
                return AutomotiveModel.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumBodyStyle {
        VALUE_CONVERTIBLE("CONVERTIBLE"),
        VALUE_COUPE("COUPE"),
        VALUE_CROSSOVER("CROSSOVER"),
        VALUE_ESTATE("ESTATE"),
        VALUE_GRANDTOURER("GRANDTOURER"),
        VALUE_HATCHBACK("HATCHBACK"),
        VALUE_MINIBUS("MINIBUS"),
        VALUE_MINIVAN("MINIVAN"),
        VALUE_MPV("MPV"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER"),
        VALUE_PICKUP("PICKUP"),
        VALUE_ROADSTER("ROADSTER"),
        VALUE_SALOON("SALOON"),
        VALUE_SEDAN("SEDAN"),
        VALUE_SMALL_CAR("SMALL_CAR"),
        VALUE_SPORTSCAR("SPORTSCAR"),
        VALUE_SUPERCAR("SUPERCAR"),
        VALUE_SUPERMINI("SUPERMINI"),
        VALUE_SUV("SUV"),
        VALUE_TRUCK("TRUCK"),
        VALUE_VAN("VAN"),
        VALUE_WAGON("WAGON");

        private String value;

        private EnumBodyStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<AutomotiveModel> {
        AutomotiveModel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"applinks", "automotive_model_id", "availability", "body_style", "category_specific_fields", "currency", "custom_label_0", "description", "drivetrain", "exterior_color", "finance_description", "finance_type", "fuel_type", "generation", "id", "image_fetch_status", "images", "interior_color", "interior_upholstery", "make", "model", "price", "sanitized_images", "title", "transmission", "trim", "unit_price", "url", "year"};

        @Override
        public AutomotiveModel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AutomotiveModel parseResponse(String response, String header) throws APIException {
            return AutomotiveModel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AutomotiveModel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AutomotiveModel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AutomotiveModel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AutomotiveModel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AutomotiveModel>(){

                public AutomotiveModel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAutomotiveModelIdField() {
            return this.requestAutomotiveModelIdField(true);
        }

        public APIRequestGet requestAutomotiveModelIdField(boolean value) {
            this.requestField("automotive_model_id", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestBodyStyleField() {
            return this.requestBodyStyleField(true);
        }

        public APIRequestGet requestBodyStyleField(boolean value) {
            this.requestField("body_style", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGet requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDrivetrainField() {
            return this.requestDrivetrainField(true);
        }

        public APIRequestGet requestDrivetrainField(boolean value) {
            this.requestField("drivetrain", value);
            return this;
        }

        public APIRequestGet requestExteriorColorField() {
            return this.requestExteriorColorField(true);
        }

        public APIRequestGet requestExteriorColorField(boolean value) {
            this.requestField("exterior_color", value);
            return this;
        }

        public APIRequestGet requestFinanceDescriptionField() {
            return this.requestFinanceDescriptionField(true);
        }

        public APIRequestGet requestFinanceDescriptionField(boolean value) {
            this.requestField("finance_description", value);
            return this;
        }

        public APIRequestGet requestFinanceTypeField() {
            return this.requestFinanceTypeField(true);
        }

        public APIRequestGet requestFinanceTypeField(boolean value) {
            this.requestField("finance_type", value);
            return this;
        }

        public APIRequestGet requestFuelTypeField() {
            return this.requestFuelTypeField(true);
        }

        public APIRequestGet requestFuelTypeField(boolean value) {
            this.requestField("fuel_type", value);
            return this;
        }

        public APIRequestGet requestGenerationField() {
            return this.requestGenerationField(true);
        }

        public APIRequestGet requestGenerationField(boolean value) {
            this.requestField("generation", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestInteriorColorField() {
            return this.requestInteriorColorField(true);
        }

        public APIRequestGet requestInteriorColorField(boolean value) {
            this.requestField("interior_color", value);
            return this;
        }

        public APIRequestGet requestInteriorUpholsteryField() {
            return this.requestInteriorUpholsteryField(true);
        }

        public APIRequestGet requestInteriorUpholsteryField(boolean value) {
            this.requestField("interior_upholstery", value);
            return this;
        }

        public APIRequestGet requestMakeField() {
            return this.requestMakeField(true);
        }

        public APIRequestGet requestMakeField(boolean value) {
            this.requestField("make", value);
            return this;
        }

        public APIRequestGet requestModelField() {
            return this.requestModelField(true);
        }

        public APIRequestGet requestModelField(boolean value) {
            this.requestField("model", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTransmissionField() {
            return this.requestTransmissionField(true);
        }

        public APIRequestGet requestTransmissionField(boolean value) {
            this.requestField("transmission", value);
            return this;
        }

        public APIRequestGet requestTrimField() {
            return this.requestTrimField(true);
        }

        public APIRequestGet requestTrimField(boolean value) {
            this.requestField("trim", value);
            return this;
        }

        public APIRequestGet requestUnitPriceField() {
            return this.requestUnitPriceField(true);
        }

        public APIRequestGet requestUnitPriceField(boolean value) {
            this.requestField("unit_price", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestYearField() {
            return this.requestYearField(true);
        }

        public APIRequestGet requestYearField(boolean value) {
            this.requestField("year", value);
            return this;
        }
    }

    public static class APIRequestGetVideosMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }

    public static class APIRequestGetAugmentedRealitiesMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAugmentedRealitiesMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/augmented_realities_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAugmentedRealitiesMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

