/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ProductItemARData
extends APINode {
    @SerializedName(value="container_effect")
    private String mContainerEffect = null;
    @SerializedName(value="effect_icon")
    private String mEffectIcon = null;
    @SerializedName(value="effect_parameters")
    private Object mEffectParameters = null;
    @SerializedName(value="picker_icon")
    private String mPickerIcon = null;
    @SerializedName(value="product_ar_link")
    private Object mProductArLink = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="surfaces")
    private List<EnumSurfaces> mSurfaces = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductItemARData loadJSON(String json, APIContext context, String header) {
        ProductItemARData productItemARData = (ProductItemARData)ProductItemARData.getGson().fromJson(json, ProductItemARData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productItemARData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productItemARData.context = context;
        productItemARData.rawValue = json;
        productItemARData.header = header;
        return productItemARData;
    }

    public static APINodeList<ProductItemARData> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductItemARData> productItemARDatas = new APINodeList<ProductItemARData>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productItemARDatas.add(ProductItemARData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productItemARDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productItemARDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productItemARDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productItemARDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productItemARDatas.add(ProductItemARData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productItemARDatas.add(ProductItemARData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productItemARDatas.add(ProductItemARData.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productItemARDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productItemARDatas.add(ProductItemARData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productItemARDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productItemARDatas.add(ProductItemARData.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productItemARDatas;
                }
                productItemARDatas.clear();
                productItemARDatas.add(ProductItemARData.loadJSON(json, context, header));
                return productItemARDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductItemARData.getGson().toJson((Object)this);
    }

    public String getFieldContainerEffect() {
        return this.mContainerEffect;
    }

    public ProductItemARData setFieldContainerEffect(String value) {
        this.mContainerEffect = value;
        return this;
    }

    public String getFieldEffectIcon() {
        return this.mEffectIcon;
    }

    public ProductItemARData setFieldEffectIcon(String value) {
        this.mEffectIcon = value;
        return this;
    }

    public Object getFieldEffectParameters() {
        return this.mEffectParameters;
    }

    public ProductItemARData setFieldEffectParameters(Object value) {
        this.mEffectParameters = value;
        return this;
    }

    public String getFieldPickerIcon() {
        return this.mPickerIcon;
    }

    public ProductItemARData setFieldPickerIcon(String value) {
        this.mPickerIcon = value;
        return this;
    }

    public Object getFieldProductArLink() {
        return this.mProductArLink;
    }

    public ProductItemARData setFieldProductArLink(Object value) {
        this.mProductArLink = value;
        return this;
    }

    public String getFieldState() {
        return this.mState;
    }

    public ProductItemARData setFieldState(String value) {
        this.mState = value;
        return this;
    }

    public List<EnumSurfaces> getFieldSurfaces() {
        return this.mSurfaces;
    }

    public ProductItemARData setFieldSurfaces(List<EnumSurfaces> value) {
        this.mSurfaces = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductItemARData copyFrom(ProductItemARData instance) {
        this.mContainerEffect = instance.mContainerEffect;
        this.mEffectIcon = instance.mEffectIcon;
        this.mEffectParameters = instance.mEffectParameters;
        this.mPickerIcon = instance.mPickerIcon;
        this.mProductArLink = instance.mProductArLink;
        this.mState = instance.mState;
        this.mSurfaces = instance.mSurfaces;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductItemARData> getParser() {
        return new APIRequest.ResponseParser<ProductItemARData>(){

            @Override
            public APINodeList<ProductItemARData> parseResponse(String response, APIContext context, APIRequest<ProductItemARData> request, String header) throws APIException.MalformedResponseException {
                return ProductItemARData.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumSurfaces {
        VALUE_B2C_MARKETPLACE("B2C_MARKETPLACE"),
        VALUE_C2C_MARKETPLACE("C2C_MARKETPLACE"),
        VALUE_DA("DA"),
        VALUE_DAILY_DEALS("DAILY_DEALS"),
        VALUE_DAILY_DEALS_LEGACY("DAILY_DEALS_LEGACY"),
        VALUE_IG_PRODUCT_TAGGING("IG_PRODUCT_TAGGING"),
        VALUE_MARKETPLACE("MARKETPLACE"),
        VALUE_MARKETPLACE_ADS_DEPRECATED("MARKETPLACE_ADS_DEPRECATED"),
        VALUE_MARKETPLACE_SHOPS("MARKETPLACE_SHOPS"),
        VALUE_OFFLINE_CONVERSIONS("OFFLINE_CONVERSIONS"),
        VALUE_SHOPS("SHOPS"),
        VALUE_UNIVERSAL_CHECKOUT("UNIVERSAL_CHECKOUT"),
        VALUE_WHATSAPP("WHATSAPP");

        private String value;

        private EnumSurfaces(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

