/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HomeListing
extends APINode {
    @SerializedName(value="ac_type")
    private String mAcType = null;
    @SerializedName(value="additional_fees_description")
    private String mAdditionalFeesDescription = null;
    @SerializedName(value="address")
    private Object mAddress = null;
    @SerializedName(value="agent_company")
    private String mAgentCompany = null;
    @SerializedName(value="agent_email")
    private String mAgentEmail = null;
    @SerializedName(value="agent_fb_page_id")
    private Page mAgentFbPageId = null;
    @SerializedName(value="agent_name")
    private String mAgentName = null;
    @SerializedName(value="agent_phone")
    private String mAgentPhone = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="area_size")
    private Long mAreaSize = null;
    @SerializedName(value="area_unit")
    private String mAreaUnit = null;
    @SerializedName(value="availability")
    private String mAvailability = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="co_2_emission_rating_eu")
    private Object mCo2EmissionRatingEu = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="days_on_market")
    private Long mDaysOnMarket = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="energy_rating_eu")
    private Object mEnergyRatingEu = null;
    @SerializedName(value="furnish_type")
    private String mFurnishType = null;
    @SerializedName(value="group_id")
    private String mGroupId = null;
    @SerializedName(value="heating_type")
    private String mHeatingType = null;
    @SerializedName(value="home_listing_id")
    private String mHomeListingId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="laundry_type")
    private String mLaundryType = null;
    @SerializedName(value="listing_type")
    private String mListingType = null;
    @SerializedName(value="max_currency")
    private String mMaxCurrency = null;
    @SerializedName(value="max_price")
    private String mMaxPrice = null;
    @SerializedName(value="min_currency")
    private String mMinCurrency = null;
    @SerializedName(value="min_price")
    private String mMinPrice = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="num_baths")
    private Double mNumBaths = null;
    @SerializedName(value="num_beds")
    private Double mNumBeds = null;
    @SerializedName(value="num_rooms")
    private Double mNumRooms = null;
    @SerializedName(value="num_units")
    private Long mNumUnits = null;
    @SerializedName(value="parking_type")
    private String mParkingType = null;
    @SerializedName(value="partner_verification")
    private String mPartnerVerification = null;
    @SerializedName(value="pet_policy")
    private String mPetPolicy = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="property_type")
    private String mPropertyType = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="year_built")
    private Long mYearBuilt = null;
    protected static Gson gson = null;

    HomeListing() {
    }

    public HomeListing(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public HomeListing(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public HomeListing fetch() throws APIException {
        HomeListing newInstance = HomeListing.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static HomeListing fetchById(Long id, APIContext context) throws APIException {
        return HomeListing.fetchById(id.toString(), context);
    }

    public static ListenableFuture<HomeListing> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return HomeListing.fetchByIdAsync(id.toString(), context);
    }

    public static HomeListing fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<HomeListing> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<HomeListing> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<HomeListing>(context, "", "/", "GET", HomeListing.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<HomeListing>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<HomeListing>(context, "", "/", "GET", HomeListing.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static HomeListing loadJSON(String json, APIContext context, String header) {
        HomeListing homeListing = (HomeListing)HomeListing.getGson().fromJson(json, HomeListing.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(homeListing.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        homeListing.context = context;
        homeListing.rawValue = json;
        homeListing.header = header;
        return homeListing;
    }

    public static APINodeList<HomeListing> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<HomeListing> homeListings = new APINodeList<HomeListing>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        homeListings.add(HomeListing.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return homeListings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            homeListings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        homeListings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            homeListings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            homeListings.add(HomeListing.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                homeListings.add(HomeListing.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            homeListings.add(HomeListing.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return homeListings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        homeListings.add(HomeListing.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return homeListings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        homeListings.add(HomeListing.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return homeListings;
                }
                homeListings.clear();
                homeListings.add(HomeListing.loadJSON(json, context, header));
                return homeListings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return HomeListing.getGson().toJson((Object)this);
    }

    public APIRequestGetAugmentedRealitiesMetadata getAugmentedRealitiesMetadata() {
        return new APIRequestGetAugmentedRealitiesMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAcType() {
        return this.mAcType;
    }

    public String getFieldAdditionalFeesDescription() {
        return this.mAdditionalFeesDescription;
    }

    public Object getFieldAddress() {
        return this.mAddress;
    }

    public String getFieldAgentCompany() {
        return this.mAgentCompany;
    }

    public String getFieldAgentEmail() {
        return this.mAgentEmail;
    }

    public Page getFieldAgentFbPageId() {
        if (this.mAgentFbPageId != null) {
            this.mAgentFbPageId.context = this.getContext();
        }
        return this.mAgentFbPageId;
    }

    public String getFieldAgentName() {
        return this.mAgentName;
    }

    public String getFieldAgentPhone() {
        return this.mAgentPhone;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public Long getFieldAreaSize() {
        return this.mAreaSize;
    }

    public String getFieldAreaUnit() {
        return this.mAreaUnit;
    }

    public String getFieldAvailability() {
        return this.mAvailability;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public Object getFieldCo2EmissionRatingEu() {
        return this.mCo2EmissionRatingEu;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public Long getFieldDaysOnMarket() {
        return this.mDaysOnMarket;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Object getFieldEnergyRatingEu() {
        return this.mEnergyRatingEu;
    }

    public String getFieldFurnishType() {
        return this.mFurnishType;
    }

    public String getFieldGroupId() {
        return this.mGroupId;
    }

    public String getFieldHeatingType() {
        return this.mHeatingType;
    }

    public String getFieldHomeListingId() {
        return this.mHomeListingId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLaundryType() {
        return this.mLaundryType;
    }

    public String getFieldListingType() {
        return this.mListingType;
    }

    public String getFieldMaxCurrency() {
        return this.mMaxCurrency;
    }

    public String getFieldMaxPrice() {
        return this.mMaxPrice;
    }

    public String getFieldMinCurrency() {
        return this.mMinCurrency;
    }

    public String getFieldMinPrice() {
        return this.mMinPrice;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Double getFieldNumBaths() {
        return this.mNumBaths;
    }

    public Double getFieldNumBeds() {
        return this.mNumBeds;
    }

    public Double getFieldNumRooms() {
        return this.mNumRooms;
    }

    public Long getFieldNumUnits() {
        return this.mNumUnits;
    }

    public String getFieldParkingType() {
        return this.mParkingType;
    }

    public String getFieldPartnerVerification() {
        return this.mPartnerVerification;
    }

    public String getFieldPetPolicy() {
        return this.mPetPolicy;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public String getFieldPropertyType() {
        return this.mPropertyType;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public Long getFieldYearBuilt() {
        return this.mYearBuilt;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public HomeListing copyFrom(HomeListing instance) {
        this.mAcType = instance.mAcType;
        this.mAdditionalFeesDescription = instance.mAdditionalFeesDescription;
        this.mAddress = instance.mAddress;
        this.mAgentCompany = instance.mAgentCompany;
        this.mAgentEmail = instance.mAgentEmail;
        this.mAgentFbPageId = instance.mAgentFbPageId;
        this.mAgentName = instance.mAgentName;
        this.mAgentPhone = instance.mAgentPhone;
        this.mApplinks = instance.mApplinks;
        this.mAreaSize = instance.mAreaSize;
        this.mAreaUnit = instance.mAreaUnit;
        this.mAvailability = instance.mAvailability;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCo2EmissionRatingEu = instance.mCo2EmissionRatingEu;
        this.mCurrency = instance.mCurrency;
        this.mDaysOnMarket = instance.mDaysOnMarket;
        this.mDescription = instance.mDescription;
        this.mEnergyRatingEu = instance.mEnergyRatingEu;
        this.mFurnishType = instance.mFurnishType;
        this.mGroupId = instance.mGroupId;
        this.mHeatingType = instance.mHeatingType;
        this.mHomeListingId = instance.mHomeListingId;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mLaundryType = instance.mLaundryType;
        this.mListingType = instance.mListingType;
        this.mMaxCurrency = instance.mMaxCurrency;
        this.mMaxPrice = instance.mMaxPrice;
        this.mMinCurrency = instance.mMinCurrency;
        this.mMinPrice = instance.mMinPrice;
        this.mName = instance.mName;
        this.mNumBaths = instance.mNumBaths;
        this.mNumBeds = instance.mNumBeds;
        this.mNumRooms = instance.mNumRooms;
        this.mNumUnits = instance.mNumUnits;
        this.mParkingType = instance.mParkingType;
        this.mPartnerVerification = instance.mPartnerVerification;
        this.mPetPolicy = instance.mPetPolicy;
        this.mPrice = instance.mPrice;
        this.mPropertyType = instance.mPropertyType;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mUrl = instance.mUrl;
        this.mYearBuilt = instance.mYearBuilt;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<HomeListing> getParser() {
        return new APIRequest.ResponseParser<HomeListing>(){

            @Override
            public APINodeList<HomeListing> parseResponse(String response, APIContext context, APIRequest<HomeListing> request, String header) throws APIException.MalformedResponseException {
                return HomeListing.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<HomeListing> {
        HomeListing lastResponse = null;
        public static final String[] PARAMS = new String[]{"address", "availability", "currency", "description", "images", "listing_type", "name", "num_baths", "num_beds", "num_units", "price", "property_type", "url", "year_built"};
        public static final String[] FIELDS = new String[0];

        @Override
        public HomeListing getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public HomeListing parseResponse(String response, String header) throws APIException {
            return HomeListing.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public HomeListing execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public HomeListing execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<HomeListing> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<HomeListing> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, HomeListing>(){

                public HomeListing apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAddress(Object address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setAvailability(String availability) {
            this.setParam("availability", availability);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setListingType(String listingType) {
            this.setParam("listing_type", listingType);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setNumBaths(Double numBaths) {
            this.setParam("num_baths", numBaths);
            return this;
        }

        public APIRequestUpdate setNumBaths(String numBaths) {
            this.setParam("num_baths", numBaths);
            return this;
        }

        public APIRequestUpdate setNumBeds(Double numBeds) {
            this.setParam("num_beds", numBeds);
            return this;
        }

        public APIRequestUpdate setNumBeds(String numBeds) {
            this.setParam("num_beds", numBeds);
            return this;
        }

        public APIRequestUpdate setNumUnits(Double numUnits) {
            this.setParam("num_units", numUnits);
            return this;
        }

        public APIRequestUpdate setNumUnits(String numUnits) {
            this.setParam("num_units", numUnits);
            return this;
        }

        public APIRequestUpdate setPrice(Double price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setPrice(String price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setPropertyType(String propertyType) {
            this.setParam("property_type", propertyType);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate setYearBuilt(Long yearBuilt) {
            this.setParam("year_built", yearBuilt);
            return this;
        }

        public APIRequestUpdate setYearBuilt(String yearBuilt) {
            this.setParam("year_built", yearBuilt);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<HomeListing> {
        HomeListing lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ac_type", "additional_fees_description", "address", "agent_company", "agent_email", "agent_fb_page_id", "agent_name", "agent_phone", "applinks", "area_size", "area_unit", "availability", "category_specific_fields", "co_2_emission_rating_eu", "currency", "days_on_market", "description", "energy_rating_eu", "furnish_type", "group_id", "heating_type", "home_listing_id", "id", "image_fetch_status", "images", "laundry_type", "listing_type", "max_currency", "max_price", "min_currency", "min_price", "name", "num_baths", "num_beds", "num_rooms", "num_units", "parking_type", "partner_verification", "pet_policy", "price", "property_type", "sanitized_images", "url", "year_built"};

        @Override
        public HomeListing getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public HomeListing parseResponse(String response, String header) throws APIException {
            return HomeListing.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public HomeListing execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public HomeListing execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<HomeListing> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<HomeListing> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, HomeListing>(){

                public HomeListing apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAcTypeField() {
            return this.requestAcTypeField(true);
        }

        public APIRequestGet requestAcTypeField(boolean value) {
            this.requestField("ac_type", value);
            return this;
        }

        public APIRequestGet requestAdditionalFeesDescriptionField() {
            return this.requestAdditionalFeesDescriptionField(true);
        }

        public APIRequestGet requestAdditionalFeesDescriptionField(boolean value) {
            this.requestField("additional_fees_description", value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestAgentCompanyField() {
            return this.requestAgentCompanyField(true);
        }

        public APIRequestGet requestAgentCompanyField(boolean value) {
            this.requestField("agent_company", value);
            return this;
        }

        public APIRequestGet requestAgentEmailField() {
            return this.requestAgentEmailField(true);
        }

        public APIRequestGet requestAgentEmailField(boolean value) {
            this.requestField("agent_email", value);
            return this;
        }

        public APIRequestGet requestAgentFbPageIdField() {
            return this.requestAgentFbPageIdField(true);
        }

        public APIRequestGet requestAgentFbPageIdField(boolean value) {
            this.requestField("agent_fb_page_id", value);
            return this;
        }

        public APIRequestGet requestAgentNameField() {
            return this.requestAgentNameField(true);
        }

        public APIRequestGet requestAgentNameField(boolean value) {
            this.requestField("agent_name", value);
            return this;
        }

        public APIRequestGet requestAgentPhoneField() {
            return this.requestAgentPhoneField(true);
        }

        public APIRequestGet requestAgentPhoneField(boolean value) {
            this.requestField("agent_phone", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAreaSizeField() {
            return this.requestAreaSizeField(true);
        }

        public APIRequestGet requestAreaSizeField(boolean value) {
            this.requestField("area_size", value);
            return this;
        }

        public APIRequestGet requestAreaUnitField() {
            return this.requestAreaUnitField(true);
        }

        public APIRequestGet requestAreaUnitField(boolean value) {
            this.requestField("area_unit", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestCo2EmissionRatingEuField() {
            return this.requestCo2EmissionRatingEuField(true);
        }

        public APIRequestGet requestCo2EmissionRatingEuField(boolean value) {
            this.requestField("co_2_emission_rating_eu", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDaysOnMarketField() {
            return this.requestDaysOnMarketField(true);
        }

        public APIRequestGet requestDaysOnMarketField(boolean value) {
            this.requestField("days_on_market", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEnergyRatingEuField() {
            return this.requestEnergyRatingEuField(true);
        }

        public APIRequestGet requestEnergyRatingEuField(boolean value) {
            this.requestField("energy_rating_eu", value);
            return this;
        }

        public APIRequestGet requestFurnishTypeField() {
            return this.requestFurnishTypeField(true);
        }

        public APIRequestGet requestFurnishTypeField(boolean value) {
            this.requestField("furnish_type", value);
            return this;
        }

        public APIRequestGet requestGroupIdField() {
            return this.requestGroupIdField(true);
        }

        public APIRequestGet requestGroupIdField(boolean value) {
            this.requestField("group_id", value);
            return this;
        }

        public APIRequestGet requestHeatingTypeField() {
            return this.requestHeatingTypeField(true);
        }

        public APIRequestGet requestHeatingTypeField(boolean value) {
            this.requestField("heating_type", value);
            return this;
        }

        public APIRequestGet requestHomeListingIdField() {
            return this.requestHomeListingIdField(true);
        }

        public APIRequestGet requestHomeListingIdField(boolean value) {
            this.requestField("home_listing_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLaundryTypeField() {
            return this.requestLaundryTypeField(true);
        }

        public APIRequestGet requestLaundryTypeField(boolean value) {
            this.requestField("laundry_type", value);
            return this;
        }

        public APIRequestGet requestListingTypeField() {
            return this.requestListingTypeField(true);
        }

        public APIRequestGet requestListingTypeField(boolean value) {
            this.requestField("listing_type", value);
            return this;
        }

        public APIRequestGet requestMaxCurrencyField() {
            return this.requestMaxCurrencyField(true);
        }

        public APIRequestGet requestMaxCurrencyField(boolean value) {
            this.requestField("max_currency", value);
            return this;
        }

        public APIRequestGet requestMaxPriceField() {
            return this.requestMaxPriceField(true);
        }

        public APIRequestGet requestMaxPriceField(boolean value) {
            this.requestField("max_price", value);
            return this;
        }

        public APIRequestGet requestMinCurrencyField() {
            return this.requestMinCurrencyField(true);
        }

        public APIRequestGet requestMinCurrencyField(boolean value) {
            this.requestField("min_currency", value);
            return this;
        }

        public APIRequestGet requestMinPriceField() {
            return this.requestMinPriceField(true);
        }

        public APIRequestGet requestMinPriceField(boolean value) {
            this.requestField("min_price", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNumBathsField() {
            return this.requestNumBathsField(true);
        }

        public APIRequestGet requestNumBathsField(boolean value) {
            this.requestField("num_baths", value);
            return this;
        }

        public APIRequestGet requestNumBedsField() {
            return this.requestNumBedsField(true);
        }

        public APIRequestGet requestNumBedsField(boolean value) {
            this.requestField("num_beds", value);
            return this;
        }

        public APIRequestGet requestNumRoomsField() {
            return this.requestNumRoomsField(true);
        }

        public APIRequestGet requestNumRoomsField(boolean value) {
            this.requestField("num_rooms", value);
            return this;
        }

        public APIRequestGet requestNumUnitsField() {
            return this.requestNumUnitsField(true);
        }

        public APIRequestGet requestNumUnitsField(boolean value) {
            this.requestField("num_units", value);
            return this;
        }

        public APIRequestGet requestParkingTypeField() {
            return this.requestParkingTypeField(true);
        }

        public APIRequestGet requestParkingTypeField(boolean value) {
            this.requestField("parking_type", value);
            return this;
        }

        public APIRequestGet requestPartnerVerificationField() {
            return this.requestPartnerVerificationField(true);
        }

        public APIRequestGet requestPartnerVerificationField(boolean value) {
            this.requestField("partner_verification", value);
            return this;
        }

        public APIRequestGet requestPetPolicyField() {
            return this.requestPetPolicyField(true);
        }

        public APIRequestGet requestPetPolicyField(boolean value) {
            this.requestField("pet_policy", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestPropertyTypeField() {
            return this.requestPropertyTypeField(true);
        }

        public APIRequestGet requestPropertyTypeField(boolean value) {
            this.requestField("property_type", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestYearBuiltField() {
            return this.requestYearBuiltField(true);
        }

        public APIRequestGet requestYearBuiltField(boolean value) {
            this.requestField("year_built", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetVideosMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }

    public static class APIRequestGetAugmentedRealitiesMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAugmentedRealitiesMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/augmented_realities_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAugmentedRealitiesMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

