/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vehicle
extends APINode {
    @SerializedName(value="address")
    private Object mAddress = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="availability")
    private String mAvailability = null;
    @SerializedName(value="body_style")
    private String mBodyStyle = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="condition")
    private String mCondition = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="custom_label_0")
    private String mCustomLabel0 = null;
    @SerializedName(value="date_first_on_lot")
    private String mDateFirstOnLot = null;
    @SerializedName(value="dealer_communication_channel")
    private String mDealerCommunicationChannel = null;
    @SerializedName(value="dealer_email")
    private String mDealerEmail = null;
    @SerializedName(value="dealer_id")
    private String mDealerId = null;
    @SerializedName(value="dealer_name")
    private String mDealerName = null;
    @SerializedName(value="dealer_phone")
    private String mDealerPhone = null;
    @SerializedName(value="dealer_privacy_policy_url")
    private String mDealerPrivacyPolicyUrl = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="drivetrain")
    private String mDrivetrain = null;
    @SerializedName(value="exterior_color")
    private String mExteriorColor = null;
    @SerializedName(value="fb_page_id")
    private Page mFbPageId = null;
    @SerializedName(value="features")
    private List<Object> mFeatures = null;
    @SerializedName(value="fuel_type")
    private String mFuelType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="interior_color")
    private String mInteriorColor = null;
    @SerializedName(value="legal_disclosure_impressum_url")
    private String mLegalDisclosureImpressumUrl = null;
    @SerializedName(value="make")
    private String mMake = null;
    @SerializedName(value="mileage")
    private Object mMileage = null;
    @SerializedName(value="model")
    private String mModel = null;
    @SerializedName(value="previous_currency")
    private String mPreviousCurrency = null;
    @SerializedName(value="previous_price")
    private String mPreviousPrice = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="sale_currency")
    private String mSaleCurrency = null;
    @SerializedName(value="sale_price")
    private String mSalePrice = null;
    @SerializedName(value="sanitized_images")
    private List<String> mSanitizedImages = null;
    @SerializedName(value="state_of_vehicle")
    private String mStateOfVehicle = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="transmission")
    private String mTransmission = null;
    @SerializedName(value="trim")
    private String mTrim = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="vehicle_id")
    private String mVehicleId = null;
    @SerializedName(value="vehicle_registration_plate")
    private String mVehicleRegistrationPlate = null;
    @SerializedName(value="vehicle_specifications")
    private List<Object> mVehicleSpecifications = null;
    @SerializedName(value="vehicle_type")
    private String mVehicleType = null;
    @SerializedName(value="vin")
    private String mVin = null;
    @SerializedName(value="year")
    private Long mYear = null;
    protected static Gson gson = null;

    Vehicle() {
    }

    public Vehicle(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Vehicle(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Vehicle fetch() throws APIException {
        Vehicle newInstance = Vehicle.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Vehicle fetchById(Long id, APIContext context) throws APIException {
        return Vehicle.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Vehicle> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Vehicle.fetchByIdAsync(id.toString(), context);
    }

    public static Vehicle fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Vehicle> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Vehicle> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Vehicle>(context, "", "/", "GET", Vehicle.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Vehicle>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Vehicle>(context, "", "/", "GET", Vehicle.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Vehicle loadJSON(String json, APIContext context, String header) {
        Vehicle vehicle = (Vehicle)Vehicle.getGson().fromJson(json, Vehicle.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(vehicle.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        vehicle.context = context;
        vehicle.rawValue = json;
        vehicle.header = header;
        return vehicle;
    }

    public static APINodeList<Vehicle> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Vehicle> vehicles = new APINodeList<Vehicle>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        vehicles.add(Vehicle.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return vehicles;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            vehicles.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        vehicles.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            vehicles.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            vehicles.add(Vehicle.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                vehicles.add(Vehicle.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            vehicles.add(Vehicle.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return vehicles;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        vehicles.add(Vehicle.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return vehicles;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        vehicles.add(Vehicle.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return vehicles;
                }
                vehicles.clear();
                vehicles.add(Vehicle.loadJSON(json, context, header));
                return vehicles;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Vehicle.getGson().toJson((Object)this);
    }

    public APIRequestGetAugmentedRealitiesMetadata getAugmentedRealitiesMetadata() {
        return new APIRequestGetAugmentedRealitiesMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldAddress() {
        return this.mAddress;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public String getFieldAvailability() {
        return this.mAvailability;
    }

    public String getFieldBodyStyle() {
        return this.mBodyStyle;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldCondition() {
        return this.mCondition;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldCustomLabel0() {
        return this.mCustomLabel0;
    }

    public String getFieldDateFirstOnLot() {
        return this.mDateFirstOnLot;
    }

    public String getFieldDealerCommunicationChannel() {
        return this.mDealerCommunicationChannel;
    }

    public String getFieldDealerEmail() {
        return this.mDealerEmail;
    }

    public String getFieldDealerId() {
        return this.mDealerId;
    }

    public String getFieldDealerName() {
        return this.mDealerName;
    }

    public String getFieldDealerPhone() {
        return this.mDealerPhone;
    }

    public String getFieldDealerPrivacyPolicyUrl() {
        return this.mDealerPrivacyPolicyUrl;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDrivetrain() {
        return this.mDrivetrain;
    }

    public String getFieldExteriorColor() {
        return this.mExteriorColor;
    }

    public Page getFieldFbPageId() {
        if (this.mFbPageId != null) {
            this.mFbPageId.context = this.getContext();
        }
        return this.mFbPageId;
    }

    public List<Object> getFieldFeatures() {
        return this.mFeatures;
    }

    public String getFieldFuelType() {
        return this.mFuelType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldInteriorColor() {
        return this.mInteriorColor;
    }

    public String getFieldLegalDisclosureImpressumUrl() {
        return this.mLegalDisclosureImpressumUrl;
    }

    public String getFieldMake() {
        return this.mMake;
    }

    public Object getFieldMileage() {
        return this.mMileage;
    }

    public String getFieldModel() {
        return this.mModel;
    }

    public String getFieldPreviousCurrency() {
        return this.mPreviousCurrency;
    }

    public String getFieldPreviousPrice() {
        return this.mPreviousPrice;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public String getFieldSaleCurrency() {
        return this.mSaleCurrency;
    }

    public String getFieldSalePrice() {
        return this.mSalePrice;
    }

    public List<String> getFieldSanitizedImages() {
        return this.mSanitizedImages;
    }

    public String getFieldStateOfVehicle() {
        return this.mStateOfVehicle;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldTransmission() {
        return this.mTransmission;
    }

    public String getFieldTrim() {
        return this.mTrim;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldVehicleId() {
        return this.mVehicleId;
    }

    public String getFieldVehicleRegistrationPlate() {
        return this.mVehicleRegistrationPlate;
    }

    public List<Object> getFieldVehicleSpecifications() {
        return this.mVehicleSpecifications;
    }

    public String getFieldVehicleType() {
        return this.mVehicleType;
    }

    public String getFieldVin() {
        return this.mVin;
    }

    public Long getFieldYear() {
        return this.mYear;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Vehicle copyFrom(Vehicle instance) {
        this.mAddress = instance.mAddress;
        this.mApplinks = instance.mApplinks;
        this.mAvailability = instance.mAvailability;
        this.mBodyStyle = instance.mBodyStyle;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mCondition = instance.mCondition;
        this.mCurrency = instance.mCurrency;
        this.mCustomLabel0 = instance.mCustomLabel0;
        this.mDateFirstOnLot = instance.mDateFirstOnLot;
        this.mDealerCommunicationChannel = instance.mDealerCommunicationChannel;
        this.mDealerEmail = instance.mDealerEmail;
        this.mDealerId = instance.mDealerId;
        this.mDealerName = instance.mDealerName;
        this.mDealerPhone = instance.mDealerPhone;
        this.mDealerPrivacyPolicyUrl = instance.mDealerPrivacyPolicyUrl;
        this.mDescription = instance.mDescription;
        this.mDrivetrain = instance.mDrivetrain;
        this.mExteriorColor = instance.mExteriorColor;
        this.mFbPageId = instance.mFbPageId;
        this.mFeatures = instance.mFeatures;
        this.mFuelType = instance.mFuelType;
        this.mId = instance.mId;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImages = instance.mImages;
        this.mInteriorColor = instance.mInteriorColor;
        this.mLegalDisclosureImpressumUrl = instance.mLegalDisclosureImpressumUrl;
        this.mMake = instance.mMake;
        this.mMileage = instance.mMileage;
        this.mModel = instance.mModel;
        this.mPreviousCurrency = instance.mPreviousCurrency;
        this.mPreviousPrice = instance.mPreviousPrice;
        this.mPrice = instance.mPrice;
        this.mSaleCurrency = instance.mSaleCurrency;
        this.mSalePrice = instance.mSalePrice;
        this.mSanitizedImages = instance.mSanitizedImages;
        this.mStateOfVehicle = instance.mStateOfVehicle;
        this.mTitle = instance.mTitle;
        this.mTransmission = instance.mTransmission;
        this.mTrim = instance.mTrim;
        this.mUrl = instance.mUrl;
        this.mVehicleId = instance.mVehicleId;
        this.mVehicleRegistrationPlate = instance.mVehicleRegistrationPlate;
        this.mVehicleSpecifications = instance.mVehicleSpecifications;
        this.mVehicleType = instance.mVehicleType;
        this.mVin = instance.mVin;
        this.mYear = instance.mYear;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Vehicle> getParser() {
        return new APIRequest.ResponseParser<Vehicle>(){

            @Override
            public APINodeList<Vehicle> parseResponse(String response, APIContext context, APIRequest<Vehicle> request, String header) throws APIException.MalformedResponseException {
                return Vehicle.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumVehicleType {
        VALUE_BOAT("BOAT"),
        VALUE_CAR_TRUCK("CAR_TRUCK"),
        VALUE_COMMERCIAL("COMMERCIAL"),
        VALUE_MOTORCYCLE("MOTORCYCLE"),
        VALUE_OTHER("OTHER"),
        VALUE_POWERSPORT("POWERSPORT"),
        VALUE_RV_CAMPER("RV_CAMPER"),
        VALUE_TRAILER("TRAILER");

        private String value;

        private EnumVehicleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTransmission {
        VALUE_AUTOMATIC("AUTOMATIC"),
        VALUE_MANUAL("MANUAL"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER");

        private String value;

        private EnumTransmission(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStateOfVehicle {
        VALUE_CPO("CPO"),
        VALUE_NEW("NEW"),
        VALUE_USED("USED");

        private String value;

        private EnumStateOfVehicle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFuelType {
        VALUE_DIESEL("DIESEL"),
        VALUE_ELECTRIC("ELECTRIC"),
        VALUE_FLEX("FLEX"),
        VALUE_GASOLINE("GASOLINE"),
        VALUE_HYBRID("HYBRID"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER"),
        VALUE_PETROL("PETROL"),
        VALUE_PLUGIN_HYBRID("PLUGIN_HYBRID");

        private String value;

        private EnumFuelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDrivetrain {
        VALUE_AWD("AWD"),
        VALUE_FOUR_WD("FOUR_WD"),
        VALUE_FWD("FWD"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER"),
        VALUE_RWD("RWD"),
        VALUE_TWO_WD("TWO_WD");

        private String value;

        private EnumDrivetrain(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCondition {
        VALUE_EXCELLENT("EXCELLENT"),
        VALUE_FAIR("FAIR"),
        VALUE_GOOD("GOOD"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER"),
        VALUE_POOR("POOR"),
        VALUE_VERY_GOOD("VERY_GOOD");

        private String value;

        private EnumCondition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBodyStyle {
        VALUE_CONVERTIBLE("CONVERTIBLE"),
        VALUE_COUPE("COUPE"),
        VALUE_CROSSOVER("CROSSOVER"),
        VALUE_HATCHBACK("HATCHBACK"),
        VALUE_MINIVAN("MINIVAN"),
        VALUE_NONE("NONE"),
        VALUE_OTHER("OTHER"),
        VALUE_SEDAN("SEDAN"),
        VALUE_SMALL_CAR("SMALL_CAR"),
        VALUE_SUV("SUV"),
        VALUE_TRUCK("TRUCK"),
        VALUE_VAN("VAN"),
        VALUE_WAGON("WAGON");

        private String value;

        private EnumBodyStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAvailability {
        VALUE_AVAILABLE("AVAILABLE"),
        VALUE_NOT_AVAILABLE("NOT_AVAILABLE"),
        VALUE_PENDING("PENDING");

        private String value;

        private EnumAvailability(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Vehicle> {
        Vehicle lastResponse = null;
        public static final String[] PARAMS = new String[]{"address", "applinks", "availability", "body_style", "condition", "currency", "date_first_on_lot", "dealer_id", "dealer_name", "dealer_phone", "description", "drivetrain", "exterior_color", "fb_page_id", "fuel_type", "images", "interior_color", "make", "mileage", "model", "price", "state_of_vehicle", "title", "transmission", "trim", "url", "vehicle_type", "vin", "year"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Vehicle getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Vehicle parseResponse(String response, String header) throws APIException {
            return Vehicle.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Vehicle execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Vehicle execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Vehicle> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Vehicle> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Vehicle>(){

                public Vehicle apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAddress(Map<String, String> address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setApplinks(Object applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setApplinks(String applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setAvailability(EnumAvailability availability) {
            this.setParam("availability", (Object)availability);
            return this;
        }

        public APIRequestUpdate setAvailability(String availability) {
            this.setParam("availability", availability);
            return this;
        }

        public APIRequestUpdate setBodyStyle(EnumBodyStyle bodyStyle) {
            this.setParam("body_style", (Object)bodyStyle);
            return this;
        }

        public APIRequestUpdate setBodyStyle(String bodyStyle) {
            this.setParam("body_style", bodyStyle);
            return this;
        }

        public APIRequestUpdate setCondition(EnumCondition condition) {
            this.setParam("condition", (Object)condition);
            return this;
        }

        public APIRequestUpdate setCondition(String condition) {
            this.setParam("condition", condition);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setDateFirstOnLot(String dateFirstOnLot) {
            this.setParam("date_first_on_lot", dateFirstOnLot);
            return this;
        }

        public APIRequestUpdate setDealerId(String dealerId) {
            this.setParam("dealer_id", dealerId);
            return this;
        }

        public APIRequestUpdate setDealerName(String dealerName) {
            this.setParam("dealer_name", dealerName);
            return this;
        }

        public APIRequestUpdate setDealerPhone(String dealerPhone) {
            this.setParam("dealer_phone", dealerPhone);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setDrivetrain(EnumDrivetrain drivetrain) {
            this.setParam("drivetrain", (Object)drivetrain);
            return this;
        }

        public APIRequestUpdate setDrivetrain(String drivetrain) {
            this.setParam("drivetrain", drivetrain);
            return this;
        }

        public APIRequestUpdate setExteriorColor(String exteriorColor) {
            this.setParam("exterior_color", exteriorColor);
            return this;
        }

        public APIRequestUpdate setFbPageId(String fbPageId) {
            this.setParam("fb_page_id", fbPageId);
            return this;
        }

        public APIRequestUpdate setFuelType(EnumFuelType fuelType) {
            this.setParam("fuel_type", (Object)fuelType);
            return this;
        }

        public APIRequestUpdate setFuelType(String fuelType) {
            this.setParam("fuel_type", fuelType);
            return this;
        }

        public APIRequestUpdate setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setInteriorColor(String interiorColor) {
            this.setParam("interior_color", interiorColor);
            return this;
        }

        public APIRequestUpdate setMake(String make) {
            this.setParam("make", make);
            return this;
        }

        public APIRequestUpdate setMileage(Map<String, String> mileage) {
            this.setParam("mileage", mileage);
            return this;
        }

        public APIRequestUpdate setMileage(String mileage) {
            this.setParam("mileage", mileage);
            return this;
        }

        public APIRequestUpdate setModel(String model) {
            this.setParam("model", model);
            return this;
        }

        public APIRequestUpdate setPrice(Long price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setPrice(String price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setStateOfVehicle(EnumStateOfVehicle stateOfVehicle) {
            this.setParam("state_of_vehicle", (Object)stateOfVehicle);
            return this;
        }

        public APIRequestUpdate setStateOfVehicle(String stateOfVehicle) {
            this.setParam("state_of_vehicle", stateOfVehicle);
            return this;
        }

        public APIRequestUpdate setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestUpdate setTransmission(EnumTransmission transmission) {
            this.setParam("transmission", (Object)transmission);
            return this;
        }

        public APIRequestUpdate setTransmission(String transmission) {
            this.setParam("transmission", transmission);
            return this;
        }

        public APIRequestUpdate setTrim(String trim) {
            this.setParam("trim", trim);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate setVehicleType(EnumVehicleType vehicleType) {
            this.setParam("vehicle_type", (Object)vehicleType);
            return this;
        }

        public APIRequestUpdate setVehicleType(String vehicleType) {
            this.setParam("vehicle_type", vehicleType);
            return this;
        }

        public APIRequestUpdate setVin(String vin) {
            this.setParam("vin", vin);
            return this;
        }

        public APIRequestUpdate setYear(Long year) {
            this.setParam("year", year);
            return this;
        }

        public APIRequestUpdate setYear(String year) {
            this.setParam("year", year);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Vehicle> {
        Vehicle lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "applinks", "availability", "body_style", "category_specific_fields", "condition", "currency", "custom_label_0", "date_first_on_lot", "dealer_communication_channel", "dealer_email", "dealer_id", "dealer_name", "dealer_phone", "dealer_privacy_policy_url", "description", "drivetrain", "exterior_color", "fb_page_id", "features", "fuel_type", "id", "image_fetch_status", "images", "interior_color", "legal_disclosure_impressum_url", "make", "mileage", "model", "previous_currency", "previous_price", "price", "sale_currency", "sale_price", "sanitized_images", "state_of_vehicle", "title", "transmission", "trim", "url", "vehicle_id", "vehicle_registration_plate", "vehicle_specifications", "vehicle_type", "vin", "year"};

        @Override
        public Vehicle getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Vehicle parseResponse(String response, String header) throws APIException {
            return Vehicle.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Vehicle execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Vehicle execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Vehicle> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Vehicle> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Vehicle>(){

                public Vehicle apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestBodyStyleField() {
            return this.requestBodyStyleField(true);
        }

        public APIRequestGet requestBodyStyleField(boolean value) {
            this.requestField("body_style", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestConditionField() {
            return this.requestConditionField(true);
        }

        public APIRequestGet requestConditionField(boolean value) {
            this.requestField("condition", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGet requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGet requestDateFirstOnLotField() {
            return this.requestDateFirstOnLotField(true);
        }

        public APIRequestGet requestDateFirstOnLotField(boolean value) {
            this.requestField("date_first_on_lot", value);
            return this;
        }

        public APIRequestGet requestDealerCommunicationChannelField() {
            return this.requestDealerCommunicationChannelField(true);
        }

        public APIRequestGet requestDealerCommunicationChannelField(boolean value) {
            this.requestField("dealer_communication_channel", value);
            return this;
        }

        public APIRequestGet requestDealerEmailField() {
            return this.requestDealerEmailField(true);
        }

        public APIRequestGet requestDealerEmailField(boolean value) {
            this.requestField("dealer_email", value);
            return this;
        }

        public APIRequestGet requestDealerIdField() {
            return this.requestDealerIdField(true);
        }

        public APIRequestGet requestDealerIdField(boolean value) {
            this.requestField("dealer_id", value);
            return this;
        }

        public APIRequestGet requestDealerNameField() {
            return this.requestDealerNameField(true);
        }

        public APIRequestGet requestDealerNameField(boolean value) {
            this.requestField("dealer_name", value);
            return this;
        }

        public APIRequestGet requestDealerPhoneField() {
            return this.requestDealerPhoneField(true);
        }

        public APIRequestGet requestDealerPhoneField(boolean value) {
            this.requestField("dealer_phone", value);
            return this;
        }

        public APIRequestGet requestDealerPrivacyPolicyUrlField() {
            return this.requestDealerPrivacyPolicyUrlField(true);
        }

        public APIRequestGet requestDealerPrivacyPolicyUrlField(boolean value) {
            this.requestField("dealer_privacy_policy_url", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDrivetrainField() {
            return this.requestDrivetrainField(true);
        }

        public APIRequestGet requestDrivetrainField(boolean value) {
            this.requestField("drivetrain", value);
            return this;
        }

        public APIRequestGet requestExteriorColorField() {
            return this.requestExteriorColorField(true);
        }

        public APIRequestGet requestExteriorColorField(boolean value) {
            this.requestField("exterior_color", value);
            return this;
        }

        public APIRequestGet requestFbPageIdField() {
            return this.requestFbPageIdField(true);
        }

        public APIRequestGet requestFbPageIdField(boolean value) {
            this.requestField("fb_page_id", value);
            return this;
        }

        public APIRequestGet requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGet requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGet requestFuelTypeField() {
            return this.requestFuelTypeField(true);
        }

        public APIRequestGet requestFuelTypeField(boolean value) {
            this.requestField("fuel_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestInteriorColorField() {
            return this.requestInteriorColorField(true);
        }

        public APIRequestGet requestInteriorColorField(boolean value) {
            this.requestField("interior_color", value);
            return this;
        }

        public APIRequestGet requestLegalDisclosureImpressumUrlField() {
            return this.requestLegalDisclosureImpressumUrlField(true);
        }

        public APIRequestGet requestLegalDisclosureImpressumUrlField(boolean value) {
            this.requestField("legal_disclosure_impressum_url", value);
            return this;
        }

        public APIRequestGet requestMakeField() {
            return this.requestMakeField(true);
        }

        public APIRequestGet requestMakeField(boolean value) {
            this.requestField("make", value);
            return this;
        }

        public APIRequestGet requestMileageField() {
            return this.requestMileageField(true);
        }

        public APIRequestGet requestMileageField(boolean value) {
            this.requestField("mileage", value);
            return this;
        }

        public APIRequestGet requestModelField() {
            return this.requestModelField(true);
        }

        public APIRequestGet requestModelField(boolean value) {
            this.requestField("model", value);
            return this;
        }

        public APIRequestGet requestPreviousCurrencyField() {
            return this.requestPreviousCurrencyField(true);
        }

        public APIRequestGet requestPreviousCurrencyField(boolean value) {
            this.requestField("previous_currency", value);
            return this;
        }

        public APIRequestGet requestPreviousPriceField() {
            return this.requestPreviousPriceField(true);
        }

        public APIRequestGet requestPreviousPriceField(boolean value) {
            this.requestField("previous_price", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestSaleCurrencyField() {
            return this.requestSaleCurrencyField(true);
        }

        public APIRequestGet requestSaleCurrencyField(boolean value) {
            this.requestField("sale_currency", value);
            return this;
        }

        public APIRequestGet requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGet requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGet requestSanitizedImagesField() {
            return this.requestSanitizedImagesField(true);
        }

        public APIRequestGet requestSanitizedImagesField(boolean value) {
            this.requestField("sanitized_images", value);
            return this;
        }

        public APIRequestGet requestStateOfVehicleField() {
            return this.requestStateOfVehicleField(true);
        }

        public APIRequestGet requestStateOfVehicleField(boolean value) {
            this.requestField("state_of_vehicle", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestTransmissionField() {
            return this.requestTransmissionField(true);
        }

        public APIRequestGet requestTransmissionField(boolean value) {
            this.requestField("transmission", value);
            return this;
        }

        public APIRequestGet requestTrimField() {
            return this.requestTrimField(true);
        }

        public APIRequestGet requestTrimField(boolean value) {
            this.requestField("trim", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestVehicleIdField() {
            return this.requestVehicleIdField(true);
        }

        public APIRequestGet requestVehicleIdField(boolean value) {
            this.requestField("vehicle_id", value);
            return this;
        }

        public APIRequestGet requestVehicleRegistrationPlateField() {
            return this.requestVehicleRegistrationPlateField(true);
        }

        public APIRequestGet requestVehicleRegistrationPlateField(boolean value) {
            this.requestField("vehicle_registration_plate", value);
            return this;
        }

        public APIRequestGet requestVehicleSpecificationsField() {
            return this.requestVehicleSpecificationsField(true);
        }

        public APIRequestGet requestVehicleSpecificationsField(boolean value) {
            this.requestField("vehicle_specifications", value);
            return this;
        }

        public APIRequestGet requestVehicleTypeField() {
            return this.requestVehicleTypeField(true);
        }

        public APIRequestGet requestVehicleTypeField(boolean value) {
            this.requestField("vehicle_type", value);
            return this;
        }

        public APIRequestGet requestVinField() {
            return this.requestVinField(true);
        }

        public APIRequestGet requestVinField(boolean value) {
            this.requestField("vin", value);
            return this;
        }

        public APIRequestGet requestYearField() {
            return this.requestYearField(true);
        }

        public APIRequestGet requestYearField(boolean value) {
            this.requestField("year", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideosMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetVideosMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAugmentedRealitiesMetadata
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAugmentedRealitiesMetadata.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAugmentedRealitiesMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/augmented_realities_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAugmentedRealitiesMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAugmentedRealitiesMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAugmentedRealitiesMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

