/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleEvaluationSpec;
import com.facebook.ads.sdk.AdRuleExecutionSpec;
import com.facebook.ads.sdk.AdRuleHistory;
import com.facebook.ads.sdk.AdRuleScheduleSpec;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRule
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="evaluation_spec")
    private AdRuleEvaluationSpec mEvaluationSpec = null;
    @SerializedName(value="execution_spec")
    private AdRuleExecutionSpec mExecutionSpec = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="schedule_spec")
    private AdRuleScheduleSpec mScheduleSpec = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdRule() {
    }

    public AdRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdRule fetch() throws APIException {
        AdRule newInstance = AdRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdRule fetchById(Long id, APIContext context) throws APIException {
        return AdRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdRule.fetchByIdAsync(id.toString(), context);
    }

    public static AdRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdRule>(context, "", "/", "GET", AdRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdRule>(context, "", "/", "GET", AdRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdRule loadJSON(String json, APIContext context, String header) {
        AdRule adRule = (AdRule)AdRule.getGson().fromJson(json, AdRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRule.context = context;
        adRule.rawValue = json;
        adRule.header = header;
        return adRule;
    }

    public static APINodeList<AdRule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRule> adRules = new APINodeList<AdRule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRules.add(AdRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRules.add(AdRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRules.add(AdRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRules.add(AdRule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRules.add(AdRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRules.add(AdRule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRules;
                }
                adRules.clear();
                adRules.add(AdRule.loadJSON(json, context, header));
                return adRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRule.getGson().toJson((Object)this);
    }

    public APIRequestCreateExecute createExecute() {
        return new APIRequestCreateExecute(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetHistory getHistory() {
        return new APIRequestGetHistory(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePreview createPreview() {
        return new APIRequestCreatePreview(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public AdRuleEvaluationSpec getFieldEvaluationSpec() {
        if (this.mEvaluationSpec != null) {
            this.mEvaluationSpec.context = this.getContext();
        }
        return this.mEvaluationSpec;
    }

    public AdRuleExecutionSpec getFieldExecutionSpec() {
        return this.mExecutionSpec;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdRuleScheduleSpec getFieldScheduleSpec() {
        return this.mScheduleSpec;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRule copyFrom(AdRule instance) {
        this.mAccountId = instance.mAccountId;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEvaluationSpec = instance.mEvaluationSpec;
        this.mExecutionSpec = instance.mExecutionSpec;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mScheduleSpec = instance.mScheduleSpec;
        this.mStatus = instance.mStatus;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRule> getParser() {
        return new APIRequest.ResponseParser<AdRule>(){

            @Override
            public APINodeList<AdRule> parseResponse(String response, APIContext context, APIRequest<AdRule> request, String header) throws APIException.MalformedResponseException {
                return AdRule.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_DELETED("DELETED"),
        VALUE_DISABLED("DISABLED"),
        VALUE_ENABLED("ENABLED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdRule> {
        AdRule lastResponse = null;
        public static final String[] PARAMS = new String[]{"evaluation_spec", "execution_spec", "name", "schedule_spec", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRule parseResponse(String response, String header) throws APIException {
            return AdRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdRule>(){

                public AdRule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setEvaluationSpec(Object evaluationSpec) {
            this.setParam("evaluation_spec", evaluationSpec);
            return this;
        }

        public APIRequestUpdate setEvaluationSpec(String evaluationSpec) {
            this.setParam("evaluation_spec", evaluationSpec);
            return this;
        }

        public APIRequestUpdate setExecutionSpec(Object executionSpec) {
            this.setParam("execution_spec", executionSpec);
            return this;
        }

        public APIRequestUpdate setExecutionSpec(String executionSpec) {
            this.setParam("execution_spec", executionSpec);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setScheduleSpec(Object scheduleSpec) {
            this.setParam("schedule_spec", scheduleSpec);
            return this;
        }

        public APIRequestUpdate setScheduleSpec(String scheduleSpec) {
            this.setParam("schedule_spec", scheduleSpec);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdRule> {
        AdRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "created_by", "created_time", "evaluation_spec", "execution_spec", "id", "name", "schedule_spec", "status", "updated_time"};

        @Override
        public AdRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRule parseResponse(String response, String header) throws APIException {
            return AdRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdRule>(){

                public AdRule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEvaluationSpecField() {
            return this.requestEvaluationSpecField(true);
        }

        public APIRequestGet requestEvaluationSpecField(boolean value) {
            this.requestField("evaluation_spec", value);
            return this;
        }

        public APIRequestGet requestExecutionSpecField() {
            return this.requestExecutionSpecField(true);
        }

        public APIRequestGet requestExecutionSpecField(boolean value) {
            this.requestField("execution_spec", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestScheduleSpecField() {
            return this.requestScheduleSpecField(true);
        }

        public APIRequestGet requestScheduleSpecField(boolean value) {
            this.requestField("schedule_spec", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePreview
    extends APIRequest<AdRule> {
        AdRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public AdRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRule parseResponse(String response, String header) throws APIException {
            return AdRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdRule>(){

                public AdRule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreatePreview.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePreview(String nodeId, APIContext context) {
            super(context, nodeId, "/preview", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePreview setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePreview setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePreview requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePreview requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePreview requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePreview requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePreview requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePreview requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetHistory
    extends APIRequest<AdRuleHistory> {
        APINodeList<AdRuleHistory> lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "hide_no_changes", "object_id"};
        public static final String[] FIELDS = new String[]{"evaluation_spec", "exception_code", "exception_message", "execution_spec", "is_manual", "results", "schedule_spec", "timestamp"};

        @Override
        public APINodeList<AdRuleHistory> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdRuleHistory> parseResponse(String response, String header) throws APIException {
            return AdRuleHistory.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdRuleHistory> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdRuleHistory> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdRuleHistory>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdRuleHistory>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdRuleHistory>>(){

                public APINodeList<AdRuleHistory> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetHistory.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetHistory(String nodeId, APIContext context) {
            super(context, nodeId, "/history", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetHistory setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetHistory setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetHistory setAction(AdRuleHistory.EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestGetHistory setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestGetHistory setHideNoChanges(Boolean hideNoChanges) {
            this.setParam("hide_no_changes", hideNoChanges);
            return this;
        }

        public APIRequestGetHistory setHideNoChanges(String hideNoChanges) {
            this.setParam("hide_no_changes", hideNoChanges);
            return this;
        }

        public APIRequestGetHistory setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestGetHistory requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetHistory requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHistory requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetHistory requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHistory requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetHistory requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetHistory requestEvaluationSpecField() {
            return this.requestEvaluationSpecField(true);
        }

        public APIRequestGetHistory requestEvaluationSpecField(boolean value) {
            this.requestField("evaluation_spec", value);
            return this;
        }

        public APIRequestGetHistory requestExceptionCodeField() {
            return this.requestExceptionCodeField(true);
        }

        public APIRequestGetHistory requestExceptionCodeField(boolean value) {
            this.requestField("exception_code", value);
            return this;
        }

        public APIRequestGetHistory requestExceptionMessageField() {
            return this.requestExceptionMessageField(true);
        }

        public APIRequestGetHistory requestExceptionMessageField(boolean value) {
            this.requestField("exception_message", value);
            return this;
        }

        public APIRequestGetHistory requestExecutionSpecField() {
            return this.requestExecutionSpecField(true);
        }

        public APIRequestGetHistory requestExecutionSpecField(boolean value) {
            this.requestField("execution_spec", value);
            return this;
        }

        public APIRequestGetHistory requestIsManualField() {
            return this.requestIsManualField(true);
        }

        public APIRequestGetHistory requestIsManualField(boolean value) {
            this.requestField("is_manual", value);
            return this;
        }

        public APIRequestGetHistory requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGetHistory requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGetHistory requestScheduleSpecField() {
            return this.requestScheduleSpecField(true);
        }

        public APIRequestGetHistory requestScheduleSpecField(boolean value) {
            this.requestField("schedule_spec", value);
            return this;
        }

        public APIRequestGetHistory requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetHistory requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateExecute
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateExecute.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateExecute(String nodeId, APIContext context) {
            super(context, nodeId, "/execute", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateExecute setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateExecute setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateExecute requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateExecute requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExecute requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateExecute requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateExecute requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateExecute requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

