/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.facebook.CallbackManager;
import com.facebook.FacebookButtonBase;
import com.facebook.FacebookCallback;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.share.Sharer;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.widget.ShareDialog;

public abstract class ShareButtonBase
extends FacebookButtonBase {
    private ShareContent shareContent;
    private int requestCode = this.isInEditMode() ? 0 : this.getDefaultRequestCode();
    private boolean enabledExplicitlySet = false;
    private CallbackManager callbackManager;

    protected ShareButtonBase(Context context, AttributeSet attrs, int defStyleAttr, String analyticsButtonCreatedEventName, String analyticsButtonTappedEventName) {
        super(context, attrs, defStyleAttr, 0, analyticsButtonCreatedEventName, analyticsButtonTappedEventName);
        this.internalSetEnabled(false);
    }

    public ShareContent getShareContent() {
        return this.shareContent;
    }

    public void setShareContent(ShareContent shareContent) {
        this.shareContent = shareContent;
        if (!this.enabledExplicitlySet) {
            this.internalSetEnabled(this.canShare());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabledExplicitlySet = true;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    protected void setRequestCode(int requestCode) {
        if (FacebookSdk.isFacebookRequestCode((int)requestCode)) {
            throw new IllegalArgumentException("Request code " + requestCode + " cannot be within the range reserved by the Facebook SDK.");
        }
        this.requestCode = requestCode;
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<Sharer.Result> callback) {
        this.memorizeCallbackManager(callbackManager);
        ShareInternalUtility.registerSharerCallback((int)this.getRequestCode(), (CallbackManager)callbackManager, callback);
    }

    public void registerCallback(CallbackManager callbackManager, FacebookCallback<Sharer.Result> callback, int requestCode) {
        this.setRequestCode(requestCode);
        this.registerCallback(callbackManager, callback);
    }

    protected void configureButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super.configureButton(context, attrs, defStyleAttr, defStyleRes);
        this.setInternalOnClickListener(this.getShareOnClickListener());
    }

    protected boolean canShare() {
        return this.getDialog().canShow((Object)this.getShareContent());
    }

    protected View.OnClickListener getShareOnClickListener() {
        return new View.OnClickListener(){

            /*
             * WARNING - void declaration
             */
            public void onClick(View view) {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    void v;
                    ShareButtonBase.this.callExternalOnClickListener((View)v);
                    ShareButtonBase.this.getDialog().show((Object)ShareButtonBase.this.getShareContent());
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
        };
    }

    protected abstract ShareDialog getDialog();

    private void internalSetEnabled(boolean enabled) {
        this.setEnabled(enabled);
        this.enabledExplicitlySet = false;
    }

    private void memorizeCallbackManager(CallbackManager callbackManager) {
        if (this.callbackManager == null) {
            this.callbackManager = callbackManager;
        } else if (this.callbackManager != callbackManager) {
            Log.w((String)ShareButtonBase.class.toString(), (String)"You're registering a callback on a Facebook Share Button with two different callback managers. It's almost wrong and may cause unexpected results. Only the first callback manager will be used for handling activity result with androidx.");
        }
    }

    protected CallbackManager getCallbackManager() {
        return this.callbackManager;
    }
}

