/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.places.internal;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.places.internal.BleScanner;
import com.facebook.places.internal.BluetoothScanResult;
import com.facebook.places.internal.LocationPackageRequestParams;
import com.facebook.places.internal.ScannerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@TargetApi(value=21)
public class BleScannerImpl
implements BleScanner {
    private static final String TAG = "BleScannerImpl";
    private static final byte[] IBEACON_PREFIX = BleScannerImpl.fromHexString("ff4c000215");
    private static final byte[] EDDYSTONE_PREFIX = BleScannerImpl.fromHexString("16aafe");
    private static final byte[] GRAVITY_PREFIX = BleScannerImpl.fromHexString("17ffab01");
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothLeScanner bluetoothLeScanner;
    private LocationPackageRequestParams params;
    private int errorCode;
    private final List<BluetoothScanResult> scanResults = new ArrayList<BluetoothScanResult>();
    private boolean isScanInProgress;
    private ScanCallBackImpl scanCallBack;
    private Context context;

    BleScannerImpl(Context context, LocationPackageRequestParams params) {
        this.context = context;
        this.params = params;
    }

    @Override
    public synchronized void initAndCheckEligibility() throws ScannerException {
        if (Build.VERSION.SDK_INT < 21) {
            throw new ScannerException(ScannerException.Type.NOT_SUPPORTED);
        }
        if (!Validate.hasBluetoothPermission((Context)this.context)) {
            throw new ScannerException(ScannerException.Type.PERMISSION_DENIED);
        }
        if (!Validate.hasLocationPermission((Context)this.context)) {
            throw new ScannerException(ScannerException.Type.PERMISSION_DENIED);
        }
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null || !this.bluetoothAdapter.isEnabled()) {
            throw new ScannerException(ScannerException.Type.DISABLED);
        }
        this.bluetoothLeScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (this.bluetoothLeScanner == null) {
            throw new ScannerException(ScannerException.Type.UNKNOWN_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startScanning() throws ScannerException {
        if (this.isScanInProgress) {
            throw new ScannerException(ScannerException.Type.SCAN_ALREADY_IN_PROGRESS);
        }
        this.scanCallBack = new ScanCallBackImpl();
        this.isScanInProgress = true;
        this.errorCode = 0;
        List<BluetoothScanResult> list = this.scanResults;
        synchronized (list) {
            this.scanResults.clear();
        }
        if (this.bluetoothLeScanner == null) {
            throw new ScannerException(ScannerException.Type.UNKNOWN_ERROR);
        }
        try {
            ScanSettings.Builder builder = new ScanSettings.Builder();
            builder.setScanMode(2);
            builder.setReportDelay(0L);
            this.bluetoothLeScanner.startScan(null, builder.build(), (ScanCallback)this.scanCallBack);
            this.isScanInProgress = true;
        }
        catch (Exception e) {
            throw new ScannerException(ScannerException.Type.UNKNOWN_ERROR);
        }
    }

    @Override
    public synchronized void stopScanning() {
        this.bluetoothLeScanner.flushPendingScanResults((ScanCallback)this.scanCallBack);
        this.bluetoothLeScanner.stopScan((ScanCallback)this.scanCallBack);
        this.waitForMainLooper(this.params.getBluetoothFlushResultsTimeoutMs());
        this.isScanInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMainLooper(long maxWaitTimeoutMs) {
        try {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                            return;
                        }
                        try {
                            try {
                                Object object = lock;
                                synchronized (object) {
                                    lock.notify();
                                }
                            }
                            catch (Exception e) {
                                BleScannerImpl.logException("Exception waiting for main looper", e);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                            return;
                        }
                    }
                });
                lock.wait(maxWaitTimeoutMs);
            }
        }
        catch (Exception e) {
            BleScannerImpl.logException("Exception waiting for main looper", e);
        }
    }

    @Override
    public synchronized int getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<BluetoothScanResult> getScanResults() {
        ArrayList<BluetoothScanResult> output;
        List<BluetoothScanResult> list = this.scanResults;
        synchronized (list) {
            int maxSanResults = this.params.getBluetoothMaxScanResults();
            if (this.scanResults.size() > maxSanResults) {
                output = new ArrayList<BluetoothScanResult>(maxSanResults);
                Comparator<BluetoothScanResult> comparator = new Comparator<BluetoothScanResult>(){

                    @Override
                    public int compare(BluetoothScanResult lhs, BluetoothScanResult rhs) {
                        return rhs.rssi - lhs.rssi;
                    }
                };
                Collections.sort(this.scanResults, comparator);
                output.addAll(this.scanResults.subList(0, maxSanResults));
            } else {
                output = new ArrayList(this.scanResults.size());
                output.addAll(this.scanResults);
            }
        }
        return output;
    }

    private static BluetoothScanResult newBluetoothScanResult(ScanResult scanResult) {
        ScanRecord scanRecord = scanResult.getScanRecord();
        byte[] scanRecordBytes = scanRecord.getBytes();
        if (BleScannerImpl.isBeacon(scanRecordBytes)) {
            String payload = BleScannerImpl.formatPayload(scanRecord.getBytes());
            int rssi = scanResult.getRssi();
            long timestampNanos = scanResult.getTimestampNanos();
            BluetoothScanResult bluetoothScanResult = new BluetoothScanResult(payload, rssi, timestampNanos);
            return bluetoothScanResult;
        }
        return null;
    }

    private static String formatPayload(byte[] payload) {
        if (payload == null || payload.length == 0) {
            return null;
        }
        int payloadLength = BleScannerImpl.getPayloadLength(payload);
        return BleScannerImpl.toHexString(payload, payloadLength);
    }

    private static int getPayloadLength(byte[] payload) {
        byte length;
        for (int offset = 0; offset < payload.length; offset += 1 + length) {
            length = payload[offset];
            if (length == 0) {
                return offset;
            }
            if (length >= 0) continue;
            return payload.length;
        }
        return payload.length;
    }

    private static String toHexString(byte[] bytes, int length) {
        StringBuffer sb = new StringBuffer();
        if (length < 0 || length > bytes.length) {
            length = bytes.length;
        }
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static void logException(String message, Exception e) {
        if (FacebookSdk.isDebugEnabled()) {
            Log.e((String)TAG, (String)message, (Throwable)e);
        }
    }

    private static boolean isBeacon(byte[] payload) {
        int advPacketLength;
        if (payload == null) {
            return false;
        }
        int payloadLength = payload.length;
        for (int startIndex = 0; startIndex < payloadLength; startIndex += advPacketLength) {
            byte advLengthField = payload[startIndex];
            if (advLengthField <= 0) {
                return false;
            }
            advPacketLength = 1 + advLengthField;
            if (startIndex + advPacketLength > payloadLength) {
                return false;
            }
            if (!BleScannerImpl.isAdvPacketBeacon(payload, startIndex)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAdvPacketBeacon(byte[] payload, int advStartIndex) {
        if (BleScannerImpl.isArrayContained(payload, advStartIndex + 1, IBEACON_PREFIX)) {
            return true;
        }
        if (BleScannerImpl.isArrayContained(payload, advStartIndex + 1, EDDYSTONE_PREFIX)) {
            return true;
        }
        if (BleScannerImpl.isArrayContained(payload, advStartIndex, GRAVITY_PREFIX)) {
            return true;
        }
        return BleScannerImpl.isAltBeacon(payload, advStartIndex);
    }

    private static boolean isAltBeacon(byte[] payload, int startIndex) {
        if (startIndex + 5 < payload.length) {
            byte length = payload[startIndex];
            byte packetType = payload[startIndex + 1];
            byte beaconCode1 = payload[startIndex + 4];
            byte beaconCode2 = payload[startIndex + 5];
            return length == 27 && packetType == -1 && beaconCode1 == -66 && beaconCode2 == -84;
        }
        return false;
    }

    private static boolean isArrayContained(byte[] array1, int startIndex1, byte[] array2) {
        int length = array2.length;
        if (startIndex1 + length > array1.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[startIndex1 + i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] fromHexString(String hexString) {
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    private class ScanCallBackImpl
    extends ScanCallback {
        private ScanCallBackImpl() {
        }

        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            BleScannerImpl.this.errorCode = errorCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBatchScanResults(List<ScanResult> results) {
            super.onBatchScanResults(results);
            try {
                List list = BleScannerImpl.this.scanResults;
                synchronized (list) {
                    for (ScanResult result : results) {
                        BluetoothScanResult bluetoothScanResult = BleScannerImpl.newBluetoothScanResult(result);
                        if (bluetoothScanResult == null) continue;
                        BleScannerImpl.this.scanResults.add(bluetoothScanResult);
                    }
                }
            }
            catch (Exception e) {
                BleScannerImpl.logException("Exception in ble scan callback", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            super.onScanResult(callbackType, result);
            try {
                List list = BleScannerImpl.this.scanResults;
                synchronized (list) {
                    BluetoothScanResult bluetoothScanResult = BleScannerImpl.newBluetoothScanResult(result);
                    if (bluetoothScanResult != null) {
                        BleScannerImpl.this.scanResults.add(bluetoothScanResult);
                    }
                }
            }
            catch (Exception e) {
                BleScannerImpl.logException("Exception in ble scan callback", e);
            }
        }
    }
}

