/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.messenger;

import android.net.Uri;
import com.facebook.messenger.ShareToMessengerParamsBuilder;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/facebook/messenger/ShareToMessengerParams;", "", "builder", "Lcom/facebook/messenger/ShareToMessengerParamsBuilder;", "(Lcom/facebook/messenger/ShareToMessengerParamsBuilder;)V", "externalUri", "Landroid/net/Uri;", "getExternalUri", "()Landroid/net/Uri;", "metaData", "", "getMetaData", "()Ljava/lang/String;", "mimeType", "getMimeType", "uri", "getUri", "Companion", "facebook-messenger_release"})
@SourceDebugExtension(value={"SMAP\nShareToMessengerParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShareToMessengerParams.kt\ncom/facebook/messenger/ShareToMessengerParams\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class ShareToMessengerParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Uri uri;
    @NotNull
    private final String mimeType;
    @Nullable
    private final String metaData;
    @Nullable
    private final Uri externalUri;
    @NotNull
    private static final Set<String> VALID_URI_SCHEMES;
    @NotNull
    private static final Set<String> VALID_MIME_TYPES;
    @NotNull
    private static final Set<String> VALID_EXTERNAL_URI_SCHEMES;

    public ShareToMessengerParams(@NotNull ShareToMessengerParamsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Uri uri = builder.getUri();
        if (uri == null) {
            ShareToMessengerParams shareToMessengerParams = this;
            boolean $i$a$-checkNotNull-ShareToMessengerParams$32 = false;
            ShareToMessengerParams shareToMessengerParams2 = shareToMessengerParams;
            String $i$a$-checkNotNull-ShareToMessengerParams$32 = "Must provide non-null uri";
            throw new IllegalStateException($i$a$-checkNotNull-ShareToMessengerParams$32.toString());
        }
        this.uri = uri;
        String string = builder.getMimeType();
        if (string == null) {
            ShareToMessengerParams shareToMessengerParams = this;
            boolean $i$a$-checkNotNull-ShareToMessengerParams$42 = false;
            ShareToMessengerParams shareToMessengerParams3 = shareToMessengerParams;
            String $i$a$-checkNotNull-ShareToMessengerParams$42 = "Must provide mimeType";
            throw new IllegalStateException($i$a$-checkNotNull-ShareToMessengerParams$42.toString());
        }
        this.mimeType = string;
        this.metaData = builder.getMetaData();
        this.externalUri = builder.getExternalUri();
        if (!CollectionsKt.contains((Iterable)VALID_URI_SCHEMES, (Object)this.uri.getScheme())) {
            boolean $i$a$-require-ShareToMessengerParams$62 = false;
            String $i$a$-require-ShareToMessengerParams$62 = "Unsupported URI scheme: " + this.uri.getScheme();
            throw new IllegalArgumentException($i$a$-require-ShareToMessengerParams$62.toString());
        }
        if (!VALID_MIME_TYPES.contains(this.mimeType)) {
            boolean $i$a$-require-ShareToMessengerParams$72 = false;
            String $i$a$-require-ShareToMessengerParams$72 = "Unsupported mime-type: " + this.mimeType;
            throw new IllegalArgumentException($i$a$-require-ShareToMessengerParams$72.toString());
        }
        if (this.externalUri != null && !CollectionsKt.contains((Iterable)VALID_EXTERNAL_URI_SCHEMES, (Object)this.externalUri.getScheme())) {
            boolean bl = false;
            String string2 = "Unsupported external uri scheme: " + this.externalUri.getScheme();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @Nullable
    public final String getMetaData() {
        return this.metaData;
    }

    @Nullable
    public final Uri getExternalUri() {
        return this.externalUri;
    }

    @JvmStatic
    @NotNull
    public static final ShareToMessengerParamsBuilder newBuilder(@NotNull Uri uri, @NotNull String mimeType) {
        return Companion.newBuilder(uri, mimeType);
    }

    static {
        HashSet<String> validMimeTypes = new HashSet<String>();
        validMimeTypes.add("image/*");
        validMimeTypes.add("image/jpeg");
        validMimeTypes.add("image/png");
        validMimeTypes.add("image/gif");
        validMimeTypes.add("image/webp");
        validMimeTypes.add("video/*");
        validMimeTypes.add("video/mp4");
        validMimeTypes.add("audio/*");
        validMimeTypes.add("audio/mpeg");
        VALID_MIME_TYPES = CollectionsKt.toSet((Iterable)validMimeTypes);
        HashSet<String> validUriSchemes = new HashSet<String>();
        validUriSchemes.add("content");
        validUriSchemes.add("android.resource");
        validUriSchemes.add("file");
        VALID_URI_SCHEMES = CollectionsKt.toSet((Iterable)validUriSchemes);
        HashSet<String> validExternalUriSchemes = new HashSet<String>();
        validExternalUriSchemes.add("http");
        validExternalUriSchemes.add("https");
        VALID_EXTERNAL_URI_SCHEMES = CollectionsKt.toSet((Iterable)validExternalUriSchemes);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/facebook/messenger/ShareToMessengerParams$Companion;", "", "()V", "VALID_EXTERNAL_URI_SCHEMES", "", "", "getVALID_EXTERNAL_URI_SCHEMES", "()Ljava/util/Set;", "VALID_MIME_TYPES", "getVALID_MIME_TYPES", "VALID_URI_SCHEMES", "getVALID_URI_SCHEMES", "newBuilder", "Lcom/facebook/messenger/ShareToMessengerParamsBuilder;", "uri", "Landroid/net/Uri;", "mimeType", "facebook-messenger_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getVALID_URI_SCHEMES() {
            return VALID_URI_SCHEMES;
        }

        @NotNull
        public final Set<String> getVALID_MIME_TYPES() {
            return VALID_MIME_TYPES;
        }

        @NotNull
        public final Set<String> getVALID_EXTERNAL_URI_SCHEMES() {
            return VALID_EXTERNAL_URI_SCHEMES;
        }

        @JvmStatic
        @NotNull
        public final ShareToMessengerParamsBuilder newBuilder(@NotNull Uri uri, @NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new ShareToMessengerParamsBuilder(uri, mimeType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

