/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.messenger;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.FacebookSdk;
import com.facebook.bolts.AppLinks;
import com.facebook.internal.FacebookSignatureValidator;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.messenger.MessengerThreadParams;
import com.facebook.messenger.ShareToMessengerParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessengerUtils {
    private static final String TAG = "MessengerUtils";
    public static final String PACKAGE_NAME = "com.facebook.orca";
    public static final String EXTRA_PROTOCOL_VERSION = "com.facebook.orca.extra.PROTOCOL_VERSION";
    public static final String EXTRA_APP_ID = "com.facebook.orca.extra.APPLICATION_ID";
    public static final String EXTRA_REPLY_TOKEN_KEY = "com.facebook.orca.extra.REPLY_TOKEN";
    public static final String EXTRA_THREAD_TOKEN_KEY = "com.facebook.orca.extra.THREAD_TOKEN";
    public static final String EXTRA_METADATA = "com.facebook.orca.extra.METADATA";
    public static final String EXTRA_EXTERNAL_URI = "com.facebook.orca.extra.EXTERNAL_URI";
    public static final String EXTRA_PARTICIPANTS = "com.facebook.orca.extra.PARTICIPANTS";
    public static final String EXTRA_IS_REPLY = "com.facebook.orca.extra.IS_REPLY";
    public static final String EXTRA_IS_COMPOSE = "com.facebook.orca.extra.IS_COMPOSE";
    public static final int PROTOCOL_VERSION_20150314 = 20150314;
    public static final String ORCA_THREAD_CATEGORY_20150314 = "com.facebook.orca.category.PLATFORM_THREAD_20150314";

    /*
     * WARNING - void declaration
     */
    public static void shareToMessenger(Activity activity, int n, ShareToMessengerParams shareToMessengerParams) {
        if (CrashShieldHandler.isObjectCrashing(MessengerUtils.class)) {
            return;
        }
        try {
            Activity activity2;
            if (!MessengerUtils.hasMessengerInstalled((Context)activity2)) {
                MessengerUtils.openMessengerInPlayStore((Context)activity2);
                return;
            }
            Set<Integer> allAvailableVersions = MessengerUtils.getAllAvailableProtocolVersions((Context)activity2);
            if (allAvailableVersions.contains(20150314)) {
                void shareToMessengerParams2;
                void requestCode;
                MessengerUtils.shareToMessenger20150314(activity2, (int)requestCode, (ShareToMessengerParams)shareToMessengerParams2);
            } else {
                MessengerUtils.openMessengerInPlayStore((Context)activity2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, MessengerUtils.class);
            return;
        }
    }

    private static void shareToMessenger20150314(Activity activity, int requestCode, ShareToMessengerParams shareToMessengerParams) {
        try {
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.setFlags(1);
            shareIntent.setPackage(PACKAGE_NAME);
            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)shareToMessengerParams.uri);
            shareIntent.setType(shareToMessengerParams.mimeType);
            String appId = FacebookSdk.getApplicationId();
            if (appId != null) {
                shareIntent.putExtra(EXTRA_PROTOCOL_VERSION, 20150314);
                shareIntent.putExtra(EXTRA_APP_ID, appId);
                shareIntent.putExtra(EXTRA_METADATA, shareToMessengerParams.metaData);
                shareIntent.putExtra(EXTRA_EXTERNAL_URI, (Parcelable)shareToMessengerParams.externalUri);
            }
            activity.startActivityForResult(shareIntent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            Intent openMessenger = activity.getPackageManager().getLaunchIntentForPackage(PACKAGE_NAME);
            activity.startActivity(openMessenger);
        }
    }

    public static MessengerThreadParams getMessengerThreadParamsForIntent(Intent intent) {
        if (CrashShieldHandler.isObjectCrashing(MessengerUtils.class)) {
            return null;
        }
        try {
            Intent intent2;
            Set categories = intent2.getCategories();
            if (categories == null) {
                return null;
            }
            if (categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
                Bundle appLinkExtras = AppLinks.getAppLinkExtras((Intent)intent2);
                String threadToken = appLinkExtras.getString(EXTRA_THREAD_TOKEN_KEY);
                String metadata = appLinkExtras.getString(EXTRA_METADATA);
                String participants = appLinkExtras.getString(EXTRA_PARTICIPANTS);
                boolean isReply = appLinkExtras.getBoolean(EXTRA_IS_REPLY);
                boolean isCompose = appLinkExtras.getBoolean(EXTRA_IS_COMPOSE);
                MessengerThreadParams.Origin origin = MessengerThreadParams.Origin.UNKNOWN;
                if (isReply) {
                    origin = MessengerThreadParams.Origin.REPLY_FLOW;
                } else if (isCompose) {
                    origin = MessengerThreadParams.Origin.COMPOSE_FLOW;
                }
                return new MessengerThreadParams(origin, threadToken, metadata, MessengerUtils.parseParticipants(participants));
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, MessengerUtils.class);
            return null;
        }
    }

    public static void finishShareToMessenger(Activity activity, ShareToMessengerParams shareToMessengerParams) {
        Intent originalIntent = activity.getIntent();
        Set categories = originalIntent.getCategories();
        if (categories == null) {
            activity.setResult(0, null);
            activity.finish();
            return;
        }
        if (categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
            Bundle appLinkExtras = AppLinks.getAppLinkExtras((Intent)originalIntent);
            Intent resultIntent = new Intent();
            if (!categories.contains(ORCA_THREAD_CATEGORY_20150314)) {
                throw new RuntimeException();
            }
            resultIntent.putExtra(EXTRA_PROTOCOL_VERSION, 20150314);
            String threadToken = appLinkExtras.getString(EXTRA_THREAD_TOKEN_KEY);
            resultIntent.putExtra(EXTRA_THREAD_TOKEN_KEY, threadToken);
            resultIntent.setDataAndType(shareToMessengerParams.uri, shareToMessengerParams.mimeType);
            resultIntent.setFlags(1);
            resultIntent.putExtra(EXTRA_APP_ID, FacebookSdk.getApplicationId());
            resultIntent.putExtra(EXTRA_METADATA, shareToMessengerParams.metaData);
            resultIntent.putExtra(EXTRA_EXTERNAL_URI, (Parcelable)shareToMessengerParams.externalUri);
            activity.setResult(-1, resultIntent);
            activity.finish();
        } else {
            activity.setResult(0, null);
            activity.finish();
        }
    }

    public static boolean hasMessengerInstalled(Context context) {
        return FacebookSignatureValidator.validateSignature((Context)context, (String)PACKAGE_NAME);
    }

    public static void openMessengerInPlayStore(Context context) {
        if (CrashShieldHandler.isObjectCrashing(MessengerUtils.class)) {
            return;
        }
        try {
            Context context2;
            try {
                MessengerUtils.startViewUri(context2, "market://details?id=com.facebook.orca");
            }
            catch (ActivityNotFoundException anfe) {
                MessengerUtils.startViewUri(context2, "http://play.google.com/store/apps/details?id=com.facebook.orca");
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, MessengerUtils.class);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Integer> getAllAvailableProtocolVersions(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        HashSet<Integer> allAvailableVersions = new HashSet<Integer>();
        Uri uri = Uri.parse((String)"content://com.facebook.orca.provider.MessengerPlatformProvider/versions");
        String[] projection = new String[]{"version"};
        Cursor c = contentResolver.query(uri, projection, null, null, null);
        if (c != null) {
            try {
                int versionColumnIndex = c.getColumnIndex("version");
                while (c.moveToNext()) {
                    int version = c.getInt(versionColumnIndex);
                    allAvailableVersions.add(version);
                }
            }
            finally {
                c.close();
            }
        }
        return allAvailableVersions;
    }

    private static void startViewUri(Context context, String uri) {
        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)uri)));
    }

    private static List<String> parseParticipants(String s) {
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        String[] parts = s.split(",");
        ArrayList<String> ret = new ArrayList<String>();
        for (String part : parts) {
            ret.add(part.trim());
        }
        return ret;
    }
}

