/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login.widget;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.login.R;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001b\u001a\u00020\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/facebook/login/widget/ToolTipPopup;", "", "text", "", "anchor", "Landroid/view/View;", "(Ljava/lang/String;Landroid/view/View;)V", "anchorViewRef", "Ljava/lang/ref/WeakReference;", "context", "Landroid/content/Context;", "nuxDisplayTime", "", "popupContent", "Lcom/facebook/login/widget/ToolTipPopup$PopupContentView;", "popupWindow", "Landroid/widget/PopupWindow;", "scrollListener", "Landroid/view/ViewTreeObserver$OnScrollChangedListener;", "style", "Lcom/facebook/login/widget/ToolTipPopup$Style;", "dismiss", "", "registerObserver", "setNuxDisplayTime", "displayTime", "setStyle", "show", "unregisterObserver", "updateArrows", "Companion", "PopupContentView", "Style", "facebook-login_release"})
@AutoHandleExceptions
public final class ToolTipPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final WeakReference<View> anchorViewRef;
    @NotNull
    private final Context context;
    @Nullable
    private PopupContentView popupContent;
    @Nullable
    private PopupWindow popupWindow;
    @NotNull
    private Style style;
    private long nuxDisplayTime;
    @NotNull
    private final ViewTreeObserver.OnScrollChangedListener scrollListener;
    public static final long DEFAULT_POPUP_DISPLAY_TIME = 6000L;

    public ToolTipPopup(@NotNull String text, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.text = text;
        this.anchorViewRef = new WeakReference<View>(anchor);
        Context context = anchor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"anchor.context");
        this.context = context;
        this.style = Style.BLUE;
        this.nuxDisplayTime = 6000L;
        this.scrollListener = () -> ToolTipPopup.scrollListener$lambda-1(this);
    }

    public final void setStyle(@NotNull Style style2) {
        Intrinsics.checkNotNullParameter((Object)((Object)style2), (String)"style");
        this.style = style2;
    }

    public final void show() {
        if (this.anchorViewRef.get() != null) {
            PopupWindow popupWindow;
            PopupContentView popupContent;
            this.popupContent = popupContent = new PopupContentView(this.context);
            View view = popupContent.findViewById(R.id.com_facebook_tooltip_bubble_view_text_body);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            TextView body = (TextView)view;
            body.setText((CharSequence)this.text);
            if (this.style == Style.BLUE) {
                popupContent.getBodyFrame().setBackgroundResource(R.drawable.com_facebook_tooltip_blue_background);
                popupContent.getBottomArrow().setImageResource(R.drawable.com_facebook_tooltip_blue_bottomnub);
                popupContent.getTopArrow().setImageResource(R.drawable.com_facebook_tooltip_blue_topnub);
                popupContent.getXOut().setImageResource(R.drawable.com_facebook_tooltip_blue_xout);
            } else {
                popupContent.getBodyFrame().setBackgroundResource(R.drawable.com_facebook_tooltip_black_background);
                popupContent.getBottomArrow().setImageResource(R.drawable.com_facebook_tooltip_black_bottomnub);
                popupContent.getTopArrow().setImageResource(R.drawable.com_facebook_tooltip_black_topnub);
                popupContent.getXOut().setImageResource(R.drawable.com_facebook_tooltip_black_xout);
            }
            Window window = ((Activity)this.context).getWindow();
            View view2 = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"window.decorView");
            View decorView = view2;
            int decorWidth = decorView.getWidth();
            int decorHeight = decorView.getHeight();
            this.registerObserver();
            popupContent.measure(View.MeasureSpec.makeMeasureSpec((int)decorWidth, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)decorHeight, (int)Integer.MIN_VALUE));
            this.popupWindow = popupWindow = new PopupWindow((View)popupContent, popupContent.getMeasuredWidth(), popupContent.getMeasuredHeight());
            popupWindow.showAsDropDown((View)this.anchorViewRef.get());
            this.updateArrows();
            if (this.nuxDisplayTime > 0L) {
                popupContent.postDelayed(() -> ToolTipPopup.show$lambda-2(this), this.nuxDisplayTime);
            }
            popupWindow.setTouchable(true);
            popupContent.setOnClickListener(arg_0 -> ToolTipPopup.show$lambda-3(this, arg_0));
        }
    }

    public final void setNuxDisplayTime(long displayTime) {
        this.nuxDisplayTime = displayTime;
    }

    private final void updateArrows() {
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            PopupWindow popupWindow2 = popupWindow;
            boolean bl = false;
            boolean bl2 = false;
            PopupWindow it = popupWindow2;
            boolean bl3 = false;
            if (it.isShowing()) {
                if (it.isAboveAnchor()) {
                    PopupContentView popupContentView = this.popupContent;
                    if (popupContentView != null) {
                        popupContentView.showBottomArrow();
                    }
                } else {
                    PopupContentView popupContentView = this.popupContent;
                    if (popupContentView != null) {
                        popupContentView.showTopArrow();
                    }
                }
            }
        }
    }

    public final void dismiss() {
        this.unregisterObserver();
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
    }

    private final void registerObserver() {
        ViewTreeObserver viewTreeObserver;
        this.unregisterObserver();
        View view = (View)this.anchorViewRef.get();
        if (view != null && (viewTreeObserver = view.getViewTreeObserver()) != null) {
            viewTreeObserver.addOnScrollChangedListener(this.scrollListener);
        }
    }

    private final void unregisterObserver() {
        ViewTreeObserver viewTreeObserver;
        View view = (View)this.anchorViewRef.get();
        if (view != null && (viewTreeObserver = view.getViewTreeObserver()) != null) {
            viewTreeObserver.removeOnScrollChangedListener(this.scrollListener);
        }
    }

    private static final void scrollListener$lambda-1(ToolTipPopup this$0) {
        PopupWindow popupWindow;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.anchorViewRef.get() != null && (popupWindow = this$0.popupWindow) != null) {
            PopupWindow popupWindow2 = popupWindow;
            boolean bl = false;
            boolean bl2 = false;
            PopupWindow it = popupWindow2;
            boolean bl3 = false;
            if (it.isShowing()) {
                if (it.isAboveAnchor()) {
                    PopupContentView popupContentView = this$0.popupContent;
                    if (popupContentView != null) {
                        popupContentView.showBottomArrow();
                    }
                } else {
                    PopupContentView popupContentView = this$0.popupContent;
                    if (popupContentView != null) {
                        popupContentView.showTopArrow();
                    }
                }
            }
        }
    }

    private static final void show$lambda-2(ToolTipPopup this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dismiss();
    }

    private static final void show$lambda-3(ToolTipPopup this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dismiss();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/login/widget/ToolTipPopup$Style;", "", "(Ljava/lang/String;I)V", "BLUE", "BLACK", "facebook-login_release"})
    public static final class Style
    extends Enum<Style> {
        public static final /* enum */ Style BLUE = new Style();
        public static final /* enum */ Style BLACK = new Style();
        private static final /* synthetic */ Style[] $VALUES;

        public static Style[] values() {
            Style[] styleArray = $VALUES;
            return Arrays.copyOf(styleArray, styleArray.length);
        }

        public static Style valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Style.class, value);
        }

        static {
            $VALUES = styleArray = new Style[]{Style.BLUE, Style.BLACK};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/facebook/login/widget/ToolTipPopup$PopupContentView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Lcom/facebook/login/widget/ToolTipPopup;Landroid/content/Context;)V", "bodyFrame", "Landroid/view/View;", "getBodyFrame", "()Landroid/view/View;", "bottomArrow", "Landroid/widget/ImageView;", "getBottomArrow", "()Landroid/widget/ImageView;", "topArrow", "getTopArrow", "xOut", "getXOut", "showBottomArrow", "", "showTopArrow", "facebook-login_release"})
    private final class PopupContentView
    extends FrameLayout {
        @NotNull
        private final ImageView topArrow;
        @NotNull
        private final ImageView bottomArrow;
        @NotNull
        private final View bodyFrame;
        @NotNull
        private final ImageView xOut;

        public PopupContentView(Context context) {
            Intrinsics.checkNotNullParameter((Object)ToolTipPopup.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            inflater.inflate(R.layout.com_facebook_tooltip_bubble, (ViewGroup)this);
            View view = this.findViewById(R.id.com_facebook_tooltip_bubble_view_top_pointer);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.topArrow = (ImageView)view;
            view = this.findViewById(R.id.com_facebook_tooltip_bubble_view_bottom_pointer);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.bottomArrow = (ImageView)view;
            view = this.findViewById(R.id.com_facebook_body_frame);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.com_facebook_body_frame)");
            this.bodyFrame = view;
            view = this.findViewById(R.id.com_facebook_button_xout);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.xOut = (ImageView)view;
        }

        @NotNull
        public final ImageView getTopArrow() {
            return this.topArrow;
        }

        @NotNull
        public final ImageView getBottomArrow() {
            return this.bottomArrow;
        }

        @NotNull
        public final View getBodyFrame() {
            return this.bodyFrame;
        }

        @NotNull
        public final ImageView getXOut() {
            return this.xOut;
        }

        public final void showTopArrow() {
            this.topArrow.setVisibility(0);
            this.bottomArrow.setVisibility(4);
        }

        public final void showBottomArrow() {
            this.topArrow.setVisibility(4);
            this.bottomArrow.setVisibility(0);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/login/widget/ToolTipPopup$Companion;", "", "()V", "DEFAULT_POPUP_DISPLAY_TIME", "", "facebook-login_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

