/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginManager;
import java.util.Collection;

@AutoHandleExceptions
public class DeviceLoginManager
extends LoginManager {
    private Uri deviceRedirectUri;
    @Nullable
    private String deviceAuthTargetUserId;
    private static volatile DeviceLoginManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceLoginManager getInstance() {
        if (instance != null) return instance;
        Class<DeviceLoginManager> clazz = DeviceLoginManager.class;
        synchronized (DeviceLoginManager.class) {
            if (instance != null) return instance;
            instance = new DeviceLoginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setDeviceRedirectUri(Uri uri) {
        this.deviceRedirectUri = uri;
    }

    public Uri getDeviceRedirectUri() {
        return this.deviceRedirectUri;
    }

    public void setDeviceAuthTargetUserId(@Nullable String targetUserId) {
        this.deviceAuthTargetUserId = targetUserId;
    }

    @Nullable
    public String getDeviceAuthTargetUserId() {
        return this.deviceAuthTargetUserId;
    }

    protected LoginClient.Request createLoginRequest(Collection<String> permissions) {
        String deviceTargetUserId;
        LoginClient.Request request = super.createLoginRequest(permissions);
        Uri redirectUri = this.getDeviceRedirectUri();
        if (redirectUri != null) {
            request.setDeviceRedirectUriString(redirectUri.toString());
        }
        if ((deviceTargetUserId = this.getDeviceAuthTargetUserId()) != null) {
            request.setDeviceAuthTargetUserId(deviceTargetUserId);
        }
        return request;
    }
}

