/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.dumpsys;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.internal.logging.dumpsys.AndroidRootResolver;
import com.facebook.internal.logging.dumpsys.ResourcesUtil;
import com.facebook.internal.logging.dumpsys.WebViewDumpHelper;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"HexColorValueUsage", "CatchGeneralException", "BadMethodUse-java.lang.String.length"})
public final class EndToEndDumpsysHelper {
    private static final String LITHO_VIEW_CLASS = "com.facebook.litho.LithoView";
    private static final String LITHO_VIEW_TEST_HELPER_CLASS = "com.facebook.litho.LithoViewTestHelper";
    private static final String LITHO_VIEW_TO_STRING_METHOD = "viewToStringForE2E";
    private static final String E2E_ARGUMENT = "e2e";
    private static final String TOP_ROOT_ARGUMENT = "top-root";
    private static final String ALL_ROOTS_ARGUMENT = "all-roots";
    private static final String WITH_WEBVIEW_ARGUMENT = "webview";
    private static final String WITH_PROPS_ARGUMENT = "props";
    private static final String RC_TEXT_VIEW_SIMPLE_CLASS_NAME = "RCTextView";
    private static EndToEndDumpsysHelper mInstance;
    @Nullable
    private static Method sRcTextViewGetTextMethod;
    private final AndroidRootResolver mRootResolver = new AndroidRootResolver();
    private final WebViewDumpHelper mWebViewDumpHelper = new WebViewDumpHelper();
    @Nullable
    private Method mLithoViewToStringMethod;

    public static boolean maybeDump(String prefix, PrintWriter writer, String[] args) {
        if (args != null && args.length > 0 && E2E_ARGUMENT.equals(args[0])) {
            if (mInstance == null) {
                mInstance = new EndToEndDumpsysHelper();
            }
            mInstance.dumpViewHierarchy(prefix, writer, args);
            return true;
        }
        return false;
    }

    private void dumpViewHierarchy(String prefix, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.println("Top Level Window View Hierarchy:");
        boolean dumpAllRoots = EndToEndDumpsysHelper.hasArgument(args, ALL_ROOTS_ARGUMENT);
        boolean dumpTopRootOnly = EndToEndDumpsysHelper.hasArgument(args, TOP_ROOT_ARGUMENT);
        boolean withWebView = EndToEndDumpsysHelper.hasArgument(args, WITH_WEBVIEW_ARGUMENT);
        boolean withProps = EndToEndDumpsysHelper.hasArgument(args, WITH_PROPS_ARGUMENT);
        try {
            List<AndroidRootResolver.Root> roots = this.mRootResolver.listActiveRoots();
            if (roots == null || roots.isEmpty()) {
                return;
            }
            Collections.reverse(roots);
            WindowManager.LayoutParams prevRootParam = null;
            for (AndroidRootResolver.Root root : roots) {
                if (root.getView().getVisibility() != 0) continue;
                if (!dumpAllRoots && prevRootParam != null && Math.abs(root.getParam().type - prevRootParam.type) != 1) break;
                this.dumpViewHierarchy(prefix + "  ", writer, root.getView(), 0, 0, withWebView, withProps);
                prevRootParam = root.getParam();
                if (!dumpTopRootOnly) continue;
                break;
            }
            this.mWebViewDumpHelper.dump(writer);
        }
        catch (Exception e) {
            writer.println("Failure in view hierarchy dump: " + e.getMessage());
        }
    }

    private void dumpViewHierarchy(String prefix, PrintWriter writer, @Nullable View view, int leftOffset, int topOffset, boolean withWebView, boolean withProps) {
        writer.print(prefix);
        if (view == null) {
            writer.println("null");
            return;
        }
        writer.print(view.getClass().getName());
        writer.print("{");
        writer.print(Integer.toHexString(view.hashCode()));
        EndToEndDumpsysHelper.writeViewFlags(writer, view);
        EndToEndDumpsysHelper.writeViewBounds(writer, view, leftOffset, topOffset);
        EndToEndDumpsysHelper.writeViewTestId(writer, view);
        EndToEndDumpsysHelper.writeViewText(writer, view);
        if (withProps && Build.VERSION.SDK_INT >= 21) {
            Api21Utils.writeExtraProps(writer, view);
        }
        writer.println("}");
        if (EndToEndDumpsysHelper.isExtendsLithoView(view)) {
            this.writeLithoViewSubHierarchy(writer, view, prefix, withProps);
        }
        if (withWebView && view instanceof WebView) {
            this.mWebViewDumpHelper.handle((WebView)view);
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup grp = (ViewGroup)view;
        int n = grp.getChildCount();
        if (n <= 0) {
            return;
        }
        prefix = prefix + "  ";
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        for (int i = 0; i < n; ++i) {
            this.dumpViewHierarchy(prefix, writer, grp.getChildAt(i), location[0], location[1], withWebView, withProps);
        }
    }

    private static boolean isExtendsLithoView(View view) {
        for (Class<?> aClass = view.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().equals(LITHO_VIEW_CLASS)) continue;
            return true;
        }
        return false;
    }

    private void writeLithoViewSubHierarchy(PrintWriter writer, View view, String prefix, boolean withProps) {
        try {
            if (this.mLithoViewToStringMethod == null) {
                Class<?> helperClass = Class.forName(LITHO_VIEW_TEST_HELPER_CLASS);
                this.mLithoViewToStringMethod = helperClass.getDeclaredMethod(LITHO_VIEW_TO_STRING_METHOD, View.class, Integer.TYPE, Boolean.TYPE);
            }
            String lithoViewDump = (String)this.mLithoViewToStringMethod.invoke(null, view, prefix.length() / 2 + 1, withProps);
            writer.append(lithoViewDump);
        }
        catch (Exception e) {
            writer.append(prefix).append("Failed litho view sub hierarch dump: ").append(EndToEndDumpsysHelper.fixString(e.getMessage(), 100)).println();
        }
    }

    private static void writeViewFlags(PrintWriter writer, View view) {
        writer.print(" ");
        switch (view.getVisibility()) {
            case 0: {
                writer.print("V");
                break;
            }
            case 4: {
                writer.print("I");
                break;
            }
            case 8: {
                writer.print("G");
                break;
            }
            default: {
                writer.print(".");
            }
        }
        writer.print(view.isFocusable() ? "F" : ".");
        writer.print(view.isEnabled() ? "E" : ".");
        writer.print(".");
        writer.print(view.isHorizontalScrollBarEnabled() ? "H" : ".");
        writer.print(view.isVerticalScrollBarEnabled() ? "V" : ".");
        writer.print(view.isClickable() ? "C" : ".");
        writer.print(view.isLongClickable() ? "L" : ".");
        writer.print(" ");
        writer.print(view.isFocused() ? "F" : ".");
        writer.print(view.isSelected() ? "S" : ".");
        writer.print(view.isHovered() ? "H" : ".");
        writer.print(view.isActivated() ? "A" : ".");
        writer.print(view.isDirty() ? "D" : ".");
    }

    private static void writeViewBounds(PrintWriter writer, View view, int leftOffset, int topOffset) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        writer.print(" ");
        writer.print(location[0] - leftOffset);
        writer.print(",");
        writer.print(location[1] - topOffset);
        writer.print("-");
        writer.print(location[0] + view.getWidth() - leftOffset);
        writer.print(",");
        writer.print(location[1] + view.getHeight() - topOffset);
    }

    private static void writeViewTestId(PrintWriter writer, View view) {
        try {
            String packageName;
            int id = view.getId();
            if (id == -1) {
                EndToEndDumpsysHelper.maybeWriteViewTestIdFromTag(writer, view);
                return;
            }
            writer.append(" #");
            writer.append(Integer.toHexString(id));
            Resources resources = view.getResources();
            if (id <= 0 || resources == null) {
                EndToEndDumpsysHelper.maybeWriteViewTestIdFromTag(writer, view);
                return;
            }
            switch (id & 0xFF000000) {
                case 0x7F000000: {
                    packageName = "app";
                    break;
                }
                case 0x1000000: {
                    packageName = "android";
                    break;
                }
                default: {
                    packageName = resources.getResourcePackageName(id);
                }
            }
            writer.print(" ");
            writer.print(packageName);
            writer.print(":");
            writer.print(resources.getResourceTypeName(id));
            writer.print("/");
            writer.print(resources.getResourceEntryName(id));
        }
        catch (Exception e) {
            EndToEndDumpsysHelper.maybeWriteViewTestIdFromTag(writer, view);
        }
    }

    private static void maybeWriteViewTestIdFromTag(PrintWriter writer, View view) {
        Object tag = view.getTag();
        if (!(tag instanceof String)) {
            return;
        }
        String tagStr = (String)tag;
        if (tagStr.length() <= 0) {
            return;
        }
        writer.print(" app:tag/");
        writer.print(EndToEndDumpsysHelper.fixString(tagStr, 60));
    }

    @SuppressLint(value={"ReflectionMethodUse"})
    private static void writeViewText(PrintWriter writer, View view) {
        try {
            String text = null;
            if (view instanceof TextView) {
                text = ((TextView)view).getText().toString();
            } else if (view.getClass().getSimpleName().equals(RC_TEXT_VIEW_SIMPLE_CLASS_NAME)) {
                text = EndToEndDumpsysHelper.getTextFromRcTextView(view);
            } else {
                Object tag;
                CharSequence content = view.getContentDescription();
                if (content != null) {
                    text = content.toString();
                }
                if ((text == null || text.isEmpty()) && (tag = view.getTag()) != null) {
                    text = tag.toString().trim();
                }
            }
            if (text == null || text.isEmpty()) {
                return;
            }
            writer.print(" text=\"");
            writer.print(EndToEndDumpsysHelper.fixString(text, 600));
            writer.print("\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SuppressLint(value={"PrivateApi", "ReflectionMethodUse"})
    @Nullable
    private static String getTextFromRcTextView(View view) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object textViewValue;
        if (sRcTextViewGetTextMethod == null) {
            sRcTextViewGetTextMethod = view.getClass().getDeclaredMethod("getText", new Class[0]);
        }
        return (textViewValue = sRcTextViewGetTextMethod.invoke((Object)view, new Object[0])) != null ? textViewValue.toString() : null;
    }

    private static String fixString(@Nullable CharSequence str, int maxLength) {
        if (str == null || str.length() < 1) {
            return "";
        }
        String fixed = str.toString().replace(" \n", " ").replace("\n", " ").replace("\"", "");
        if (str.length() > maxLength) {
            fixed = fixed.substring(0, maxLength) + "...";
        }
        return fixed;
    }

    private static boolean hasArgument(String[] args, String argument) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (!argument.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static AccessibilityNodeInfo createNodeInfoFromView(View view) {
        if (view == null) {
            return null;
        }
        AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain();
        try {
            view.onInitializeAccessibilityNodeInfo(nodeInfo);
        }
        catch (NullPointerException e) {
            if (nodeInfo != null) {
                nodeInfo.recycle();
            }
            return null;
        }
        return nodeInfo;
    }

    private static class Api24Utils {
        private Api24Utils() {
        }

        static void addExtraProps(JSONObject props, AccessibilityNodeInfo nodeInfo) throws JSONException {
            if (Build.VERSION.SDK_INT < 24) {
                return;
            }
            props.put("context-clickable", nodeInfo.isContextClickable()).put("drawing-order", nodeInfo.getDrawingOrder()).put("important-for-accessibility", nodeInfo.isImportantForAccessibility());
        }
    }

    private static class Api21Utils {
        @Nullable
        private static Field mKeyedTagsField;

        private Api21Utils() {
        }

        static void writeExtraProps(PrintWriter writer, View view) {
            if (Build.VERSION.SDK_INT < 21) {
                return;
            }
            AccessibilityNodeInfo nodeInfo = EndToEndDumpsysHelper.createNodeInfoFromView(view);
            if (nodeInfo == null) {
                return;
            }
            JSONObject props = new JSONObject();
            try {
                String cd;
                JSONObject tags;
                if (view instanceof TextView) {
                    TextView textView = (TextView)view;
                    props.put("textColor", textView.getTextColors().getDefaultColor());
                    props.put("textSize", (double)textView.getTextSize());
                    props.put("hint", (Object)EndToEndDumpsysHelper.fixString(textView.getHint(), 100));
                }
                if ((tags = Api21Utils.getTags(view)) != null) {
                    props.put("keyedTags", (Object)tags);
                }
                JSONArray actions = new JSONArray();
                for (AccessibilityNodeInfo.AccessibilityAction action : nodeInfo.getActionList()) {
                    String actionLabel = (String)action.getLabel();
                    if (actionLabel == null) continue;
                    actions.put((Object)EndToEndDumpsysHelper.fixString(actionLabel, 50));
                }
                if (actions.length() > 0) {
                    props.put("actions", (Object)actions);
                }
                if ((cd = EndToEndDumpsysHelper.fixString(nodeInfo.getContentDescription(), 50)) != null && cd.length() > 0) {
                    props.put("content-description", (Object)cd);
                }
                props.put("accessibility-focused", nodeInfo.isAccessibilityFocused()).put("checkable", nodeInfo.isCheckable()).put("checked", nodeInfo.isChecked()).put("class-name", (Object)EndToEndDumpsysHelper.fixString(nodeInfo.getClassName(), 50)).put("clickable", nodeInfo.isClickable()).put("content-invalid", nodeInfo.isContentInvalid()).put("dismissable", nodeInfo.isDismissable()).put("editable", nodeInfo.isEditable()).put("enabled", nodeInfo.isEnabled()).put("focusable", nodeInfo.isFocusable()).put("focused", nodeInfo.isFocused()).put("long-clickable", nodeInfo.isLongClickable()).put("multiline", nodeInfo.isMultiLine()).put("password", nodeInfo.isPassword()).put("scrollable", nodeInfo.isScrollable()).put("selected", nodeInfo.isSelected()).put("visible-to-user", nodeInfo.isVisibleToUser());
                if (Build.VERSION.SDK_INT >= 24) {
                    Api24Utils.addExtraProps(props, nodeInfo);
                }
            }
            catch (Exception e) {
                try {
                    props.put("DUMP-ERROR", (Object)EndToEndDumpsysHelper.fixString(e.getMessage(), 50));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            writer.append(" props=\"").append(props.toString()).append("\"");
        }

        @Nullable
        private static JSONObject getTags(View view) {
            JSONObject tags = null;
            try {
                SparseArray keyedTags;
                if (mKeyedTagsField == null) {
                    mKeyedTagsField = View.class.getDeclaredField("mKeyedTags");
                    mKeyedTagsField.setAccessible(true);
                }
                if ((keyedTags = (SparseArray)mKeyedTagsField.get(view)) != null && keyedTags.size() > 0) {
                    tags = new JSONObject();
                    int count = keyedTags.size();
                    for (int i = 0; i < count; ++i) {
                        String id = ResourcesUtil.getIdStringQuietly(view.getResources(), keyedTags.keyAt(i));
                        try {
                            tags.put(id, keyedTags.valueAt(i));
                            continue;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tags;
        }

        static {
            try {
                mKeyedTagsField = View.class.getDeclaredField("mKeyedTags");
                mKeyedTagsField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }
}

