/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.iap;

import androidx.annotation.RestrictTo;
import com.facebook.appevents.iap.InAppPurchaseActivityLifecycleTracker;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InAppPurchaseManager {
    private static final AtomicBoolean enabled = new AtomicBoolean(false);

    public static void enableAutoLogging() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            enabled.set(true);
            InAppPurchaseManager.startTracking();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    public static void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return;
        }
        try {
            if (!(!enabled.get() || InAppPurchaseManager.usingBillingLib2Plus() && FeatureManager.isEnabled(FeatureManager.Feature.IapLoggingLib2))) {
                InAppPurchaseActivityLifecycleTracker.startIapLogging();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return;
        }
    }

    private static boolean usingBillingLib2Plus() {
        if (CrashShieldHandler.isObjectCrashing(InAppPurchaseManager.class)) {
            return false;
        }
        try {
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InAppPurchaseManager.class);
            return false;
        }
    }
}

