/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

class RequestProgress {
    private final GraphRequest request;
    private final Handler callbackHandler;
    private final long threshold;
    private long progress;
    private long lastReportedProgress;
    private long maxProgress;

    RequestProgress(Handler callbackHandler, GraphRequest request2) {
        this.request = request2;
        this.callbackHandler = callbackHandler;
        this.threshold = FacebookSdk.getOnProgressThreshold();
    }

    long getProgress() {
        return this.progress;
    }

    long getMaxProgress() {
        return this.maxProgress;
    }

    void addProgress(long size) {
        this.progress += size;
        if (this.progress >= this.lastReportedProgress + this.threshold || this.progress >= this.maxProgress) {
            this.reportProgress();
        }
    }

    void addToMax(long size) {
        this.maxProgress += size;
    }

    void reportProgress() {
        if (this.progress > this.lastReportedProgress) {
            GraphRequest.Callback callback = this.request.getCallback();
            if (this.maxProgress > 0L && callback instanceof GraphRequest.OnProgressCallback) {
                final long currentCopy = this.progress;
                final long maxProgressCopy = this.maxProgress;
                final GraphRequest.OnProgressCallback callbackCopy = (GraphRequest.OnProgressCallback)callback;
                if (this.callbackHandler == null) {
                    callbackCopy.onProgress(currentCopy, maxProgressCopy);
                } else {
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (CrashShieldHandler.isObjectCrashing(this)) {
                                return;
                            }
                            try {
                                callbackCopy.onProgress(currentCopy, maxProgressCopy);
                                return;
                            }
                            catch (Throwable throwable) {
                                CrashShieldHandler.handleThrowable(throwable, this);
                                return;
                            }
                        }
                    });
                }
                this.lastReportedProgress = this.progress;
            }
        }
    }
}

