/*
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
 * copy, modify, and distribute this software in source code or binary form for use
 * in connection with the web services and APIs provided by Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use of
 * this software is subject to the Facebook Developer Principles and Policies
 * [http://developers.facebook.com/policy/]. This copyright notice shall be
 * included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.facebook.appevents.internal;

import android.os.AsyncTask;
import com.facebook.internal.qualityvalidation.Excuse;
import com.facebook.internal.qualityvalidation.ExcusesForDesignViolations;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;

@ExcusesForDesignViolations(@Excuse(type = "MISSING_UNIT_TEST", reason = "Legacy"))
public class FileDownloadTask extends AsyncTask<String, Void, Boolean> {

  private Callback onSuccess;
  private File destFile;
  private String uriStr;

  public FileDownloadTask(String uriStr, File destFile, Callback onSuccess) {
    this.uriStr = uriStr;
    this.destFile = destFile;
    this.onSuccess = onSuccess;
  }

  @Override
  protected Boolean doInBackground(String... args) {
    try {
      URL url = new URL(uriStr);
      URLConnection conn = url.openConnection();
      int contentLength = conn.getContentLength();

      DataInputStream stream = new DataInputStream(url.openStream());

      byte[] buffer = new byte[contentLength];
      stream.readFully(buffer);
      stream.close();

      DataOutputStream fos = new DataOutputStream(new FileOutputStream(destFile));
      fos.write(buffer);
      fos.flush();
      fos.close();
      return true;
    } catch (Exception e) {
      /* no op */
    }
    return false;
  }

  @Override
  protected void onPostExecute(Boolean isSuccess) {
    if (isSuccess) {
      onSuccess.onComplete(destFile);
    }
  }

  public interface Callback {

    void onComplete(File file);
  }
}
