/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.logging.monitor.Monitor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MonitorManager {
    private static MonitorCreator monitorCreator = new MonitorCreator(){

        @Override
        public void enable() {
            Monitor.enable();
        }
    };

    public static void start() {
        if (!FacebookSdk.getMonitorEnabled()) {
            return;
        }
        String appId = FacebookSdk.getApplicationId();
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        if (settings != null && settings.getMonitorViaDialogEnabled()) {
            monitorCreator.enable();
        }
    }

    @VisibleForTesting
    static void setMonitorCreator(MonitorCreator monitorCreator) {
        MonitorManager.monitorCreator = monitorCreator;
    }

    @VisibleForTesting
    public static interface MonitorCreator {
        public void enable();
    }
}

