/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import com.facebook.internal.Utility;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/internal/FacebookSignatureValidator;", "", "()V", "FBF_HASH", "", "FBI_HASH", "FBL2_HASH", "FBL_HASH", "FBR2_HASH", "FBR_HASH", "MSR_HASH", "validAppSignatureHashes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "validateSignature", "", "context", "Landroid/content/Context;", "packageName", "facebook-core_release"})
public final class FacebookSignatureValidator {
    private static final String FBI_HASH = "a4b7452e2ed8f5f191058ca7bbfd26b0d3214bfc";
    private static final String FBL_HASH = "5e8f16062ea3cd2c4a0d547876baa6f38cabf625";
    private static final String FBL2_HASH = "df6b721c8b4d3b6eb44c861d4415007e5a35fc95";
    private static final String FBR_HASH = "8a3c4b262d721acd49a4bf97d5213199c86fa2b9";
    private static final String FBR2_HASH = "cc2751449a350f668590264ed76692694a80308a";
    private static final String MSR_HASH = "9b8f518b086098de3d77736f9458a3d2f6f95a37";
    private static final String FBF_HASH = "2438bce1ddb7bd026d5ff89f598b3b5e5bb824b3";
    private static final HashSet<String> validAppSignatureHashes;
    public static final FacebookSignatureValidator INSTANCE;

    @JvmStatic
    public static final boolean validateSignature(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String brand = Build.BRAND;
        int applicationFlags = context.getApplicationInfo().flags;
        String string = brand;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"brand");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null) && (applicationFlags & 2) != 0) {
            return true;
        }
        try {
            boolean bl;
            block7: {
                PackageInfo packageInfo;
                block9: {
                    block8: {
                        packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
                        if (packageInfo.signatures == null) break block8;
                        Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"packageInfo.signatures");
                        Signature[] signatureArray = packageInfo.signatures;
                        boolean bl2 = false;
                        if (!(signatureArray.length == 0)) break block9;
                    }
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo.signatures, (String)"packageInfo.signatures");
                Signature[] $this$all$iv = packageInfo.signatures;
                boolean $i$f$all = false;
                Signature[] signatureArray = $this$all$iv;
                int n = signatureArray.length;
                for (int i = 0; i < n; ++i) {
                    Signature element$iv;
                    Signature it = element$iv = signatureArray[i];
                    boolean bl3 = false;
                    if (validAppSignatureHashes.contains(Utility.sha1hash(it.toByteArray()))) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            return bl;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private FacebookSignatureValidator() {
    }

    static {
        FacebookSignatureValidator facebookSignatureValidator;
        INSTANCE = facebookSignatureValidator = new FacebookSignatureValidator();
        validAppSignatureHashes = SetsKt.hashSetOf((Object[])new String[]{FBR_HASH, FBR2_HASH, FBI_HASH, FBL_HASH, FBL2_HASH, MSR_HASH, FBF_HASH});
    }
}

