/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookRequestError;
import com.facebook.internal.FacebookRequestErrorClassification$WhenMappings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u007f\b\u0000\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012R'\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/internal/FacebookRequestErrorClassification;", "", "otherErrors", "", "", "", "transientErrors", "loginRecoverableErrors", "otherRecoveryMessage", "", "transientRecoveryMessage", "loginRecoverableRecoveryMessage", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLoginRecoverableErrors", "()Ljava/util/Map;", "getOtherErrors", "getTransientErrors", "classify", "Lcom/facebook/FacebookRequestError$Category;", "errorCode", "errorSubCode", "isTransient", "", "getRecoveryMessage", "category", "Companion", "facebook-core_release"})
public final class FacebookRequestErrorClassification {
    @Nullable
    private final Map<Integer, Set<Integer>> otherErrors;
    @Nullable
    private final Map<Integer, Set<Integer>> transientErrors;
    @Nullable
    private final Map<Integer, Set<Integer>> loginRecoverableErrors;
    private final String otherRecoveryMessage;
    private final String transientRecoveryMessage;
    private final String loginRecoverableRecoveryMessage;
    public static final int EC_SERVICE_UNAVAILABLE = 2;
    public static final int EC_APP_TOO_MANY_CALLS = 4;
    public static final int EC_RATE = 9;
    public static final int EC_USER_TOO_MANY_CALLS = 17;
    public static final int EC_INVALID_SESSION = 102;
    public static final int EC_INVALID_TOKEN = 190;
    public static final int EC_APP_NOT_INSTALLED = 412;
    public static final int EC_TOO_MANY_USER_ACTION_CALLS = 341;
    public static final int ESC_APP_NOT_INSTALLED = 458;
    public static final int ESC_APP_INACTIVE = 493;
    @NotNull
    public static final String KEY_RECOVERY_MESSAGE = "recovery_message";
    @NotNull
    public static final String KEY_NAME = "name";
    @NotNull
    public static final String KEY_OTHER = "other";
    @NotNull
    public static final String KEY_TRANSIENT = "transient";
    @NotNull
    public static final String KEY_LOGIN_RECOVERABLE = "login_recoverable";
    private static FacebookRequestErrorClassification defaultInstance;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getRecoveryMessage(@Nullable FacebookRequestError.Category category) {
        FacebookRequestError.Category category2 = category;
        if (category2 == null) return null;
        switch (FacebookRequestErrorClassification$WhenMappings.$EnumSwitchMapping$0[category2.ordinal()]) {
            case 1: {
                String string = this.otherRecoveryMessage;
                return string;
            }
            case 2: {
                String string = this.loginRecoverableRecoveryMessage;
                return string;
            }
            case 3: {
                String string = this.transientRecoveryMessage;
                return string;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public final FacebookRequestError.Category classify(int errorCode, int errorSubCode, boolean isTransient) {
        Set<Integer> subCodes;
        if (isTransient) {
            return FacebookRequestError.Category.TRANSIENT;
        }
        if (this.otherErrors != null && this.otherErrors.containsKey(errorCode) && ((subCodes = this.otherErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.OTHER;
        }
        if (this.loginRecoverableErrors != null && this.loginRecoverableErrors.containsKey(errorCode) && ((subCodes = this.loginRecoverableErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.LOGIN_RECOVERABLE;
        }
        if (this.transientErrors != null && this.transientErrors.containsKey(errorCode) && ((subCodes = this.transientErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.TRANSIENT;
        }
        return FacebookRequestError.Category.OTHER;
    }

    @Nullable
    public final Map<Integer, Set<Integer>> getOtherErrors() {
        return this.otherErrors;
    }

    @Nullable
    public final Map<Integer, Set<Integer>> getTransientErrors() {
        return this.transientErrors;
    }

    @Nullable
    public final Map<Integer, Set<Integer>> getLoginRecoverableErrors() {
        return this.loginRecoverableErrors;
    }

    public FacebookRequestErrorClassification(@Nullable Map<Integer, ? extends Set<Integer>> otherErrors, @Nullable Map<Integer, ? extends Set<Integer>> transientErrors, @Nullable Map<Integer, ? extends Set<Integer>> loginRecoverableErrors, @Nullable String otherRecoveryMessage, @Nullable String transientRecoveryMessage, @Nullable String loginRecoverableRecoveryMessage) {
        this.otherErrors = otherErrors;
        this.transientErrors = transientErrors;
        this.loginRecoverableErrors = loginRecoverableErrors;
        this.otherRecoveryMessage = otherRecoveryMessage;
        this.transientRecoveryMessage = transientRecoveryMessage;
        this.loginRecoverableRecoveryMessage = loginRecoverableRecoveryMessage;
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @NotNull
    public static final synchronized FacebookRequestErrorClassification getDefaultErrorClassification() {
        return Companion.getDefaultErrorClassification();
    }

    @JvmStatic
    @Nullable
    public static final FacebookRequestErrorClassification createFromJSON(@Nullable JSONArray jsonArray) {
        return Companion.createFromJSON(jsonArray);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0015H\u0007J&\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/facebook/internal/FacebookRequestErrorClassification$Companion;", "", "()V", "EC_APP_NOT_INSTALLED", "", "EC_APP_TOO_MANY_CALLS", "EC_INVALID_SESSION", "EC_INVALID_TOKEN", "EC_RATE", "EC_SERVICE_UNAVAILABLE", "EC_TOO_MANY_USER_ACTION_CALLS", "EC_USER_TOO_MANY_CALLS", "ESC_APP_INACTIVE", "ESC_APP_NOT_INSTALLED", "KEY_LOGIN_RECOVERABLE", "", "KEY_NAME", "KEY_OTHER", "KEY_RECOVERY_MESSAGE", "KEY_TRANSIENT", "defaultErrorClassificationImpl", "Lcom/facebook/internal/FacebookRequestErrorClassification;", "getDefaultErrorClassificationImpl", "()Lcom/facebook/internal/FacebookRequestErrorClassification;", "defaultInstance", "createFromJSON", "jsonArray", "Lorg/json/JSONArray;", "getDefaultErrorClassification", "parseJSONDefinition", "", "", "definition", "Lorg/json/JSONObject;", "facebook-core_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final synchronized FacebookRequestErrorClassification getDefaultErrorClassification() {
            if (defaultInstance == null) {
                defaultInstance = this.getDefaultErrorClassificationImpl();
            }
            FacebookRequestErrorClassification facebookRequestErrorClassification = defaultInstance;
            if (facebookRequestErrorClassification == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.facebook.internal.FacebookRequestErrorClassification");
            }
            return facebookRequestErrorClassification;
        }

        private final FacebookRequestErrorClassification getDefaultErrorClassificationImpl() {
            HashMap transientErrors = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)2, null), TuplesKt.to((Object)4, null), TuplesKt.to((Object)9, null), TuplesKt.to((Object)17, null), TuplesKt.to((Object)341, null)});
            Map loginRecoverableErrors = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)102, null), TuplesKt.to((Object)190, null), TuplesKt.to((Object)412, null)});
            return new FacebookRequestErrorClassification(null, transientErrors, loginRecoverableErrors, null, null, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Integer, Set<Integer>> parseJSONDefinition(JSONObject definition) {
            JSONArray itemsArray = definition.optJSONArray("items");
            if (itemsArray.length() == 0) {
                return null;
            }
            Map items = new HashMap();
            int n = 0;
            int n2 = itemsArray.length();
            while (n < n2) {
                void i;
                if (itemsArray.optJSONObject((int)i) == null) {
                } else {
                    JSONObject item;
                    int code = item.optInt("code");
                    if (code != 0) {
                        Set subcodes = null;
                        JSONArray subcodesArray = item.optJSONArray("subcodes");
                        if (subcodesArray != null && subcodesArray.length() > 0) {
                            subcodes = new HashSet();
                            int n3 = 0;
                            int n4 = subcodesArray.length();
                            while (n3 < n4) {
                                void j;
                                int subCode = subcodesArray.optInt((int)j);
                                if (subCode != 0) {
                                    subcodes.add(subCode);
                                }
                                ++j;
                            }
                        }
                        items.put(code, subcodes);
                    }
                }
                ++i;
            }
            return items;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final FacebookRequestErrorClassification createFromJSON(@Nullable JSONArray jsonArray) {
            if (jsonArray == null) {
                return null;
            }
            Map<Integer, Set<Integer>> otherErrors = null;
            Map<Integer, Set<Integer>> transientErrors = null;
            Map<Integer, Set<Integer>> loginRecoverableErrors = null;
            String otherRecoveryMessage = null;
            String transientRecoveryMessage = null;
            String loginRecoverableRecoveryMessage = null;
            int n = 0;
            int n2 = jsonArray.length();
            while (n < n2) {
                String name;
                JSONObject definition;
                void i;
                if (jsonArray.optJSONObject((int)i) == null) {
                } else if (definition.optString(FacebookRequestErrorClassification.KEY_NAME) == null) {
                } else if (StringsKt.equals((String)name, (String)FacebookRequestErrorClassification.KEY_OTHER, (boolean)true)) {
                    otherRecoveryMessage = definition.optString(FacebookRequestErrorClassification.KEY_RECOVERY_MESSAGE, null);
                    otherErrors = this.parseJSONDefinition(definition);
                } else if (StringsKt.equals((String)name, (String)FacebookRequestErrorClassification.KEY_TRANSIENT, (boolean)true)) {
                    transientRecoveryMessage = definition.optString(FacebookRequestErrorClassification.KEY_RECOVERY_MESSAGE, null);
                    transientErrors = this.parseJSONDefinition(definition);
                } else if (StringsKt.equals((String)name, (String)FacebookRequestErrorClassification.KEY_LOGIN_RECOVERABLE, (boolean)true)) {
                    loginRecoverableRecoveryMessage = definition.optString(FacebookRequestErrorClassification.KEY_RECOVERY_MESSAGE, null);
                    loginRecoverableErrors = this.parseJSONDefinition(definition);
                }
                ++i;
            }
            return new FacebookRequestErrorClassification((Map<Integer, ? extends Set<Integer>>)otherErrors, (Map<Integer, ? extends Set<Integer>>)transientErrors, (Map<Integer, ? extends Set<Integer>>)loginRecoverableErrors, otherRecoveryMessage, transientRecoveryMessage, loginRecoverableRecoveryMessage);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

