/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.bolts;

import com.facebook.bolts.BoltsExecutors;
import com.facebook.bolts.CancellationToken;
import com.facebook.bolts.CancellationTokenRegistration;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CancellationTokenSource
implements Closeable {
    private final Object lock = new Object();
    private final List<CancellationTokenRegistration> registrations = new ArrayList<CancellationTokenRegistration>();
    private final ScheduledExecutorService executor = BoltsExecutors.scheduled();
    private ScheduledFuture<?> scheduledCancellation;
    private boolean cancellationRequested;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancellationRequested() {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            return this.cancellationRequested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationToken getToken() {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            return new CancellationToken(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayList<CancellationTokenRegistration> registrations;
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            if (this.cancellationRequested) {
                return;
            }
            this.cancelScheduledCancellation();
            this.cancellationRequested = true;
            registrations = new ArrayList<CancellationTokenRegistration>(this.registrations);
        }
        this.notifyListeners(registrations);
    }

    public void cancelAfter(long delay) {
        this.cancelAfter(delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAfter(long delay, TimeUnit timeUnit) {
        if (delay < -1L) {
            throw new IllegalArgumentException("Delay must be >= -1");
        }
        if (delay == 0L) {
            this.cancel();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellationRequested) {
                return;
            }
            this.cancelScheduledCancellation();
            if (delay != -1L) {
                this.scheduledCancellation = this.executor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            Object object = CancellationTokenSource.this.lock;
                            synchronized (object) {
                                CancellationTokenSource.this.scheduledCancellation = null;
                            }
                            CancellationTokenSource.this.cancel();
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                }, delay, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.cancelScheduledCancellation();
            for (CancellationTokenRegistration registration : this.registrations) {
                registration.close();
            }
            this.registrations.clear();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CancellationTokenRegistration register(Runnable action) {
        CancellationTokenRegistration ctr;
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            ctr = new CancellationTokenRegistration(this, action);
            if (this.cancellationRequested) {
                ctr.runAction();
            } else {
                this.registrations.add(ctr);
            }
        }
        return ctr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void throwIfCancellationRequested() throws CancellationException {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            if (this.cancellationRequested) {
                throw new CancellationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(CancellationTokenRegistration registration) {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            this.registrations.remove(registration);
        }
    }

    private void notifyListeners(List<CancellationTokenRegistration> registrations) {
        for (CancellationTokenRegistration registration : registrations) {
            registration.runAction();
        }
    }

    public String toString() {
        return String.format(Locale.US, "%s@%s[cancellationRequested=%s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), Boolean.toString(this.isCancellationRequested()));
    }

    private void throwIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Object already closed");
        }
    }

    private void cancelScheduledCancellation() {
        if (this.scheduledCancellation != null) {
            this.scheduledCancellation.cancel(true);
            this.scheduledCancellation = null;
        }
    }
}

