/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceWrapper;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class OnDeviceProcessingManager {
    private static final Set<String> ALLOWED_IMPLICIT_EVENTS = new HashSet<String>(Arrays.asList("fb_mobile_purchase", "StartTrial", "Subscribe"));

    public static boolean isOnDeviceProcessingEnabled() {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return false;
        }
        try {
            Context context = FacebookSdk.getApplicationContext();
            boolean isApplicationTrackingEnabled = !FacebookSdk.getLimitEventAndDataUsage(context) && !Utility.isDataProcessingRestricted();
            return isApplicationTrackingEnabled && RemoteServiceWrapper.isServiceAvailable();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sendInstallEventAsync(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return;
        }
        try {
            void preferencesName;
            String applicationId;
            final Context context = FacebookSdk.getApplicationContext();
            if (context != null && applicationId != null && preferencesName != null) {
                FacebookSdk.getExecutor().execute(new Runnable((String)preferencesName, applicationId){
                    final /* synthetic */ String val$preferencesName;
                    final /* synthetic */ String val$applicationId;
                    {
                        this.val$preferencesName = string;
                        this.val$applicationId = string2;
                    }

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            SharedPreferences preferences = context.getSharedPreferences(this.val$preferencesName, 0);
                            String pingKey = this.val$applicationId + "pingForOnDevice";
                            long lastOnDevicePing = preferences.getLong(pingKey, 0L);
                            if (lastOnDevicePing == 0L) {
                                RemoteServiceWrapper.sendInstallEvent(this.val$applicationId);
                                SharedPreferences.Editor editor = preferences.edit();
                                lastOnDevicePing = System.currentTimeMillis();
                                editor.putLong(pingKey, lastOnDevicePing);
                                editor.apply();
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sendCustomEventAsync(String string, AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return;
        }
        try {
            void event;
            if (OnDeviceProcessingManager.isEventEligibleForOnDeviceProcessing((AppEvent)event)) {
                String applicationId;
                FacebookSdk.getExecutor().execute(new Runnable((AppEvent)event){
                    final /* synthetic */ AppEvent val$event;
                    {
                        this.val$event = appEvent;
                    }

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            RemoteServiceWrapper.sendCustomEvents(applicationId, Arrays.asList(this.val$event));
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return;
        }
    }

    private static boolean isEventEligibleForOnDeviceProcessing(AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(OnDeviceProcessingManager.class)) {
            return false;
        }
        try {
            AppEvent event;
            boolean isAllowedImplicitEvent = event.getIsImplicit() && ALLOWED_IMPLICIT_EVENTS.contains(event.getName());
            boolean isExplicitEvent = !event.getIsImplicit();
            return isExplicitEvent || isAllowedImplicitEvent;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, OnDeviceProcessingManager.class);
            return false;
        }
    }
}

