/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.Patterns;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class UserDataStore {
    private static final String TAG = UserDataStore.class.getSimpleName();
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    private static final String INTERNAL_USER_DATA_KEY = "com.facebook.appevents.UserDataStore.internalUserData";
    private static SharedPreferences sharedPreferences;
    private static AtomicBoolean initialized;
    private static final int MAX_NUM = 5;
    private static final String DATA_SEPARATOR = ",";
    private static final ConcurrentHashMap<String, String> externalHashedUserData;
    private static final ConcurrentHashMap<String, String> internalHashedUserData;
    public static final String EMAIL = "em";
    public static final String FIRST_NAME = "fn";
    public static final String LAST_NAME = "ln";
    public static final String PHONE = "ph";
    public static final String DATE_OF_BIRTH = "db";
    public static final String GENDER = "ge";
    public static final String CITY = "ct";
    public static final String STATE = "st";
    public static final String ZIP = "zp";
    public static final String COUNTRY = "country";

    static void initStore() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            if (initialized.get()) {
                return;
            }
            UserDataStore.initAndWait();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeDataIntoCache(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            void value;
            String key;
            FacebookSdk.getExecutor().execute(new Runnable((String)value){
                final /* synthetic */ String val$value;
                {
                    this.val$value = string2;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (!UserDataStore.access$000().get()) {
                            UserDataStore.access$100();
                        }
                        UserDataStore.access$200().edit().putString(key, this.val$value).apply();
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static void setUserDataAndHash(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Bundle ud;
            InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (!UserDataStore.access$000().get()) {
                            Log.w((String)UserDataStore.access$300(), (String)"initStore should have been called before calling setUserData");
                            UserDataStore.access$100();
                        }
                        UserDataStore.access$400(ud);
                        UserDataStore.access$600(UserDataStore.USER_DATA_KEY, Utility.mapToJsonStr(UserDataStore.access$500()));
                        UserDataStore.access$600(UserDataStore.INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr(UserDataStore.access$700()));
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setUserDataAndHash(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            void country;
            void zip;
            void state;
            void city;
            void gender;
            void dateOfBirth;
            void phone;
            void lastName;
            void firstName;
            String email;
            Bundle ud = new Bundle();
            if (email != null) {
                ud.putString(EMAIL, email);
            }
            if (firstName != null) {
                ud.putString(FIRST_NAME, (String)firstName);
            }
            if (lastName != null) {
                ud.putString(LAST_NAME, (String)lastName);
            }
            if (phone != null) {
                ud.putString(PHONE, (String)phone);
            }
            if (dateOfBirth != null) {
                ud.putString(DATE_OF_BIRTH, (String)dateOfBirth);
            }
            if (gender != null) {
                ud.putString(GENDER, (String)gender);
            }
            if (city != null) {
                ud.putString(CITY, (String)city);
            }
            if (state != null) {
                ud.putString(STATE, (String)state);
            }
            if (zip != null) {
                ud.putString(ZIP, (String)zip);
            }
            if (country != null) {
                ud.putString(COUNTRY, (String)country);
            }
            UserDataStore.setUserDataAndHash(ud);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static void clear() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (!UserDataStore.access$000().get()) {
                            Log.w((String)UserDataStore.access$300(), (String)"initStore should have been called before calling setUserData");
                            UserDataStore.access$100();
                        }
                        UserDataStore.access$500().clear();
                        UserDataStore.access$200().edit().putString(UserDataStore.USER_DATA_KEY, null).apply();
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static String getHashedUserData() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            if (!initialized.get()) {
                Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
                UserDataStore.initAndWait();
            }
            return Utility.mapToJsonStr(externalHashedUserData);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    public static String getAllHashedUserData() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            if (!initialized.get()) {
                UserDataStore.initAndWait();
            }
            HashMap<String, String> allHashedUserData = new HashMap<String, String>();
            allHashedUserData.putAll(externalHashedUserData);
            allHashedUserData.putAll(UserDataStore.getEnabledInternalUserData());
            return Utility.mapToJsonStr(allHashedUserData);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    private static Map<String, String> getEnabledInternalUserData() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            HashMap<String, String> enabledInternalUD = new HashMap<String, String>();
            Set<String> ruleNames = MetadataRule.getEnabledRuleNames();
            for (String ruleKey : internalHashedUserData.keySet()) {
                if (!ruleNames.contains(ruleKey)) continue;
                enabledInternalUD.put(ruleKey, internalHashedUserData.get(ruleKey));
            }
            return enabledInternalUD;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    private static synchronized void initAndWait() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            if (initialized.get()) {
                return;
            }
            sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
            String externalUdRaw = sharedPreferences.getString(USER_DATA_KEY, "");
            String internalUdRaw = sharedPreferences.getString(INTERNAL_USER_DATA_KEY, "");
            externalHashedUserData.putAll(Utility.JsonStrToMap(externalUdRaw));
            internalHashedUserData.putAll(Utility.JsonStrToMap(internalUdRaw));
            initialized.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    private static void updateHashUserData(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Bundle ud;
            if (ud == null) {
                return;
            }
            for (String key : ud.keySet()) {
                Object rawVal = ud.get(key);
                if (rawVal == null) continue;
                String value = rawVal.toString();
                if (UserDataStore.maybeSHA256Hashed(value)) {
                    externalHashedUserData.put(key, value.toLowerCase());
                    continue;
                }
                String encryptedValue = Utility.sha256hash(UserDataStore.normalizeData(key, value));
                if (encryptedValue == null) continue;
                externalHashedUserData.put(key, encryptedValue);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static void setInternalUd(Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Map<String, String> ud;
            if (!initialized.get()) {
                UserDataStore.initAndWait();
            }
            for (Map.Entry<String, String> entry : ud.entrySet()) {
                String key = entry.getKey();
                String rawVal = ud.get(key);
                String value = Utility.sha256hash(UserDataStore.normalizeData(key, rawVal.trim()));
                if (internalHashedUserData.containsKey(key)) {
                    String originalVal = internalHashedUserData.get(key);
                    String[] previousData = originalVal != null ? originalVal.split(DATA_SEPARATOR) : new String[]{};
                    HashSet<String> set = new HashSet<String>(Arrays.asList(previousData));
                    if (set.contains(value)) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    if (previousData.length == 0) {
                        sb.append(value);
                    } else if (previousData.length < 5) {
                        sb.append(originalVal).append(DATA_SEPARATOR).append(value);
                    } else {
                        for (int i = 1; i < 5; ++i) {
                            sb.append(previousData[i]).append(DATA_SEPARATOR);
                        }
                        sb.append(value);
                        set.remove(previousData[0]);
                    }
                    internalHashedUserData.put(key, sb.toString());
                    continue;
                }
                internalHashedUserData.put(key, value);
            }
            UserDataStore.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr(internalHashedUserData));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    private static String normalizeData(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            String type;
            String data;
            data = data.trim().toLowerCase();
            if (EMAIL.equals(type)) {
                if (Patterns.EMAIL_ADDRESS.matcher(data).matches()) {
                    return data;
                }
                Log.e((String)TAG, (String)"Setting email failure: this is not a valid email address");
                return "";
            }
            if (PHONE.equals(type)) {
                return data.replaceAll("[^0-9]", "");
            }
            if (GENDER.equals(type)) {
                String string3 = data = data.length() > 0 ? data.substring(0, 1) : "";
                if ("f".equals(data) || "m".equals(data)) {
                    return data;
                }
                Log.e((String)TAG, (String)"Setting gender failure: the supported value for gender is f or m");
                return "";
            }
            return data;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    private static boolean maybeSHA256Hashed(String string) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return false;
        }
        try {
            String data;
            return data.matches("[A-Fa-f0-9]{64}");
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return false;
        }
    }

    static /* synthetic */ AtomicBoolean access$000() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            return initialized;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    static /* synthetic */ void access$100() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            UserDataStore.initAndWait();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static /* synthetic */ SharedPreferences access$200() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            return sharedPreferences;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    static /* synthetic */ String access$300() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    static /* synthetic */ void access$400(Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            Bundle x0;
            UserDataStore.updateHashUserData(x0);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static /* synthetic */ ConcurrentHashMap access$500() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            return externalHashedUserData;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return;
        }
        try {
            void x1;
            String x0;
            UserDataStore.writeDataIntoCache(x0, (String)x1);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return;
        }
    }

    static /* synthetic */ ConcurrentHashMap access$700() {
        if (CrashShieldHandler.isObjectCrashing(UserDataStore.class)) {
            return null;
        }
        try {
            return internalHashedUserData;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, UserDataStore.class);
            return null;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
        externalHashedUserData = new ConcurrentHashMap();
        internalHashedUserData = new ConcurrentHashMap();
    }
}

