/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PerformanceGuardian {
    private static boolean initialized = false;
    private static SharedPreferences sharedPreferences;
    private static final String BANNED_ACTIVITY_STORE = "com.facebook.internal.BANNED_ACTIVITY";
    private static final String CACHE_APP_VERSION = "app_version";
    private static final Integer ACTIVITY_PROCESS_TIME_THRESHOLD;
    private static final Integer MAX_EXCEED_LIMIT_COUNT;
    private static final Set<String> bannedSuggestedEventActivitySet;
    private static final Set<String> bannedCodelessActivitySet;
    private static final Map<String, Integer> activityProcessTimeMapCodeless;
    private static final Map<String, Integer> activityProcessTimeMapSe;

    private static synchronized void initializeIfNotYet() {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return;
        }
        try {
            if (initialized) {
                return;
            }
            sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(BANNED_ACTIVITY_STORE, 0);
            String cachedVersion = sharedPreferences.getString(CACHE_APP_VERSION, "");
            if (!PerformanceGuardian.isCacheValid(cachedVersion)) {
                sharedPreferences.edit().clear().apply();
            } else {
                bannedCodelessActivitySet.addAll(sharedPreferences.getStringSet(UseCase.CODELESS.toString(), new HashSet()));
                bannedSuggestedEventActivitySet.addAll(sharedPreferences.getStringSet(UseCase.SUGGESTED_EVENT.toString(), new HashSet()));
            }
            initialized = true;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBannedActivity(String string, UseCase useCase) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return false;
        }
        try {
            void useCase2;
            PerformanceGuardian.initializeIfNotYet();
            switch (1.$SwitchMap$com$facebook$appevents$PerformanceGuardian$UseCase[useCase2.ordinal()]) {
                case 1: {
                    String activityName;
                    return bannedCodelessActivitySet.contains(activityName);
                }
                case 2: {
                    String activityName;
                    return bannedSuggestedEventActivitySet.contains(activityName);
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void limitProcessTime(String string, UseCase useCase, long l, long l2) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return;
        }
        try {
            void useCase2;
            String activityName;
            void startTime;
            void endTime;
            PerformanceGuardian.initializeIfNotYet();
            void processTime = endTime - startTime;
            if (activityName == null || processTime < (long)ACTIVITY_PROCESS_TIME_THRESHOLD.intValue()) {
                return;
            }
            switch (1.$SwitchMap$com$facebook$appevents$PerformanceGuardian$UseCase[useCase2.ordinal()]) {
                case 1: {
                    PerformanceGuardian.updateActivityMap((UseCase)useCase2, activityName, activityProcessTimeMapCodeless, bannedCodelessActivitySet);
                    break;
                }
                case 2: {
                    PerformanceGuardian.updateActivityMap((UseCase)useCase2, activityName, activityProcessTimeMapSe, bannedSuggestedEventActivitySet);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void updateActivityMap(UseCase useCase, String string, Map<String, Integer> map, Set<String> set) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return;
        }
        try {
            void activityName;
            void activityExceedLimitCountMap;
            int curExceedLimitCount = 0;
            if (activityExceedLimitCountMap.containsKey(activityName)) {
                curExceedLimitCount = (Integer)activityExceedLimitCountMap.get(activityName);
            }
            activityExceedLimitCountMap.put(activityName, curExceedLimitCount + 1);
            if (curExceedLimitCount + 1 >= MAX_EXCEED_LIMIT_COUNT) {
                UseCase useCase2;
                void bannedActivitySet;
                bannedActivitySet.add(activityName);
                sharedPreferences.edit().putStringSet(useCase2.toString(), (Set)bannedActivitySet).putString(CACHE_APP_VERSION, Utility.getAppVersion()).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return;
        }
    }

    private static boolean isCacheValid(String string) {
        if (CrashShieldHandler.isObjectCrashing(PerformanceGuardian.class)) {
            return false;
        }
        try {
            String previousVersion;
            String appVersion = Utility.getAppVersion();
            if (appVersion == null || previousVersion.isEmpty()) {
                return false;
            }
            return previousVersion.equals(appVersion);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PerformanceGuardian.class);
            return false;
        }
    }

    static {
        ACTIVITY_PROCESS_TIME_THRESHOLD = 40;
        MAX_EXCEED_LIMIT_COUNT = 3;
        bannedSuggestedEventActivitySet = new HashSet<String>();
        bannedCodelessActivitySet = new HashSet<String>();
        activityProcessTimeMapCodeless = new HashMap<String, Integer>();
        activityProcessTimeMapSe = new HashMap<String, Integer>();
    }

    public static enum UseCase {
        CODELESS,
        SUGGESTED_EVENT;

    }
}

