/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.AppEventsLoggerImpl;
import com.facebook.appevents.UserDataStore;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Map;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InternalAppEventsLogger {
    private AppEventsLoggerImpl loggerImpl;

    public InternalAppEventsLogger(Context context) {
        this(new AppEventsLoggerImpl(context, null, null));
    }

    public InternalAppEventsLogger(Context context, String applicationId) {
        this(new AppEventsLoggerImpl(context, applicationId, null));
    }

    public InternalAppEventsLogger(String activityName, String applicationId, AccessToken accessToken) {
        this(new AppEventsLoggerImpl(activityName, applicationId, accessToken));
    }

    @VisibleForTesting
    InternalAppEventsLogger(AppEventsLoggerImpl logger) {
        this.loggerImpl = logger;
    }

    public void logEvent(String eventName, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEvent(eventName, parameters);
        }
    }

    public void logEvent(String eventName, double valueToSum, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEvent(eventName, valueToSum, parameters);
        }
    }

    public void logPurchaseImplicitly(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logPurchaseImplicitly(purchaseAmount, currency, parameters);
        }
    }

    public void logEventFromSE(String eventName, String buttonText) {
        this.loggerImpl.logEventFromSE(eventName, buttonText);
    }

    public void logEventImplicitly(String eventName, BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEventImplicitly(eventName, purchaseAmount, currency, parameters);
        }
    }

    public void logEventImplicitly(String eventName) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEventImplicitly(eventName, null, null);
        }
    }

    public void logEventImplicitly(String eventName, Double valueToSum, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEventImplicitly(eventName, valueToSum, parameters);
        }
    }

    public void logEventImplicitly(String eventName, Bundle parameters) {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEventImplicitly(eventName, null, parameters);
        }
    }

    public void logChangedSettingsEvent(Bundle parameters) {
        boolean previousAutoLog = (parameters.getInt("previous") & 2) != 0;
        String eventName = "fb_sdk_settings_changed";
        if (previousAutoLog || FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.loggerImpl.logEventImplicitly(eventName, null, parameters);
        }
    }

    public static AppEventsLogger.FlushBehavior getFlushBehavior() {
        return AppEventsLoggerImpl.getFlushBehavior();
    }

    public void flush() {
        this.loggerImpl.flush();
    }

    static Executor getAnalyticsExecutor() {
        return AppEventsLoggerImpl.getAnalyticsExecutor();
    }

    static String getPushNotificationsRegistrationId() {
        return AppEventsLoggerImpl.getPushNotificationsRegistrationId();
    }

    public static void setUserData(Bundle userData) {
        UserDataStore.setUserDataAndHash(userData);
    }

    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public static void setInternalUserData(Map<String, String> ud) {
        UserDataStore.setInternalUd(ud);
    }
}

