/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LoggingManager;
import com.facebook.internal.logging.monitor.MetricsUtil;
import com.facebook.internal.logging.monitor.MonitorLog;
import com.facebook.internal.logging.monitor.MonitorLoggingManager;
import com.facebook.internal.logging.monitor.MonitorLoggingQueue;
import com.facebook.internal.logging.monitor.MonitorLoggingStore;
import com.facebook.internal.logging.monitor.PerformanceEventName;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Monitor {
    private static final Random random = new Random();
    private static Integer defaultSamplingRate = 1000;
    private static boolean isEnabled;
    private static final LoggingManager monitorLoggingManager;
    private static final MetricsUtil metricsUtil;
    private static final Map<String, Integer> samplingRatesMap;
    private static final AtomicLong UNIQUE_EXTRA_ID;

    private Monitor() {
    }

    protected static void enable() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            if (isEnabled) {
                return;
            }
            isEnabled = true;
            Monitor.loadSamplingRatesMapAsync();
            monitorLoggingManager.flushLoggingStore();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    static void loadSamplingRatesMapAsync() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        JSONObject samplingRates = Monitor.fetchSamplingRate();
                        if (samplingRates != null) {
                            Monitor.updateSamplingRateMap(samplingRates);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    static JSONObject fetchSamplingRate() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return null;
        }
        try {
            Bundle monitorConfigParams = new Bundle();
            monitorConfigParams.putString("fields", "monitoring_config");
            GraphRequest request = GraphRequest.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
            request.setSkipClientToken(true);
            request.setParameters(monitorConfigParams);
            return request.executeAndWait().getJSONObject();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return null;
        }
    }

    static void updateSamplingRateMap(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            try {
                JSONObject fetchedSamplingRates;
                JSONArray samplingRates = fetchedSamplingRates.getJSONObject("monitoring_config").getJSONArray("sample_rates");
                for (int i = 0; i < samplingRates.length(); ++i) {
                    JSONObject keyValuePair = samplingRates.getJSONObject(i);
                    String eventName = keyValuePair.getString("key");
                    int samplingRate = keyValuePair.getInt("value");
                    if ("default".equals(eventName)) {
                        defaultSamplingRate = samplingRate;
                        continue;
                    }
                    samplingRatesMap.put(eventName, samplingRate);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void startMeasurePerfFor(PerformanceEventName performanceEventName, long l) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            PerformanceEventName eventName;
            if (isEnabled && Monitor.isSampled(eventName.toString())) {
                void extraId;
                metricsUtil.startMeasureFor(eventName, (long)extraId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    public static void startMeasurePerfFor(PerformanceEventName performanceEventName) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            PerformanceEventName eventName;
            long metricsCurrentThreadId = Monitor.getCurrentThreadID();
            Monitor.startMeasurePerfFor(eventName, metricsCurrentThreadId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void stopMeasurePerfFor(PerformanceEventName performanceEventName, long l) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            void extraId;
            PerformanceEventName eventName;
            MonitorLog monitorLog = metricsUtil.stopMeasureFor(eventName, (long)extraId);
            if (monitorLog.isValid()) {
                Monitor.addLog(monitorLog);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    public static void stopMeasurePerfFor(PerformanceEventName performanceEventName) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            PerformanceEventName eventName;
            long metricsCurrentThreadId = Monitor.getCurrentThreadID();
            Monitor.stopMeasurePerfFor(eventName, metricsCurrentThreadId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    public static void cancelMeasurePerfFor(PerformanceEventName performanceEventName) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            PerformanceEventName eventName;
            long metricsCurrentThreadId = Monitor.getCurrentThreadID();
            metricsUtil.removeTempMetricsDataFor(eventName, metricsCurrentThreadId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void cancelMeasurePerfFor(PerformanceEventName performanceEventName, long l) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            void extraId;
            PerformanceEventName eventName;
            metricsUtil.removeTempMetricsDataFor(eventName, (long)extraId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    public static long generateExtraId() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return 0L;
        }
        try {
            return UNIQUE_EXTRA_ID.incrementAndGet();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return 0L;
        }
    }

    private static long getCurrentThreadID() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return 0L;
        }
        try {
            return Thread.currentThread().getId();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return 0L;
        }
    }

    @VisibleForTesting
    static void addLog(ExternalLog externalLog) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return;
        }
        try {
            if (isEnabled) {
                ExternalLog log;
                monitorLoggingManager.addLog(log);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return;
        }
    }

    public static boolean isEnabled() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return false;
        }
        try {
            return isEnabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return false;
        }
    }

    static boolean isSampled(String string) {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return false;
        }
        try {
            String eventName;
            if (Utility.isNullOrEmpty(eventName)) {
                return false;
            }
            int samplingRate = defaultSamplingRate;
            if (samplingRatesMap.containsKey(eventName)) {
                samplingRate = samplingRatesMap.get(eventName);
            }
            return samplingRate > 0 && random.nextInt(samplingRate) == 0;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return false;
        }
    }

    static Integer getDefaultSamplingRate() {
        if (CrashShieldHandler.isObjectCrashing(Monitor.class)) {
            return null;
        }
        try {
            return defaultSamplingRate;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Monitor.class);
            return null;
        }
    }

    static {
        monitorLoggingManager = MonitorLoggingManager.getInstance(MonitorLoggingQueue.getInstance(), MonitorLoggingStore.getInstance());
        metricsUtil = MetricsUtil.getInstance();
        samplingRatesMap = new HashMap<String, Integer>();
        UNIQUE_EXTRA_ID = new AtomicLong(0L);
    }
}

