/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.os.Bundle;
import com.facebook.GraphRequest;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.eventdeactivation.EventDeactivationManager;
import com.facebook.appevents.internal.AppEventsLoggerUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SessionEventsState {
    private static final String TAG = SessionEventsState.class.getSimpleName();
    private List<AppEvent> accumulatedEvents = new ArrayList<AppEvent>();
    private List<AppEvent> inFlightEvents = new ArrayList<AppEvent>();
    private int numSkippedEventsDueToFullBuffer;
    private AttributionIdentifiers attributionIdentifiers;
    private String anonymousAppDeviceGUID;
    private final int MAX_ACCUMULATED_LOG_EVENTS = 1000;

    public SessionEventsState(AttributionIdentifiers identifiers, String anonymousGUID) {
        this.attributionIdentifiers = identifiers;
        this.anonymousAppDeviceGUID = anonymousGUID;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addEvent(AppEvent appEvent) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (this.accumulatedEvents.size() + this.inFlightEvents.size() >= this.getMAX_ACCUMULATED_LOG_EVENTS()) {
                ++this.numSkippedEventsDueToFullBuffer;
            } else {
                void event;
                this.accumulatedEvents.add((AppEvent)event);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    protected int getMAX_ACCUMULATED_LOG_EVENTS() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return 0;
        }
        try {
            return 1000;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return 0;
        }
    }

    public synchronized int getAccumulatedEventCount() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return 0;
        }
        try {
            return this.accumulatedEvents.size();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void clearInFlightAndStats(boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void moveToAccumulated;
            if (moveToAccumulated != false) {
                this.accumulatedEvents.addAll(this.inFlightEvents);
            }
            this.inFlightEvents.clear();
            this.numSkippedEventsDueToFullBuffer = 0;
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int populateRequest(GraphRequest graphRequest, Context context, boolean bl, boolean bl2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return 0;
        }
        try {
            void limitEventUsage;
            void applicationContext;
            void request;
            JSONArray jsonArray;
            int numSkipped;
            SessionEventsState sessionEventsState = this;
            synchronized (sessionEventsState) {
                numSkipped = this.numSkippedEventsDueToFullBuffer;
                EventDeactivationManager.processEvents(this.accumulatedEvents);
                this.inFlightEvents.addAll(this.accumulatedEvents);
                this.accumulatedEvents.clear();
                jsonArray = new JSONArray();
                for (AppEvent event : this.inFlightEvents) {
                    if (event.isChecksumValid()) {
                        void includeImplicitEvents;
                        if (includeImplicitEvents == false && event.getIsImplicit()) continue;
                        jsonArray.put((Object)event.getJSONObject());
                        continue;
                    }
                    Utility.logd(TAG, "Event with invalid checksum: " + event.toString());
                }
                if (jsonArray.length() == 0) {
                    return 0;
                }
            }
            this.populateRequest((GraphRequest)request, (Context)applicationContext, numSkipped, jsonArray, (boolean)limitEventUsage);
            return jsonArray.length();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return 0;
        }
    }

    public synchronized List<AppEvent> getEventsToPersist() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            List<AppEvent> result = this.accumulatedEvents;
            this.accumulatedEvents = new ArrayList<AppEvent>();
            return result;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void accumulatePersistedEvents(List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void events;
            this.accumulatedEvents.addAll((Collection<AppEvent>)events);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateRequest(GraphRequest graphRequest, Context context, int n, JSONArray jSONArray, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void events;
            String jsonString;
            void request;
            JSONObject publishParams = null;
            try {
                void applicationContext;
                void limitEventUsage;
                publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.CUSTOM_APP_EVENTS, this.attributionIdentifiers, this.anonymousAppDeviceGUID, (boolean)limitEventUsage, (Context)applicationContext);
                if (this.numSkippedEventsDueToFullBuffer > 0) {
                    void numSkipped;
                    publishParams.put("num_skipped_events", (int)numSkipped);
                }
            }
            catch (JSONException e) {
                publishParams = new JSONObject();
            }
            request.setGraphObject(publishParams);
            Bundle requestParameters = request.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            if ((jsonString = events.toString()) != null) {
                requestParameters.putString("custom_events", jsonString);
                request.setTag(jsonString);
            }
            request.setParameters(requestParameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }
}

