/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.core.internal.logging.dumpsys;

import android.annotation.SuppressLint;
import android.util.DisplayMetrics;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"NewApi", "StringFormatUse", "DefaultLocale", "BadMethodUse-java.lang.String.length"})
final class WebViewDumpHelper {
    public static final String GET_WEBVIEW_HTML_JS_SCRIPT = "(function() {  try {    const leftOf = %d;    const topOf = %d;    const density = %f;    const elements = Array.from(document.querySelectorAll('body, body *'));    for (const el of elements) {      const rect = el.getBoundingClientRect();      const left = Math.round(leftOf + rect.left * density);      const top = Math.round(topOf + rect.top * density);      const width = Math.round(rect.width * density);      const height = Math.round(rect.height * density);      el.setAttribute('data-rect', `${left},${top},${width},${height}`);      const style = window.getComputedStyle(el);      const hidden = style.display === 'none' || style.visibility !== 'visible' || el.getAttribute('hidden') === 'true';      const disabled = el.disabled || el.getAttribute('aria-disabled') === 'true';      const focused = el === document.activeElement;      if (hidden || disabled || focused) {        el.setAttribute('data-flag', `${hidden ? 'H' : ''}${disabled ? 'D' : ''}${focused ? 'F' : ''}`);      } else {        el.removeAttribute('data-flag');      }    }    document.activeElement.setAttribute('focused', 'true');    const doc = document.cloneNode(true);    for (const el of Array.from(doc.querySelectorAll('script, link'))) {      el.remove();    }    for (const el of Array.from(doc.querySelectorAll('*'))) {      el.removeAttribute('class');    }    return doc.getElementsByTagName('body')[0].outerHTML.trim();  } catch (e) {    return 'Failed: ' + e;  }})();";
    private final Set<WebViewData> mWebViews = new HashSet<WebViewData>();
    private final Map<String, String> mWebViewHTMLs = new HashMap<String, String>();

    WebViewDumpHelper() {
    }

    public void handle(WebView view) {
        final WebViewData data = new WebViewData(view);
        this.mWebViews.add(data);
        DisplayMetrics dm = view.getResources().getDisplayMetrics();
        String scriptWithOffset = String.format(GET_WEBVIEW_HTML_JS_SCRIPT, data.left, data.top, Float.valueOf(dm.scaledDensity));
        view.evaluateJavascript(scriptWithOffset, (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String html) {
                WebViewDumpHelper.this.mWebViewHTMLs.put(data.key, html);
            }
        });
    }

    public void dump(PrintWriter writer) {
        try {
            for (WebViewData data : this.mWebViews) {
                String html = this.mWebViewHTMLs.get(data.key);
                if (html == null) continue;
                writer.print("WebView HTML for ");
                writer.print(data);
                writer.println(":");
                writer.println(WebViewDumpHelper.fixHtmlString(data, html));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWebViews.clear();
        this.mWebViewHTMLs.clear();
    }

    private static String fixHtmlString(WebViewData data, String html) {
        html = html.replace("\\u003C", "<");
        html = html.replace("\\n", "");
        html = html.replace("\\\"", "\"");
        return String.format("<html id=\"%s\" data-rect=\"%d,%d,%d,%d\">%s</html>", data.key, data.left, data.top, data.width, data.height, html.substring(1, html.length() - 1));
    }

    private static final class WebViewData {
        private static final int[] mLocation = new int[2];
        public final String key;
        public final int left;
        public final int top;
        public final int width;
        public final int height;

        public WebViewData(WebView webView) {
            this.key = String.format("%s{%s}", webView.getClass().getName(), Integer.toHexString(webView.hashCode()));
            webView.getLocationOnScreen(mLocation);
            this.left = mLocation[0];
            this.top = mLocation[1];
            this.width = webView.getWidth();
            this.height = webView.getHeight();
        }
    }
}

