/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.suggestedevents.FeatureExtractor;
import com.facebook.appevents.suggestedevents.PredictionHistoryManager;
import com.facebook.appevents.suggestedevents.SuggestedEventViewHierarchy;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ViewOnClickListener
implements View.OnClickListener {
    private static final String TAG = ViewOnClickListener.class.getCanonicalName();
    private static final String API_ENDPOINT = "%s/suggested_events";
    public static final String OTHER_EVENT = "other";
    @Nullable
    private View.OnClickListener baseListener;
    private static final Set<Integer> viewsAttachedListener = new HashSet<Integer>();
    private WeakReference<View> rootViewWeakReference;
    private WeakReference<View> hostViewWeakReference;
    private String activityName;

    /*
     * WARNING - void declaration
     */
    static void attachListener(View view, View view2, String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return;
        }
        try {
            View hostView;
            int key = hostView.hashCode();
            if (!viewsAttachedListener.contains(key)) {
                void activityName;
                void rootView;
                ViewHierarchy.setOnClickListener(hostView, new ViewOnClickListener(hostView, (View)rootView, (String)activityName));
                viewsAttachedListener.add(key);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return;
        }
    }

    private ViewOnClickListener(View hostView, View rootView, String activityName) {
        this.baseListener = ViewHierarchy.getExistingOnClickListener(hostView);
        this.hostViewWeakReference = new WeakReference<View>(hostView);
        this.rootViewWeakReference = new WeakReference<View>(rootView);
        this.activityName = activityName.toLowerCase().replace("activity", "");
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (this.baseListener != null) {
                void view2;
                this.baseListener.onClick((View)view2);
            }
            this.process();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void process() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            View rootView = (View)this.rootViewWeakReference.get();
            View hostView = (View)this.hostViewWeakReference.get();
            if (rootView == null || hostView == null) {
                return;
            }
            try {
                String buttonText = SuggestedEventViewHierarchy.getTextOfViewRecursively(hostView);
                String pathID = PredictionHistoryManager.getPathID(hostView, buttonText);
                if (pathID == null) {
                    return;
                }
                if (ViewOnClickListener.queryHistoryAndProcess(pathID, buttonText)) {
                    return;
                }
                JSONObject data = new JSONObject();
                data.put("view", (Object)SuggestedEventViewHierarchy.getDictionaryOfView(rootView, hostView));
                data.put("screenname", (Object)this.activityName);
                this.predictAndProcess(pathID, buttonText, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean queryHistoryAndProcess(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return false;
        }
        try {
            String pathID;
            final String queriedEvent = PredictionHistoryManager.queryEvent(pathID);
            if (queriedEvent == null) {
                return false;
            }
            if (!queriedEvent.equals(OTHER_EVENT)) {
                void buttonText;
                Utility.runOnNonUiThread(new Runnable((String)buttonText){
                    final /* synthetic */ String val$buttonText;
                    {
                        this.val$buttonText = string2;
                    }

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            ViewOnClickListener.access$000(queriedEvent, this.val$buttonText, new float[0]);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void predictAndProcess(String string, String string2, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void pathID;
            void buttonText;
            void viewData;
            Utility.runOnNonUiThread(new Runnable((JSONObject)viewData, (String)buttonText, (String)pathID){
                final /* synthetic */ JSONObject val$viewData;
                final /* synthetic */ String val$buttonText;
                final /* synthetic */ String val$pathID;
                {
                    this.val$viewData = jSONObject;
                    this.val$buttonText = string;
                    this.val$pathID = string2;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        try {
                            String appName = Utility.getAppName(FacebookSdk.getApplicationContext()).toLowerCase();
                            float[] dense = FeatureExtractor.getDenseFeatures(this.val$viewData, appName);
                            String textFeature = FeatureExtractor.getTextFeature(this.val$buttonText, ViewOnClickListener.access$100(ViewOnClickListener.this), appName);
                            if (dense == null) {
                                return;
                            }
                            String[] predictedEvents = ModelManager.predict(ModelManager.Task.MTML_APP_EVENT_PREDICTION, new float[][]{dense}, new String[]{textFeature});
                            if (predictedEvents == null) {
                                return;
                            }
                            String predictedEvent = predictedEvents[0];
                            PredictionHistoryManager.addPrediction(this.val$pathID, predictedEvent);
                            if (!predictedEvent.equals(ViewOnClickListener.OTHER_EVENT)) {
                                ViewOnClickListener.access$000(predictedEvent, this.val$buttonText, dense);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void processPredictedResult(String string, String string2, float[] fArray) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return;
        }
        try {
            void buttonText;
            String predictedEvent;
            if (SuggestedEventsManager.isProductionEvents(predictedEvent)) {
                InternalAppEventsLogger logger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());
                logger.logEventFromSE(predictedEvent, (String)buttonText);
            } else if (SuggestedEventsManager.isEligibleEvents(predictedEvent)) {
                void dense;
                ViewOnClickListener.sendPredictedResult(predictedEvent, (String)buttonText, (float[])dense);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void sendPredictedResult(String string, String string2, float[] fArray) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return;
        }
        try {
            Bundle publishParams = new Bundle();
            try {
                void buttonText;
                void dense;
                String eventToPost;
                publishParams.putString("event_name", eventToPost);
                JSONObject metadata = new JSONObject();
                StringBuilder denseSB = new StringBuilder();
                for (void f : dense) {
                    denseSB.append((float)f).append(",");
                }
                metadata.put("dense", (Object)denseSB.toString());
                metadata.put("button_text", (Object)buttonText);
                publishParams.putString("metadata", metadata.toString());
                GraphRequest postRequest = GraphRequest.newPostRequest(null, String.format(Locale.US, API_ENDPOINT, FacebookSdk.getApplicationId()), null, null);
                postRequest.setParameters(publishParams);
                postRequest.executeAndWait();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(String string, String string2, float[] fArray) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return;
        }
        try {
            void x2;
            void x1;
            String x0;
            ViewOnClickListener.processPredictedResult(x0, (String)x1, (float[])x2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return;
        }
    }

    static /* synthetic */ String access$100(ViewOnClickListener viewOnClickListener) {
        if (CrashShieldHandler.isObjectCrashing(ViewOnClickListener.class)) {
            return null;
        }
        try {
            ViewOnClickListener x0;
            return x0.activityName;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewOnClickListener.class);
            return null;
        }
    }
}

