/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ondeviceprocessing;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.ondeviceprocessing.RemoteServiceParametersHelper;
import com.facebook.internal.FacebookSignatureValidator;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.ppml.receiver.IReceiverService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteServiceWrapper {
    private static final String TAG = RemoteServiceWrapper.class.getSimpleName();
    static final String RECEIVER_SERVICE_ACTION = "ReceiverService";
    static final String RECEIVER_SERVICE_PACKAGE = "com.facebook.katana";
    static final String RECEIVER_SERVICE_PACKAGE_WAKIZASHI = "com.facebook.wakizashi";
    private static Boolean isServiceAvailable;

    public static ServiceResult sendInstallEvent(String string) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceWrapper.class)) {
            return null;
        }
        try {
            String applicationId;
            return RemoteServiceWrapper.sendEvents(EventType.MOBILE_APP_INSTALL, applicationId, new LinkedList<AppEvent>());
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceWrapper.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ServiceResult sendCustomEvents(String string, List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceWrapper.class)) {
            return null;
        }
        try {
            void appEvents;
            String applicationId;
            return RemoteServiceWrapper.sendEvents(EventType.CUSTOM_APP_EVENTS, applicationId, (List<AppEvent>)appEvents);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceWrapper.class);
            return null;
        }
    }

    public static boolean isServiceAvailable() {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceWrapper.class)) {
            return false;
        }
        try {
            if (isServiceAvailable == null) {
                Context context = FacebookSdk.getApplicationContext();
                isServiceAvailable = RemoteServiceWrapper.getVerifiedServiceIntent(context) != null;
            }
            return isServiceAvailable;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceWrapper.class);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static ServiceResult sendEvents(EventType eventType, String string, List<AppEvent> list) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceWrapper.class)) {
            return null;
        }
        try {
            ServiceResult serviceResult = ServiceResult.SERVICE_NOT_AVAILABLE;
            AppEventUtility.assertIsNotMainThread();
            Context context = FacebookSdk.getApplicationContext();
            Intent verifiedIntent = RemoteServiceWrapper.getVerifiedServiceIntent(context);
            if (verifiedIntent != null) {
                RemoteServiceConnection connection = new RemoteServiceConnection();
                if (context.bindService(verifiedIntent, (ServiceConnection)connection, 1)) {
                    try {
                        IBinder binder = connection.getBinder();
                        if (binder != null) {
                            void appEvents;
                            void applicationId;
                            EventType eventType2;
                            IReceiverService service = IReceiverService.Stub.asInterface(binder);
                            Bundle eventBundle = RemoteServiceParametersHelper.buildEventsBundle(eventType2, (String)applicationId, (List<AppEvent>)appEvents);
                            if (eventBundle != null) {
                                service.sendEvents(eventBundle);
                                Utility.logd(TAG, "Successfully sent events to the remote service: " + eventBundle);
                            }
                            serviceResult = ServiceResult.OPERATION_SUCCESS;
                        }
                        serviceResult = ServiceResult.SERVICE_NOT_AVAILABLE;
                    }
                    catch (RemoteException | InterruptedException exception) {
                        serviceResult = ServiceResult.SERVICE_ERROR;
                        Utility.logd(TAG, (Exception)exception);
                    }
                    finally {
                        context.unbindService((ServiceConnection)connection);
                        Utility.logd(TAG, "Unbound from the remote service");
                    }
                } else {
                    serviceResult = ServiceResult.SERVICE_ERROR;
                }
            }
            return serviceResult;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceWrapper.class);
            return null;
        }
    }

    @Nullable
    private static Intent getVerifiedServiceIntent(Context context) {
        if (CrashShieldHandler.isObjectCrashing(RemoteServiceWrapper.class)) {
            return null;
        }
        try {
            Context context2;
            PackageManager packageManager = context2.getPackageManager();
            if (packageManager != null) {
                Intent serviceIntent = new Intent(RECEIVER_SERVICE_ACTION);
                serviceIntent.setPackage(RECEIVER_SERVICE_PACKAGE);
                ResolveInfo serviceInfo = packageManager.resolveService(serviceIntent, 0);
                if (serviceInfo != null && FacebookSignatureValidator.validateSignature(context2, RECEIVER_SERVICE_PACKAGE)) {
                    return serviceIntent;
                }
                Intent wakizashiServiceIntent = new Intent(RECEIVER_SERVICE_ACTION);
                wakizashiServiceIntent.setPackage(RECEIVER_SERVICE_PACKAGE_WAKIZASHI);
                ResolveInfo wakizashiServiceInfo = packageManager.resolveService(wakizashiServiceIntent, 0);
                if (wakizashiServiceInfo != null && FacebookSignatureValidator.validateSignature(context2, RECEIVER_SERVICE_PACKAGE_WAKIZASHI)) {
                    return wakizashiServiceIntent;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, RemoteServiceWrapper.class);
            return null;
        }
    }

    static final class RemoteServiceConnection
    implements ServiceConnection {
        private final CountDownLatch latch = new CountDownLatch(1);
        @Nullable
        private IBinder binder;

        RemoteServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder serviceBinder) {
            this.binder = serviceBinder;
            this.latch.countDown();
        }

        public void onNullBinding(ComponentName name) {
            this.latch.countDown();
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        @Nullable
        public IBinder getBinder() throws InterruptedException {
            this.latch.await(5L, TimeUnit.SECONDS);
            return this.binder;
        }
    }

    static enum EventType {
        MOBILE_APP_INSTALL("MOBILE_APP_INSTALL"),
        CUSTOM_APP_EVENTS("CUSTOM_APP_EVENTS");

        private String eventType;

        private EventType(String eventType) {
            this.eventType = eventType;
        }

        public String toString() {
            return this.eventType;
        }
    }

    static enum ServiceResult {
        OPERATION_SUCCESS,
        SERVICE_NOT_AVAILABLE,
        SERVICE_ERROR;

    }
}

