/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LoggingManager;
import com.facebook.internal.logging.monitor.MetricsUtil;
import com.facebook.internal.logging.monitor.MonitorLog;
import com.facebook.internal.logging.monitor.MonitorLoggingManager;
import com.facebook.internal.logging.monitor.MonitorLoggingQueue;
import com.facebook.internal.logging.monitor.MonitorLoggingStore;
import com.facebook.internal.logging.monitor.PerformanceEventName;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@AutoHandleExceptions
public class Monitor {
    private static final Random random = new Random();
    private static Integer defaultSamplingRate = 1000;
    private static boolean isEnabled;
    private static final LoggingManager monitorLoggingManager;
    private static final MetricsUtil metricsUtil;
    private static final Map<String, Integer> samplingRatesMap;
    private static final AtomicLong UNIQUE_EXTRA_ID;

    private Monitor() {
    }

    protected static void enable() {
        if (isEnabled) {
            return;
        }
        isEnabled = true;
        Monitor.loadSamplingRatesMapAsync();
        monitorLoggingManager.flushLoggingStore();
    }

    static void loadSamplingRatesMapAsync() {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JSONObject samplingRates = Monitor.fetchSamplingRate();
                if (samplingRates != null) {
                    Monitor.updateSamplingRateMap(samplingRates);
                }
            }
        });
    }

    static JSONObject fetchSamplingRate() {
        Bundle monitorConfigParams = new Bundle();
        monitorConfigParams.putString("fields", "monitoring_config");
        GraphRequest request = GraphRequest.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
        request.setSkipClientToken(true);
        request.setParameters(monitorConfigParams);
        return request.executeAndWait().getJSONObject();
    }

    static void updateSamplingRateMap(JSONObject fetchedSamplingRates) {
        try {
            JSONArray samplingRates = fetchedSamplingRates.getJSONObject("monitoring_config").getJSONArray("sample_rates");
            for (int i = 0; i < samplingRates.length(); ++i) {
                JSONObject keyValuePair = samplingRates.getJSONObject(i);
                String eventName = keyValuePair.getString("key");
                int samplingRate = keyValuePair.getInt("value");
                if ("default".equals(eventName)) {
                    defaultSamplingRate = samplingRate;
                    continue;
                }
                samplingRatesMap.put(eventName, samplingRate);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void startMeasurePerfFor(PerformanceEventName eventName, long extraId) {
        if (isEnabled && Monitor.isSampled(eventName.toString())) {
            metricsUtil.startMeasureFor(eventName, extraId);
        }
    }

    public static void startMeasurePerfFor(PerformanceEventName eventName) {
        long metricsCurrentThreadId = Monitor.getCurrentThreadID();
        Monitor.startMeasurePerfFor(eventName, metricsCurrentThreadId);
    }

    public static void stopMeasurePerfFor(PerformanceEventName eventName, long extraId) {
        MonitorLog monitorLog = metricsUtil.stopMeasureFor(eventName, extraId);
        if (monitorLog.isValid()) {
            Monitor.addLog(monitorLog);
        }
    }

    public static void stopMeasurePerfFor(PerformanceEventName eventName) {
        long metricsCurrentThreadId = Monitor.getCurrentThreadID();
        Monitor.stopMeasurePerfFor(eventName, metricsCurrentThreadId);
    }

    public static void cancelMeasurePerfFor(PerformanceEventName eventName) {
        long metricsCurrentThreadId = Monitor.getCurrentThreadID();
        metricsUtil.removeTempMetricsDataFor(eventName, metricsCurrentThreadId);
    }

    public static void cancelMeasurePerfFor(PerformanceEventName eventName, long extraId) {
        metricsUtil.removeTempMetricsDataFor(eventName, extraId);
    }

    public static long generateExtraId() {
        return UNIQUE_EXTRA_ID.incrementAndGet();
    }

    private static long getCurrentThreadID() {
        return Thread.currentThread().getId();
    }

    @VisibleForTesting
    static void addLog(ExternalLog log) {
        if (isEnabled) {
            monitorLoggingManager.addLog(log);
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static boolean isSampled(String eventName) {
        if (Utility.isNullOrEmpty(eventName)) {
            return false;
        }
        int samplingRate = defaultSamplingRate;
        if (samplingRatesMap.containsKey(eventName)) {
            samplingRate = samplingRatesMap.get(eventName);
        }
        return samplingRate > 0 && random.nextInt(samplingRate) == 0;
    }

    static Integer getDefaultSamplingRate() {
        return defaultSamplingRate;
    }

    static {
        monitorLoggingManager = MonitorLoggingManager.getInstance(MonitorLoggingQueue.getInstance(), MonitorLoggingStore.getInstance());
        metricsUtil = MetricsUtil.getInstance();
        samplingRatesMap = new HashMap<String, Integer>();
        UNIQUE_EXTRA_ID = new AtomicLong(0L);
    }
}

