/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.internal.logging.LogCategory;
import com.facebook.internal.logging.LogEvent;
import com.facebook.internal.logging.monitor.MonitorLog;
import com.facebook.internal.logging.monitor.PerformanceEventName;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@AutoHandleExceptions
public class MetricsUtil {
    private static MetricsUtil metricsUtil;
    private static final String CLASS_TAG;
    private final Map<MetricsKey, TempMetrics> metricsDataMap = new HashMap<MetricsKey, TempMetrics>();
    protected static final int INVALID_TIME = -1;

    private MetricsUtil() {
    }

    public static synchronized MetricsUtil getInstance() {
        if (metricsUtil == null) {
            metricsUtil = new MetricsUtil();
        }
        return metricsUtil;
    }

    void startMeasureFor(PerformanceEventName eventName, long extraId) {
        MetricsKey keyOfMetricsData = new MetricsKey(eventName, extraId);
        long timeStart = SystemClock.elapsedRealtime();
        TempMetrics tempMetrics = new TempMetrics(timeStart);
        this.metricsDataMap.put(keyOfMetricsData, tempMetrics);
    }

    MonitorLog stopMeasureFor(PerformanceEventName eventName, long extraId) {
        long timeEnd = SystemClock.elapsedRealtime();
        MetricsKey keyOfMetricsData = new MetricsKey(eventName, extraId);
        LogEvent logEvent = new LogEvent(eventName.toString(), LogCategory.PERFORMANCE);
        MonitorLog monitorLog = new MonitorLog.LogBuilder(logEvent).timeSpent(-1).build();
        if (!this.metricsDataMap.containsKey(keyOfMetricsData)) {
            StringBuilder warningMessage = new StringBuilder();
            warningMessage.append("Can't measure for ");
            warningMessage.append((Object)eventName);
            warningMessage.append(", startMeasureFor hasn't been called before.");
            Utility.logd(CLASS_TAG, warningMessage.toString());
            return monitorLog;
        }
        TempMetrics tempMetrics = this.metricsDataMap.get(keyOfMetricsData);
        if (tempMetrics != null) {
            long timeStart = tempMetrics.timeStart;
            int deltaTime = (int)(timeEnd - timeStart);
            monitorLog = new MonitorLog.LogBuilder(logEvent).timeSpent(deltaTime).build();
        }
        this.metricsDataMap.remove(keyOfMetricsData);
        return monitorLog;
    }

    void removeTempMetricsDataFor(PerformanceEventName eventName, long extraId) {
        MetricsKey keyOfMetricsData = new MetricsKey(eventName, extraId);
        this.metricsDataMap.remove(keyOfMetricsData);
    }

    static {
        CLASS_TAG = MetricsUtil.class.getCanonicalName();
    }

    private static class TempMetrics {
        private long timeStart;

        TempMetrics(long timeStart) {
            this.timeStart = timeStart;
        }
    }

    private static class MetricsKey {
        private PerformanceEventName performanceEventName;
        private long extraId;

        MetricsKey(PerformanceEventName performanceEventName, long extraId) {
            this.performanceEventName = performanceEventName;
            this.extraId = extraId;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsKey that = (MetricsKey)o;
            return this.extraId == that.extraId && this.performanceEventName == that.performanceEventName;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 31 * hashCode + this.performanceEventName.hashCode();
            hashCode = 31 * hashCode + (int)(this.extraId ^ this.extraId >>> 32);
            return hashCode;
        }
    }
}

