/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppGateKeepersManager;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FeatureManager {
    private static final String FEATURE_MANAGER_STORE = "com.facebook.internal.FEATURE_MANAGER";
    private static final Map<Feature, String[]> featureMapping = new HashMap<Feature, String[]>();

    public static void checkFeature(final Feature feature, final Callback callback) {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback(){

            @Override
            public void onCompleted() {
                callback.onCompleted(FeatureManager.isEnabled(feature));
            }
        });
    }

    public static boolean isEnabled(Feature feature) {
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        String version = FacebookSdk.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).getString(feature.toKey(), null);
        if (version != null && version.equals(FacebookSdk.getSdkVersion())) {
            return false;
        }
        Feature parent = feature.getParent();
        if (parent == feature) {
            return FeatureManager.getGKStatus(feature);
        }
        return FeatureManager.isEnabled(parent) && FeatureManager.getGKStatus(feature);
    }

    public static void disableFeature(Feature feature) {
        FacebookSdk.getApplicationContext().getSharedPreferences(FEATURE_MANAGER_STORE, 0).edit().putString(feature.toKey(), FacebookSdk.getSdkVersion()).apply();
    }

    public static Feature getFeature(String className) {
        FeatureManager.initializeFeatureMapping();
        for (Map.Entry<Feature, String[]> entry : featureMapping.entrySet()) {
            for (String v : entry.getValue()) {
                if (!className.startsWith(v)) continue;
                return entry.getKey();
            }
        }
        return Feature.Unknown;
    }

    private static synchronized void initializeFeatureMapping() {
        if (!featureMapping.isEmpty()) {
            return;
        }
        featureMapping.put(Feature.AAM, new String[]{"com.facebook.appevents.aam."});
        featureMapping.put(Feature.CodelessEvents, new String[]{"com.facebook.appevents.codeless."});
        featureMapping.put(Feature.ErrorReport, new String[]{"com.facebook.internal.instrument.errorreport."});
        featureMapping.put(Feature.PrivacyProtection, new String[]{"com.facebook.appevents.ml."});
        featureMapping.put(Feature.SuggestedEvents, new String[]{"com.facebook.appevents.suggestedevents."});
        featureMapping.put(Feature.RestrictiveDataFiltering, new String[]{"com.facebook.appevents.restrictivedatafilter.RestrictiveDataManager"});
        featureMapping.put(Feature.IntelligentIntegrity, new String[]{"com.facebook.appevents.integrity.IntegrityManager"});
        featureMapping.put(Feature.EventDeactivation, new String[]{"com.facebook.appevents.eventdeactivation."});
        featureMapping.put(Feature.Monitoring, new String[]{"com.facebook.internal.logging.monitor"});
    }

    private static boolean getGKStatus(Feature feature) {
        boolean defaultStatus = FeatureManager.defaultStatus(feature);
        return FetchedAppGateKeepersManager.getGateKeeperForKey(feature.toKey(), FacebookSdk.getApplicationId(), defaultStatus);
    }

    private static boolean defaultStatus(Feature feature) {
        switch (feature) {
            case RestrictiveDataFiltering: 
            case Instrument: 
            case CrashReport: 
            case CrashShield: 
            case ThreadCheck: 
            case ErrorReport: 
            case AAM: 
            case PrivacyProtection: 
            case SuggestedEvents: 
            case IntelligentIntegrity: 
            case ModelRequest: 
            case EventDeactivation: 
            case ChromeCustomTabsPrefetching: 
            case Monitoring: 
            case IgnoreAppSwitchToLoggedOut: {
                return false;
            }
        }
        return true;
    }

    public static interface Callback {
        public void onCompleted(boolean var1);
    }

    public static enum Feature {
        Unknown(-1),
        Core(0),
        AppEvents(65536),
        CodelessEvents(65792),
        RestrictiveDataFiltering(66048),
        AAM(66304),
        PrivacyProtection(66560),
        SuggestedEvents(66561),
        IntelligentIntegrity(66562),
        ModelRequest(66563),
        EventDeactivation(66816),
        Instrument(131072),
        CrashReport(131328),
        CrashShield(131329),
        ThreadCheck(131330),
        ErrorReport(131584),
        Monitoring(196608),
        Login(0x1000000),
        ChromeCustomTabsPrefetching(0x1010000),
        IgnoreAppSwitchToLoggedOut(0x1020000),
        Share(0x2000000),
        Places(0x3000000);

        private final int code;

        private Feature(int code) {
            this.code = code;
        }

        public String toString() {
            String name = "unknown";
            switch (this) {
                case Core: {
                    name = "CoreKit";
                    break;
                }
                case AppEvents: {
                    name = "AppEvents";
                    break;
                }
                case CodelessEvents: {
                    name = "CodelessEvents";
                    break;
                }
                case RestrictiveDataFiltering: {
                    name = "RestrictiveDataFiltering";
                    break;
                }
                case Instrument: {
                    name = "Instrument";
                    break;
                }
                case CrashReport: {
                    name = "CrashReport";
                    break;
                }
                case CrashShield: {
                    name = "CrashShield";
                    break;
                }
                case ThreadCheck: {
                    name = "ThreadCheck";
                    break;
                }
                case ErrorReport: {
                    name = "ErrorReport";
                    break;
                }
                case AAM: {
                    name = "AAM";
                    break;
                }
                case PrivacyProtection: {
                    name = "PrivacyProtection";
                    break;
                }
                case SuggestedEvents: {
                    name = "SuggestedEvents";
                    break;
                }
                case IntelligentIntegrity: {
                    name = "IntelligentIntegrity";
                    break;
                }
                case ModelRequest: {
                    name = "ModelRequest";
                    break;
                }
                case EventDeactivation: {
                    name = "EventDeactivation";
                    break;
                }
                case Monitoring: {
                    name = "Monitoring";
                    break;
                }
                case Login: {
                    name = "LoginKit";
                    break;
                }
                case ChromeCustomTabsPrefetching: {
                    name = "ChromeCustomTabsPrefetching";
                    break;
                }
                case IgnoreAppSwitchToLoggedOut: {
                    name = "IgnoreAppSwitchToLoggedOut";
                    break;
                }
                case Share: {
                    name = "ShareKit";
                    break;
                }
                case Places: {
                    name = "PlacesKit";
                }
            }
            return name;
        }

        static Feature fromInt(int code) {
            for (Feature feature : Feature.values()) {
                if (feature.code != code) continue;
                return feature;
            }
            return Unknown;
        }

        String toKey() {
            return "FBSDKFeature" + this.toString();
        }

        public Feature getParent() {
            if ((this.code & 0xFF) > 0) {
                return Feature.fromInt(this.code & 0xFFFFFF00);
            }
            if ((this.code & 0xFF00) > 0) {
                return Feature.fromInt(this.code & 0xFFFF0000);
            }
            if ((this.code & 0xFF0000) > 0) {
                return Feature.fromInt(this.code & 0xFF000000);
            }
            return Feature.fromInt(0);
        }
    }
}

