/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;

@AutoHandleExceptions
public class BoltsMeasurementEventListener
extends BroadcastReceiver {
    private static BoltsMeasurementEventListener _instance;
    private static final String MEASUREMENT_EVENT_NOTIFICATION_NAME = "com.parse.bolts.measurement_event";
    private static final String MEASUREMENT_EVENT_NAME_KEY = "event_name";
    private static final String MEASUREMENT_EVENT_ARGS_KEY = "event_args";
    private static final String BOLTS_MEASUREMENT_EVENT_PREFIX = "bf_";
    private Context applicationContext;

    private BoltsMeasurementEventListener(Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    private void open() {
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)this.applicationContext);
        broadcastManager.registerReceiver((BroadcastReceiver)this, new IntentFilter(MEASUREMENT_EVENT_NOTIFICATION_NAME));
    }

    private void close() {
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)this.applicationContext);
        broadcastManager.unregisterReceiver((BroadcastReceiver)this);
    }

    public static BoltsMeasurementEventListener getInstance(Context context) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new BoltsMeasurementEventListener(context);
        _instance.open();
        return _instance;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void onReceive(Context context, Intent intent) {
        InternalAppEventsLogger logger = new InternalAppEventsLogger(context);
        String eventName = BOLTS_MEASUREMENT_EVENT_PREFIX + intent.getStringExtra(MEASUREMENT_EVENT_NAME_KEY);
        Bundle eventArgs = intent.getBundleExtra(MEASUREMENT_EVENT_ARGS_KEY);
        Bundle logData = new Bundle();
        for (String key : eventArgs.keySet()) {
            String safeKey = key.replaceAll("[^0-9a-zA-Z _-]", "-").replaceAll("^[ -]*", "").replaceAll("[ -]*$", "");
            logData.putString(safeKey, (String)eventArgs.get(key));
        }
        logger.logEvent(eventName, logData);
    }
}

