/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@AutoHandleExceptions
class SuggestedEventViewHierarchy {
    static final String TAG = SuggestedEventViewHierarchy.class.getCanonicalName();
    private static final List<Class<? extends View>> blacklistedViews = new ArrayList<Class>(Arrays.asList(Switch.class, Spinner.class, DatePicker.class, TimePicker.class, RadioGroup.class, RatingBar.class, EditText.class, AdapterView.class));

    SuggestedEventViewHierarchy() {
    }

    static JSONObject getDictionaryOfView(View view, View clickedView) {
        JSONObject json = new JSONObject();
        try {
            if (view == clickedView) {
                json.put("is_interacted", true);
            }
            SuggestedEventViewHierarchy.updateBasicInfo(view, json);
            JSONArray childViews = new JSONArray();
            List<View> children = ViewHierarchy.getChildrenOfView(view);
            for (int i = 0; i < children.size(); ++i) {
                View child = children.get(i);
                JSONObject childInfo = SuggestedEventViewHierarchy.getDictionaryOfView(child, clickedView);
                childViews.put((Object)childInfo);
            }
            json.put("childviews", (Object)childViews);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    static void updateBasicInfo(View view, JSONObject json) {
        try {
            String text = ViewHierarchy.getTextOfView(view);
            String hint = ViewHierarchy.getHintOfView(view);
            json.put("classname", (Object)view.getClass().getSimpleName());
            json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view));
            if (!text.isEmpty()) {
                json.put("text", (Object)text);
            }
            if (!hint.isEmpty()) {
                json.put("hint", (Object)hint);
            }
            if (view instanceof EditText) {
                json.put("inputtype", ((EditText)view).getInputType());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static List<View> getAllClickableViews(View view) {
        ArrayList<View> clickableViews = new ArrayList<View>();
        for (Class<? extends View> viewClass : blacklistedViews) {
            if (!viewClass.isInstance(view)) continue;
            return clickableViews;
        }
        if (view.isClickable()) {
            clickableViews.add(view);
        }
        List<View> children = ViewHierarchy.getChildrenOfView(view);
        for (View child : children) {
            clickableViews.addAll(SuggestedEventViewHierarchy.getAllClickableViews(child));
        }
        return clickableViews;
    }

    static String getTextOfViewRecursively(View hostView) {
        String text = ViewHierarchy.getTextOfView(hostView);
        if (!text.isEmpty()) {
            return text;
        }
        List<String> childrenText = SuggestedEventViewHierarchy.getTextOfChildren(hostView);
        return TextUtils.join((CharSequence)" ", childrenText);
    }

    private static List<String> getTextOfChildren(View view) {
        ArrayList<String> childrenText = new ArrayList<String>();
        List<View> childrenView = ViewHierarchy.getChildrenOfView(view);
        for (View childView : childrenView) {
            String childText = ViewHierarchy.getTextOfView(childView);
            if (!childText.isEmpty()) {
                childrenText.add(childText);
            }
            childrenText.addAll(SuggestedEventViewHierarchy.getTextOfChildren(childView));
        }
        return childrenText;
    }
}

