/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.content.SharedPreferences;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@AutoHandleExceptions
final class PredictionHistoryManager {
    private static final Map<String, String> clickedViewPaths = new HashMap<String, String>();
    private static final String SUGGESTED_EVENTS_HISTORY = "SUGGESTED_EVENTS_HISTORY";
    private static final String CLICKED_PATH_STORE = "com.facebook.internal.SUGGESTED_EVENTS_HISTORY";
    private static SharedPreferences shardPreferences;
    private static final AtomicBoolean initialized;

    PredictionHistoryManager() {
    }

    private static void initAndWait() {
        if (initialized.get()) {
            return;
        }
        shardPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(CLICKED_PATH_STORE, 0);
        clickedViewPaths.putAll(Utility.JsonStrToMap(shardPreferences.getString(SUGGESTED_EVENTS_HISTORY, "")));
        initialized.set(true);
    }

    static void addPrediction(String pathID, String predictedEvent) {
        if (!initialized.get()) {
            PredictionHistoryManager.initAndWait();
        }
        clickedViewPaths.put(pathID, predictedEvent);
        shardPreferences.edit().putString(SUGGESTED_EVENTS_HISTORY, Utility.mapToJsonStr(clickedViewPaths)).apply();
    }

    @Nullable
    static String getPathID(View view, String text) {
        JSONObject pathRoute = new JSONObject();
        try {
            pathRoute.put("text", (Object)text);
            JSONArray currentPath = new JSONArray();
            while (view != null) {
                currentPath.put((Object)view.getClass().getSimpleName());
                view = ViewHierarchy.getParentOfView(view);
            }
            pathRoute.put("classname", (Object)currentPath);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Utility.sha256hash(pathRoute.toString());
    }

    @Nullable
    static String queryEvent(String pathID) {
        return clickedViewPaths.containsKey(pathID) ? clickedViewPaths.get(pathID) : null;
    }

    static {
        initialized = new AtomicBoolean(false);
    }
}

