/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.io.File;
import java.nio.charset.Charset;

@AutoHandleExceptions
public class Utils {
    private static final String DIR_NAME = "facebook_ml/";

    static int[] vectorize(String texts, int maxLen) {
        int[] ret = new int[maxLen];
        String normalizedStr = Utils.normalizeString(texts);
        byte[] strBytes = normalizedStr.getBytes(Charset.forName("UTF-8"));
        for (int i = 0; i < maxLen; ++i) {
            ret[i] = i < strBytes.length ? strBytes[i] & 0xFF : 0;
        }
        return ret;
    }

    static String normalizeString(String str) {
        String trim = str.trim();
        Object[] strArray = trim.split("\\s+");
        String joinedString = TextUtils.join((CharSequence)" ", (Object[])strArray);
        return joinedString;
    }

    @Nullable
    public static File getMlDir() {
        File dir = new File(FacebookSdk.getApplicationContext().getFilesDir(), DIR_NAME);
        if (dir.exists() || dir.mkdirs()) {
            return dir;
        }
        return null;
    }
}

