/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.internal.HashUtils;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import com.facebook.internal.security.CertificateUtil;
import java.util.Locale;

@AutoHandleExceptions
class SessionLogger {
    private static final String PACKAGE_CHECKSUM = "PCKGCHKSUM";
    private static final String TAG = SessionLogger.class.getCanonicalName();
    private static final long[] INACTIVE_SECONDS_QUANTA = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};

    SessionLogger() {
    }

    static void logActivateApp(String activityName, SourceApplicationInfo sourceApplicationInfo, String appId, Context context) {
        String sourAppInfoStr = sourceApplicationInfo != null ? sourceApplicationInfo.toString() : "Unclassified";
        Bundle eventParams = new Bundle();
        eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
        eventParams.putString("fb_mobile_pckg_fp", SessionLogger.computePackageChecksum(context));
        eventParams.putString("fb_mobile_app_cert_hash", CertificateUtil.getCertificateHash(context));
        InternalAppEventsLogger logger = new InternalAppEventsLogger(activityName, appId, null);
        logger.logEvent("fb_mobile_activate_app", eventParams);
        if (InternalAppEventsLogger.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
            logger.flush();
        }
    }

    static void logDeactivateApp(String activityName, SessionInfo sessionInfo, String appId) {
        Long sessionLength;
        if (sessionInfo == null) {
            return;
        }
        Long interruptionDurationMillis = sessionInfo.getDiskRestoreTime() - sessionInfo.getSessionLastEventTime();
        if (interruptionDurationMillis < 0L) {
            interruptionDurationMillis = 0L;
            SessionLogger.logClockSkewEvent();
        }
        if ((sessionLength = Long.valueOf(sessionInfo.getSessionLength())) < 0L) {
            SessionLogger.logClockSkewEvent();
            sessionLength = 0L;
        }
        Bundle eventParams = new Bundle();
        eventParams.putInt("fb_mobile_app_interruptions", sessionInfo.getInterruptionCount());
        eventParams.putString("fb_mobile_time_between_sessions", String.format(Locale.ROOT, "session_quanta_%d", SessionLogger.getQuantaIndex(interruptionDurationMillis)));
        SourceApplicationInfo sourceApplicationInfo = sessionInfo.getSourceApplicationInfo();
        String sourAppInfoStr = sourceApplicationInfo != null ? sourceApplicationInfo.toString() : "Unclassified";
        eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
        eventParams.putLong("_logTime", sessionInfo.getSessionLastEventTime() / 1000L);
        new InternalAppEventsLogger(activityName, appId, null).logEvent("fb_mobile_deactivate_app", (double)sessionLength.longValue() / 1000.0, eventParams);
    }

    private static void logClockSkewEvent() {
        Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Clock skew detected");
    }

    private static int getQuantaIndex(long timeBetweenSessions) {
        int quantaIndex;
        for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
        }
        return quantaIndex;
    }

    @Nullable
    private static String computePackageChecksum(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            String packageVersion = pm.getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            String packageHashSharedPrefKey = "PCKGCHKSUM;" + packageVersion;
            SharedPreferences preferences = context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
            String packageHash = preferences.getString(packageHashSharedPrefKey, null);
            if (packageHash != null && packageHash.length() == 32) {
                return packageHash;
            }
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 0);
            packageHash = HashUtils.computeChecksum(ai.sourceDir);
            preferences.edit().putString(packageHashSharedPrefKey, packageHash).apply();
            return packageHash;
        }
        catch (Exception e) {
            return null;
        }
    }
}

