/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.content.Context;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.lang.ref.WeakReference;

@AutoHandleExceptions
public class RCTCodelessLoggingEventListener {
    private static final String TAG = RCTCodelessLoggingEventListener.class.getCanonicalName();

    public static AutoLoggingOnTouchListener getOnTouchListener(EventBinding mapping, View rootView, View hostView) {
        return new AutoLoggingOnTouchListener(mapping, rootView, hostView);
    }

    public static class AutoLoggingOnTouchListener
    implements View.OnTouchListener {
        private EventBinding mapping;
        private WeakReference<View> hostView;
        private WeakReference<View> rootView;
        @Nullable
        private View.OnTouchListener existingOnTouchListener;
        private boolean supportCodelessLogging = false;

        public AutoLoggingOnTouchListener(EventBinding mapping, View rootView, View hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingOnTouchListener = ViewHierarchy.getExistingOnTouchListener(hostView);
            this.mapping = mapping;
            this.hostView = new WeakReference<View>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            this.supportCodelessLogging = true;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 1) {
                this.logEvent();
            }
            return this.existingOnTouchListener != null && this.existingOnTouchListener.onTouch(view, motionEvent);
        }

        private void logEvent() {
            if (null == this.mapping) {
                return;
            }
            final String eventName = this.mapping.getEventName();
            Bundle parameters = CodelessMatcher.getParameters(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
            if (parameters.containsKey("_valueToSum")) {
                String value = parameters.getString("_valueToSum");
                parameters.putDouble("_valueToSum", AppEventUtility.normalizePrice(value));
            }
            parameters.putString("_is_fb_codeless", "1");
            final Bundle params = parameters;
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Context context = FacebookSdk.getApplicationContext();
                    AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
                    appEventsLogger.logEvent(eventName, params);
                }
            });
        }

        public boolean getSupportCodelessLogging() {
            return this.supportCodelessLogging;
        }
    }
}

