/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataMatcher;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@AutoHandleExceptions
final class MetadataViewObserver
implements ViewTreeObserver.OnGlobalFocusChangeListener {
    private static final String TAG = MetadataViewObserver.class.getCanonicalName();
    private static final int MAX_TEXT_LENGTH = 100;
    private static final Map<Integer, MetadataViewObserver> observers = new HashMap<Integer, MetadataViewObserver>();
    private final Set<String> processedText = new HashSet<String>();
    private final Handler uiThreadHandler;
    private WeakReference<Activity> activityWeakReference;
    private AtomicBoolean isTracking;

    private MetadataViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.isTracking = new AtomicBoolean(false);
    }

    @UiThread
    static void startTrackingActivity(Activity activity) {
        MetadataViewObserver observer;
        int key = activity.hashCode();
        if (!observers.containsKey(key)) {
            observer = new MetadataViewObserver(activity);
            observers.put(activity.hashCode(), observer);
        } else {
            observer = observers.get(key);
        }
        observer.startTracking();
    }

    @UiThread
    static void stopTrackingActivity(Activity activity) {
        int key = activity.hashCode();
        if (observers.containsKey(key)) {
            MetadataViewObserver observer = observers.get(activity.hashCode());
            observers.remove(key);
            observer.stopTracking();
        }
    }

    private void startTracking() {
        if (this.isTracking.getAndSet(true)) {
            return;
        }
        View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (observer.isAlive()) {
            observer.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
        }
    }

    private void stopTracking() {
        if (!this.isTracking.getAndSet(false)) {
            return;
        }
        View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        observer.removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
    }

    public void onGlobalFocusChanged(@Nullable View oldView, @Nullable View newView) {
        if (oldView != null) {
            this.process(oldView);
        }
        if (newView != null) {
            this.process(newView);
        }
    }

    private void process(final View view) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!(view instanceof EditText)) {
                    return;
                }
                MetadataViewObserver.this.processEditText(view);
            }
        };
        this.runOnUIThread(runnable);
    }

    private void processEditText(View view) {
        String text = ((EditText)view).getText().toString().trim().toLowerCase();
        if (text.isEmpty() || this.processedText.contains(text) || text.length() > 100) {
            return;
        }
        this.processedText.add(text);
        HashMap<String, String> userData = new HashMap<String, String>();
        List<String> currentViewIndicators = MetadataMatcher.getCurrentViewIndicators(view);
        List<String> aroundTextIndicators = null;
        for (MetadataRule rule : MetadataRule.getRules()) {
            String normalizedText = MetadataViewObserver.preNormalize(rule.getName(), text);
            if (!rule.getValRule().isEmpty() && !MetadataMatcher.matchValue(normalizedText, rule.getValRule())) continue;
            if (MetadataMatcher.matchIndicator(currentViewIndicators, rule.getKeyRules())) {
                MetadataViewObserver.putUserData(userData, rule.getName(), normalizedText);
                continue;
            }
            if (aroundTextIndicators == null) {
                aroundTextIndicators = MetadataMatcher.getAroundViewIndicators(view);
            }
            if (!MetadataMatcher.matchIndicator(aroundTextIndicators, rule.getKeyRules())) continue;
            MetadataViewObserver.putUserData(userData, rule.getName(), normalizedText);
        }
        InternalAppEventsLogger.setInternalUserData(userData);
    }

    private static String preNormalize(String key, String val) {
        if ("r2".equals(key)) {
            return val.replaceAll("[^\\d.]", "");
        }
        return val;
    }

    private static void putUserData(Map<String, String> userData, String key, String val) {
        switch (key) {
            case "r3": {
                if (val.startsWith("m") || val.startsWith("b") || val.startsWith("ge")) {
                    val = "m";
                    break;
                }
                val = "f";
                break;
            }
            case "r4": 
            case "r5": {
                val = val.replaceAll("[^a-z]+", "");
                break;
            }
            case "r6": {
                if (!val.contains("-")) break;
                String[] splitArray = val.split("-");
                val = splitArray[0];
            }
        }
        userData.put(key, val);
    }

    private void runOnUIThread(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.uiThreadHandler.post(runnable);
        }
    }
}

