/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import androidx.annotation.RestrictTo;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@AutoHandleExceptions
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MetadataRule {
    private static final String TAG = MetadataRule.class.getCanonicalName();
    private static final Set<MetadataRule> rules = new HashSet<MetadataRule>();
    private static final String FIELD_K = "k";
    private static final String FIELD_V = "v";
    private static final String FIELD_K_DELIMITER = ",";
    private String name;
    private List<String> keyRules;
    private String valRule;

    private MetadataRule(String name, List<String> keyRules, String valRule) {
        this.name = name;
        this.keyRules = keyRules;
        this.valRule = valRule;
    }

    static Set<MetadataRule> getRules() {
        return new HashSet<MetadataRule>(rules);
    }

    String getName() {
        return this.name;
    }

    List<String> getKeyRules() {
        return new ArrayList<String>(this.keyRules);
    }

    String getValRule() {
        return this.valRule;
    }

    static void updateRules(String rulesFromServer) {
        try {
            rules.clear();
            JSONObject jsonObject = new JSONObject(rulesFromServer);
            MetadataRule.constructRules(jsonObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static void constructRules(JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject rule = jsonObject.optJSONObject(key);
            if (rule == null) continue;
            String k = rule.optString(FIELD_K);
            String v = rule.optString(FIELD_V);
            if (k.isEmpty()) continue;
            rules.add(new MetadataRule(key, Arrays.asList(k.split(FIELD_K_DELIMITER)), v));
        }
    }

    public static Set<String> getEnabledRuleNames() {
        HashSet<String> ruleNames = new HashSet<String>();
        for (MetadataRule r : rules) {
            ruleNames.add(r.getName());
        }
        return ruleNames;
    }
}

