/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.ArrayList;
import java.util.List;

@AutoHandleExceptions
final class MetadataMatcher {
    private static final String TAG = MetadataMatcher.class.getCanonicalName();
    private static final int MAX_INDICATOR_LENGTH = 100;

    MetadataMatcher() {
    }

    static List<String> getCurrentViewIndicators(View view) {
        CharSequence description;
        ArrayList<String> indicators = new ArrayList<String>();
        indicators.add(ViewHierarchy.getHintOfView(view));
        Object tag = view.getTag();
        if (tag != null) {
            indicators.add(tag.toString());
        }
        if ((description = view.getContentDescription()) != null) {
            indicators.add(description.toString());
        }
        try {
            String resourceName;
            String[] splitted;
            if (view.getId() != -1 && (splitted = (resourceName = view.getResources().getResourceName(view.getId())).split("/")).length == 2) {
                indicators.add(splitted[1]);
            }
        }
        catch (Resources.NotFoundException resourceName) {
            // empty catch block
        }
        ArrayList<String> validIndicators = new ArrayList<String>();
        for (String indicator : indicators) {
            if (indicator.isEmpty() || indicator.length() > 100) continue;
            validIndicators.add(indicator.toLowerCase());
        }
        return validIndicators;
    }

    static List<String> getAroundViewIndicators(View view) {
        ArrayList<String> aroundTextIndicators = new ArrayList<String>();
        ViewGroup parentView = ViewHierarchy.getParentOfView(view);
        if (parentView != null) {
            for (View child : ViewHierarchy.getChildrenOfView((View)parentView)) {
                if (view == child) continue;
                aroundTextIndicators.addAll(MetadataMatcher.getTextIndicators(child));
            }
        }
        return aroundTextIndicators;
    }

    static boolean matchIndicator(List<String> indicators, List<String> keys) {
        for (String indicator : indicators) {
            if (!MetadataMatcher.matchIndicator(indicator, keys)) continue;
            return true;
        }
        return false;
    }

    static boolean matchIndicator(String indicator, List<String> keys) {
        for (String key : keys) {
            if (!indicator.contains(key)) continue;
            return true;
        }
        return false;
    }

    static boolean matchValue(String text, String rule) {
        return text.matches(rule);
    }

    static List<String> getTextIndicators(View view) {
        ArrayList<String> indicators = new ArrayList<String>();
        if (view instanceof EditText) {
            return indicators;
        }
        if (view instanceof TextView) {
            String text = ((TextView)view).getText().toString();
            if (!text.isEmpty() && text.length() < 100) {
                indicators.add(text.toLowerCase());
            }
            return indicators;
        }
        List<View> children = ViewHierarchy.getChildrenOfView(view);
        for (View child : children) {
            indicators.addAll(MetadataMatcher.getTextIndicators(child));
        }
        return indicators;
    }
}

