/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.SharedPreferences;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.AutoHandleExceptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@AutoHandleExceptions
public class PerformanceGuardian {
    private static boolean initialized = false;
    private static SharedPreferences sharedPreferences;
    private static final String BANNED_ACTIVITY_STORE = "com.facebook.internal.BANNED_ACTIVITY";
    private static final String CACHE_APP_VERSION = "app_version";
    private static final Integer ACTIVITY_PROCESS_TIME_THRESHOLD;
    private static final Integer MAX_EXCEED_LIMIT_COUNT;
    private static final Set<String> bannedSuggestedEventActivitySet;
    private static final Set<String> bannedCodelessActivitySet;
    private static final Map<String, Integer> activityProcessTimeMapCodeless;
    private static final Map<String, Integer> activityProcessTimeMapSe;

    private static synchronized void initializeIfNotYet() {
        if (initialized) {
            return;
        }
        sharedPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(BANNED_ACTIVITY_STORE, 0);
        String cachedVersion = sharedPreferences.getString(CACHE_APP_VERSION, "");
        if (!PerformanceGuardian.isCacheValid(cachedVersion)) {
            sharedPreferences.edit().clear().apply();
        } else {
            bannedCodelessActivitySet.addAll(sharedPreferences.getStringSet(UseCase.CODELESS.toString(), new HashSet()));
            bannedSuggestedEventActivitySet.addAll(sharedPreferences.getStringSet(UseCase.SUGGESTED_EVENT.toString(), new HashSet()));
        }
        initialized = true;
    }

    public static boolean isBannedActivity(String activityName, UseCase useCase) {
        PerformanceGuardian.initializeIfNotYet();
        switch (useCase) {
            case CODELESS: {
                return bannedCodelessActivitySet.contains(activityName);
            }
            case SUGGESTED_EVENT: {
                return bannedSuggestedEventActivitySet.contains(activityName);
            }
        }
        return false;
    }

    public static void limitProcessTime(String activityName, UseCase useCase, long startTime, long endTime) {
        PerformanceGuardian.initializeIfNotYet();
        long processTime = endTime - startTime;
        if (activityName == null || processTime < (long)ACTIVITY_PROCESS_TIME_THRESHOLD.intValue()) {
            return;
        }
        switch (useCase) {
            case CODELESS: {
                PerformanceGuardian.updateActivityMap(useCase, activityName, activityProcessTimeMapCodeless, bannedCodelessActivitySet);
                break;
            }
            case SUGGESTED_EVENT: {
                PerformanceGuardian.updateActivityMap(useCase, activityName, activityProcessTimeMapSe, bannedSuggestedEventActivitySet);
            }
        }
    }

    private static void updateActivityMap(UseCase useCase, String activityName, Map<String, Integer> activityExceedLimitCountMap, Set<String> bannedActivitySet) {
        int curExceedLimitCount = 0;
        if (activityExceedLimitCountMap.containsKey(activityName)) {
            curExceedLimitCount = activityExceedLimitCountMap.get(activityName);
        }
        activityExceedLimitCountMap.put(activityName, curExceedLimitCount + 1);
        if (curExceedLimitCount + 1 >= MAX_EXCEED_LIMIT_COUNT) {
            bannedActivitySet.add(activityName);
            sharedPreferences.edit().putStringSet(useCase.toString(), bannedActivitySet).putString(CACHE_APP_VERSION, Utility.getAppVersion()).apply();
        }
    }

    private static boolean isCacheValid(String previousVersion) {
        String appVersion = Utility.getAppVersion();
        if (appVersion == null || previousVersion.isEmpty()) {
            return false;
        }
        return previousVersion.equals(appVersion);
    }

    static {
        ACTIVITY_PROCESS_TIME_THRESHOLD = 40;
        MAX_EXCEED_LIMIT_COUNT = 3;
        bannedSuggestedEventActivitySet = new HashSet<String>();
        bannedCodelessActivitySet = new HashSet<String>();
        activityProcessTimeMapCodeless = new HashMap<String, Integer>();
        activityProcessTimeMapSe = new HashMap<String, Integer>();
    }

    public static enum UseCase {
        CODELESS,
        SUGGESTED_EVENT;

    }
}

