/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import androidx.annotation.Nullable;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LogCategory;
import com.facebook.internal.logging.LogEvent;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitorLog
implements ExternalLog {
    private static final long serialVersionUID = 1L;
    private LogEvent logEvent;
    private long timeStart;
    private int timeSpent;
    private int hashCode;
    private static final int INVALID_TIME = -1;
    private static Set<String> validPerformanceEventNames = new HashSet<String>();

    public MonitorLog(LogBuilder logBuilder) {
        this.logEvent = logBuilder.logEvent;
        this.timeStart = logBuilder.timeStart;
        this.timeSpent = logBuilder.timeSpent;
    }

    @Override
    public String getEventName() {
        return this.logEvent.getEventName();
    }

    @Override
    public LogCategory getLogCategory() {
        return this.logEvent.getLogCategory();
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public int getTimeSpent() {
        return this.timeSpent;
    }

    public String toString() {
        String format = ": %s";
        return String.format("event_name" + format + ", " + "category" + format + ", " + "time_start" + format + ", " + "time_spent" + format, new Object[]{this.logEvent.getEventName(), this.logEvent.getLogCategory(), this.timeStart, this.timeSpent});
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + this.logEvent.hashCode();
            result = 31 * result + (int)(this.timeStart ^ this.timeStart >>> 32);
            this.hashCode = result = 31 * result + (this.timeSpent ^ this.timeSpent >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorLog other = (MonitorLog)obj;
        return this.logEvent.getEventName().equals(other.logEvent.getEventName()) && this.logEvent.getLogCategory().equals((Object)other.logEvent.getLogCategory()) && this.timeStart == other.timeStart && this.timeSpent == other.timeSpent;
    }

    @Override
    public JSONObject convertToJSONObject() {
        JSONObject object = new JSONObject();
        try {
            object.put("event_name", (Object)this.logEvent.getEventName());
            object.put("category", (Object)this.logEvent.getLogCategory());
            if (this.timeStart != 0L) {
                object.put("time_start", this.timeStart);
            }
            if (this.timeSpent != 0) {
                object.put("time_spent", this.timeSpent);
            }
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static {
        validPerformanceEventNames.add("FB_CORE_STARTUP");
    }

    public static class LogBuilder {
        private LogEvent logEvent;
        private long timeStart;
        private int timeSpent;

        public LogBuilder(LogEvent logEvent) {
            this.logEvent = logEvent;
            if (logEvent.getLogCategory() == LogCategory.PERFORMANCE) {
                logEvent.upperCaseEventName();
            }
        }

        public LogBuilder timeStart(long timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public LogBuilder timeSpent(int timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        public MonitorLog build() {
            MonitorLog monitorLog = new MonitorLog(this);
            this.validateMonitorLog(monitorLog);
            return monitorLog;
        }

        private void validateMonitorLog(MonitorLog monitorLog) {
            if (this.timeSpent < 0) {
                monitorLog.timeSpent = -1;
            }
            if (this.timeStart < 0L) {
                monitorLog.timeStart = -1L;
            }
            if (this.logEvent.getLogCategory() == LogCategory.PERFORMANCE && !validPerformanceEventNames.contains(this.logEvent.getEventName())) {
                throw new IllegalArgumentException("Invalid event name: " + this.logEvent.getEventName() + "\nIt should be one of " + validPerformanceEventNames + ".");
            }
        }
    }
}

