/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashHandler.class.getCanonicalName();
    private static final int MAX_CRASH_REPORT_NUM = 5;
    @Nullable
    private static CrashHandler instance;
    @Nullable
    private final Thread.UncaughtExceptionHandler mPreviousHandler;

    private CrashHandler(@Nullable Thread.UncaughtExceptionHandler oldHandler) {
        this.mPreviousHandler = oldHandler;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (InstrumentUtility.isSDKRelatedException(e)) {
            ExceptionAnalyzer.execute(e);
            InstrumentData.Builder.build(e, InstrumentData.Type.CrashReport).save();
        }
        if (this.mPreviousHandler != null) {
            this.mPreviousHandler.uncaughtException(t, e);
        }
    }

    public static synchronized void enable() {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            CrashHandler.sendExceptionReports();
        }
        if (instance != null) {
            Log.w((String)TAG, (String)"Already enabled!");
            return;
        }
        Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        instance = new CrashHandler(oldHandler);
        Thread.setDefaultUncaughtExceptionHandler(instance);
    }

    private static void sendExceptionReports() {
        if (Utility.isDataProcessingRestricted()) {
            return;
        }
        File[] reports = InstrumentUtility.listExceptionReportFiles();
        final ArrayList<InstrumentData> validReports = new ArrayList<InstrumentData>();
        for (File report : reports) {
            InstrumentData instrumentData = InstrumentData.Builder.load(report);
            if (!instrumentData.isValid()) continue;
            validReports.add(instrumentData);
        }
        Collections.sort(validReports, new Comparator<InstrumentData>(){

            @Override
            public int compare(InstrumentData o1, InstrumentData o2) {
                return o1.compareTo(o2);
            }
        });
        JSONArray crashLogs = new JSONArray();
        for (int i = 0; i < validReports.size() && i < 5; ++i) {
            crashLogs.put(validReports.get(i));
        }
        InstrumentUtility.sendReports("crash_reports", crashLogs, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                try {
                    if (response.getError() == null && response.getJSONObject().getBoolean("success")) {
                        for (int i = 0; validReports.size() > i; ++i) {
                            ((InstrumentData)validReports.get(i)).clear();
                        }
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }
}

