/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

public class InstallReferrerUtil {
    private static final String IS_REFERRER_UPDATED = "is_referrer_updated";

    private InstallReferrerUtil() {
    }

    public static void tryUpdateReferrerInfo(Callback callback) {
        if (CrashShieldHandler.isObjectCrashing(InstallReferrerUtil.class)) {
            return;
        }
        try {
            if (!InstallReferrerUtil.isUpdated()) {
                Callback callback2;
                InstallReferrerUtil.tryConnectReferrerInfo(callback2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InstallReferrerUtil.class);
            return;
        }
    }

    private static void tryConnectReferrerInfo(Callback callback) {
        if (CrashShieldHandler.isObjectCrashing(InstallReferrerUtil.class)) {
            return;
        }
        try {
            Callback callback2;
            final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)FacebookSdk.getApplicationContext()).build();
            InstallReferrerStateListener installReferrerStateListener = new InstallReferrerStateListener(){

                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case 0: {
                            ReferrerDetails response;
                            try {
                                response = referrerClient.getInstallReferrer();
                            }
                            catch (RemoteException e) {
                                return;
                            }
                            String referrerUrl = response.getInstallReferrer();
                            if (referrerUrl != null && (referrerUrl.contains("fb") || referrerUrl.contains("facebook"))) {
                                callback2.onReceiveReferrerUrl(referrerUrl);
                            }
                            InstallReferrerUtil.access$000();
                            break;
                        }
                        case 2: {
                            InstallReferrerUtil.access$000();
                            break;
                        }
                    }
                }

                public void onInstallReferrerServiceDisconnected() {
                }
            };
            try {
                referrerClient.startConnection(installReferrerStateListener);
            }
            catch (Exception e) {
                return;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InstallReferrerUtil.class);
            return;
        }
    }

    private static void updateReferrer() {
        if (CrashShieldHandler.isObjectCrashing(InstallReferrerUtil.class)) {
            return;
        }
        try {
            SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
            preferences.edit().putBoolean(IS_REFERRER_UPDATED, true).apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InstallReferrerUtil.class);
            return;
        }
    }

    private static boolean isUpdated() {
        if (CrashShieldHandler.isObjectCrashing(InstallReferrerUtil.class)) {
            return false;
        }
        try {
            SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
            return preferences.getBoolean(IS_REFERRER_UPDATED, false);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InstallReferrerUtil.class);
            return false;
        }
    }

    static /* synthetic */ void access$000() {
        if (CrashShieldHandler.isObjectCrashing(InstallReferrerUtil.class)) {
            return;
        }
        try {
            InstallReferrerUtil.updateReferrer();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, InstallReferrerUtil.class);
            return;
        }
    }

    public static interface Callback {
        public void onReceiveReferrerUrl(String var1);
    }
}

