/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.errorreport;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.errorreport.ErrorReportData;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorReportHandler {
    private static final int MAX_ERROR_REPORT_NUM = 1000;

    public static void save(String msg) {
        try {
            ErrorReportData errorReport = new ErrorReportData(msg);
            errorReport.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void enable() {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            ErrorReportHandler.sendErrorReports();
        }
    }

    public static void sendErrorReports() {
        File[] reports = ErrorReportHandler.listErrorReportFiles();
        final ArrayList<ErrorReportData> validReports = new ArrayList<ErrorReportData>();
        for (File report : reports) {
            ErrorReportData errorData = new ErrorReportData(report);
            if (!errorData.isValid()) continue;
            validReports.add(errorData);
        }
        Collections.sort(validReports, new Comparator<ErrorReportData>(){

            @Override
            public int compare(ErrorReportData o1, ErrorReportData o2) {
                return o1.compareTo(o2);
            }
        });
        JSONArray errorLogs = new JSONArray();
        for (int i = 0; i < validReports.size() && i < 1000; ++i) {
            errorLogs.put(validReports.get(i));
        }
        InstrumentUtility.sendReports("error_reports", errorLogs, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                try {
                    if (response.getError() == null && response.getJSONObject().getBoolean("success")) {
                        for (int i = 0; validReports.size() > i; ++i) {
                            ((ErrorReportData)validReports.get(i)).clear();
                        }
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }

    public static File[] listErrorReportFiles() {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null) {
            return new File[0];
        }
        return reportDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(String.format("^%s[0-9]+.json$", "error_log_"));
            }
        });
    }
}

