/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.InstrumentData;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ExceptionAnalyzer {
    private static boolean enabled = false;

    public static void enable() {
        enabled = true;
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            ExceptionAnalyzer.sendExceptionAnalysisReports();
        }
    }

    public static void execute(Throwable e) {
        if (!enabled) {
            return;
        }
        HashSet<String> disabledFeatures = new HashSet<String>();
        for (StackTraceElement element : e.getStackTrace()) {
            FeatureManager.Feature feature = FeatureManager.getFeature(element.getClassName());
            if (feature == FeatureManager.Feature.Unknown) continue;
            FeatureManager.disableFeature(feature);
            disabledFeatures.add(feature.toString());
        }
        if (FacebookSdk.getAutoLogAppEventsEnabled() && !disabledFeatures.isEmpty()) {
            InstrumentData.Builder.build(new JSONArray(disabledFeatures)).save();
        }
    }

    private static void sendExceptionAnalysisReports() {
        File[] reports = InstrumentUtility.listExceptionAnalysisReportFiles();
        ArrayList<GraphRequest> requests = new ArrayList<GraphRequest>();
        for (File report : reports) {
            final InstrumentData instrumentData = InstrumentData.Builder.load(report);
            if (!instrumentData.isValid()) continue;
            JSONObject params = new JSONObject();
            try {
                params.put("crash_shield", (Object)instrumentData.toString());
                GraphRequest request = GraphRequest.newPostRequest(null, String.format("%s/instruments", FacebookSdk.getApplicationId()), params, new GraphRequest.Callback(){

                    @Override
                    public void onCompleted(GraphResponse response) {
                        try {
                            if (response.getError() == null && response.getJSONObject().getBoolean("success")) {
                                instrumentData.clear();
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                });
                requests.add(request);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (requests.isEmpty()) {
            return;
        }
        GraphRequestBatch requestBatch = new GraphRequestBatch(requests);
        requestBatch.executeAsync();
    }
}

