/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AnalyticsUserIDStore;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventQueue;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.FacebookSDKJSInterface;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.UserDataStore;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.InstallReferrerUtil;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AppEventsLoggerImpl {
    private static final String TAG = AppEventsLoggerImpl.class.getCanonicalName();
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    private static final String PUSH_PAYLOAD_KEY = "fb_push_payload";
    private static final String PUSH_PAYLOAD_CAMPAIGN_KEY = "campaign";
    private static final String APP_EVENT_NAME_PUSH_OPENED = "fb_mobile_push_opened";
    private static final String APP_EVENT_PUSH_PARAMETER_CAMPAIGN = "fb_push_campaign";
    private static final String APP_EVENT_PUSH_PARAMETER_ACTION = "fb_push_action";
    private static final String ACCOUNT_KIT_EVENT_NAME_PREFIX = "fb_ak";
    private final String contextName;
    private final AccessTokenAppIdPair accessTokenAppId;
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    private static AppEventsLogger.FlushBehavior flushBehavior;
    private static final Object staticLock;
    private static String anonymousAppDeviceGUID;
    private static boolean isActivateAppEventRequested;
    private static String pushNotificationsRegistrationId;
    private static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final String APP_EVENTS_KILLSWITCH = "app_events_killswitch";

    static void activateApp(Application application, String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            Application application2;
            String applicationId;
            if (!FacebookSdk.isInitialized()) {
                throw new FacebookException("The Facebook sdk must be initialized before calling activateApp");
            }
            AnalyticsUserIDStore.initStore();
            UserDataStore.initStore();
            if (applicationId == null) {
                applicationId = FacebookSdk.getApplicationId();
            }
            FacebookSdk.publishInstallAsync((Context)application2, applicationId);
            ActivityLifecycleTracker.startTracking(application2, applicationId);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    static void functionDEPRECATED(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String extraMsg;
            Log.w((String)TAG, (String)("This function is deprecated. " + extraMsg));
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void initializeLib(Context context, String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void applicationId;
            Context context2;
            if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
                return;
            }
            final AppEventsLoggerImpl logger = new AppEventsLoggerImpl(context2, (String)applicationId, null);
            backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        Bundle params = new Bundle();
                        String[] classes = new String[]{"com.facebook.core.Core", "com.facebook.login.Login", "com.facebook.share.Share", "com.facebook.places.Places", "com.facebook.messenger.Messenger", "com.facebook.applinks.AppLinks", "com.facebook.marketing.Marketing", "com.facebook.gamingservices.GamingServices", "com.facebook.all.All", "com.android.billingclient.api.BillingClient", "com.android.vending.billing.IInAppBillingService"};
                        String[] keys = new String[]{"core_lib_included", "login_lib_included", "share_lib_included", "places_lib_included", "messenger_lib_included", "applinks_lib_included", "marketing_lib_included", "gamingservices_lib_included", "all_lib_included", "billing_client_lib_included", "billing_service_lib_included"};
                        if (classes.length != keys.length) {
                            throw new FacebookException("Number of class names and key names should match");
                        }
                        int bitmask = 0;
                        for (int i = 0; i < classes.length; ++i) {
                            String className = classes[i];
                            String keyName = keys[i];
                            try {
                                Class.forName(className);
                                params.putInt(keyName, 1);
                                bitmask |= 1 << i;
                                continue;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                        SharedPreferences preferences = context2.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
                        int previousBitmask = preferences.getInt("kitsBitmask", 0);
                        if (previousBitmask != bitmask) {
                            preferences.edit().putInt("kitsBitmask", bitmask).apply();
                            logger.logEventImplicitly("fb_sdk_initialize", null, params);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AppEventsLogger.FlushBehavior getFlushBehavior() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            Object object = staticLock;
            synchronized (object) {
                return flushBehavior;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setFlushBehavior(AppEventsLogger.FlushBehavior flushBehavior) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            Object object = staticLock;
            synchronized (object) {
                AppEventsLogger.FlushBehavior flushBehavior2;
                AppEventsLoggerImpl.flushBehavior = flushBehavior2;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEvent(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            this.logEvent((String)eventName, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEvent(String string, double d) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void valueToSum;
            void eventName;
            this.logEvent((String)eventName, (double)valueToSum, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEvent(String string, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void eventName;
            this.logEvent((String)eventName, null, (Bundle)parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEvent(String string, double d, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void valueToSum;
            void eventName;
            this.logEvent((String)eventName, (double)valueToSum, (Bundle)parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEventFromSE(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            void buttonText;
            Bundle parameters = new Bundle();
            parameters.putString("_is_suggested_event", "1");
            parameters.putString("_button_text", (String)buttonText);
            this.logEvent((String)eventName, parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logPurchase(BigDecimal bigDecimal, Currency currency) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void currency2;
            void purchaseAmount;
            this.logPurchase((BigDecimal)purchaseAmount, (Currency)currency2, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logPurchase(BigDecimal bigDecimal, Currency currency, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void currency2;
            void purchaseAmount;
            if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
                Log.w((String)TAG, (String)"You are logging purchase events while auto-logging of in-app purchase is enabled in the SDK. Make sure you don't log duplicate events");
            }
            this.logPurchase((BigDecimal)purchaseAmount, (Currency)currency2, (Bundle)parameters, false);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logPurchaseImplicitly(BigDecimal bigDecimal, Currency currency, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void currency2;
            void purchaseAmount;
            this.logPurchase((BigDecimal)purchaseAmount, (Currency)currency2, (Bundle)parameters, true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logPurchase(BigDecimal bigDecimal, Currency currency, Bundle bundle, boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void isImplicitlyLogged;
            Bundle parameters;
            void currency2;
            void purchaseAmount;
            if (purchaseAmount == null) {
                AppEventsLoggerImpl.notifyDeveloperError("purchaseAmount cannot be null");
                return;
            }
            if (currency2 == null) {
                AppEventsLoggerImpl.notifyDeveloperError("currency cannot be null");
                return;
            }
            if (parameters == null) {
                parameters = new Bundle();
            }
            parameters.putString("fb_currency", currency2.getCurrencyCode());
            this.logEvent("fb_mobile_purchase", purchaseAmount.doubleValue(), parameters, (boolean)isImplicitlyLogged, ActivityLifecycleTracker.getCurrentSessionGuid());
            AppEventsLoggerImpl.eagerFlush();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logPushNotificationOpen(Bundle bundle, String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void action;
            String campaignId = null;
            try {
                void payload;
                String payloadString = payload.getString(PUSH_PAYLOAD_KEY);
                if (Utility.isNullOrEmpty(payloadString)) {
                    return;
                }
                JSONObject facebookPayload = new JSONObject(payloadString);
                campaignId = facebookPayload.getString(PUSH_PAYLOAD_CAMPAIGN_KEY);
            }
            catch (JSONException payloadString) {
                // empty catch block
            }
            if (campaignId == null) {
                Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Malformed payload specified for logging a push notification open.");
                return;
            }
            Bundle parameters = new Bundle();
            parameters.putString(APP_EVENT_PUSH_PARAMETER_CAMPAIGN, campaignId);
            if (action != null) {
                parameters.putString(APP_EVENT_PUSH_PARAMETER_ACTION, (String)action);
            }
            this.logEvent(APP_EVENT_NAME_PUSH_OPENED, parameters);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logProductItem(String string, AppEventsLogger.ProductAvailability productAvailability, AppEventsLogger.ProductCondition productCondition, String string2, String string3, String string4, String string5, BigDecimal bigDecimal, Currency currency, String string6, String string7, String string8, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Bundle parameters;
            void brand;
            void mpn;
            void gtin;
            void currency2;
            void priceAmount;
            void title;
            void link;
            void imageLink;
            void description;
            void condition;
            void availability;
            void itemID;
            if (itemID == null) {
                AppEventsLoggerImpl.notifyDeveloperError("itemID cannot be null");
                return;
            }
            if (availability == null) {
                AppEventsLoggerImpl.notifyDeveloperError("availability cannot be null");
                return;
            }
            if (condition == null) {
                AppEventsLoggerImpl.notifyDeveloperError("condition cannot be null");
                return;
            }
            if (description == null) {
                AppEventsLoggerImpl.notifyDeveloperError("description cannot be null");
                return;
            }
            if (imageLink == null) {
                AppEventsLoggerImpl.notifyDeveloperError("imageLink cannot be null");
                return;
            }
            if (link == null) {
                AppEventsLoggerImpl.notifyDeveloperError("link cannot be null");
                return;
            }
            if (title == null) {
                AppEventsLoggerImpl.notifyDeveloperError("title cannot be null");
                return;
            }
            if (priceAmount == null) {
                AppEventsLoggerImpl.notifyDeveloperError("priceAmount cannot be null");
                return;
            }
            if (currency2 == null) {
                AppEventsLoggerImpl.notifyDeveloperError("currency cannot be null");
                return;
            }
            if (gtin == null && mpn == null && brand == null) {
                AppEventsLoggerImpl.notifyDeveloperError("Either gtin, mpn or brand is required");
                return;
            }
            if (parameters == null) {
                parameters = new Bundle();
            }
            parameters.putString("fb_product_item_id", (String)itemID);
            parameters.putString("fb_product_availability", availability.name());
            parameters.putString("fb_product_condition", condition.name());
            parameters.putString("fb_product_description", (String)description);
            parameters.putString("fb_product_image_link", (String)imageLink);
            parameters.putString("fb_product_link", (String)link);
            parameters.putString("fb_product_title", (String)title);
            parameters.putString("fb_product_price_amount", priceAmount.setScale(3, 4).toString());
            parameters.putString("fb_product_price_currency", currency2.getCurrencyCode());
            if (gtin != null) {
                parameters.putString("fb_product_gtin", (String)gtin);
            }
            if (mpn != null) {
                parameters.putString("fb_product_mpn", (String)mpn);
            }
            if (brand != null) {
                parameters.putString("fb_product_brand", (String)brand);
            }
            this.logEvent("fb_mobile_catalog_update", parameters);
            AppEventsLoggerImpl.eagerFlush();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    void flush() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            AppEventQueue.flush(FlushReason.EXPLICIT);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    static void onContextStop() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            AppEventQueue.persistToDisk();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isValidForAccessToken(AccessToken accessToken) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return false;
        }
        try {
            void accessToken2;
            AccessTokenAppIdPair other = new AccessTokenAppIdPair((AccessToken)accessToken2);
            return this.accessTokenAppId.equals(other);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPushNotificationsRegistrationId(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            Object object = staticLock;
            synchronized (object) {
                String registrationId;
                if (!Utility.stringsEqualOrEmpty(pushNotificationsRegistrationId, registrationId)) {
                    pushNotificationsRegistrationId = registrationId;
                    AppEventsLoggerImpl logger = new AppEventsLoggerImpl(FacebookSdk.getApplicationContext(), null, null);
                    logger.logEvent("fb_mobile_obtain_push_token");
                    if (AppEventsLoggerImpl.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                        logger.flush();
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPushNotificationsRegistrationId() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            Object object = staticLock;
            synchronized (object) {
                return pushNotificationsRegistrationId;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    static void setInstallReferrer(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String referrer;
            Context ctx = FacebookSdk.getApplicationContext();
            SharedPreferences preferences = ctx.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
            if (referrer != null) {
                preferences.edit().putString("install_referrer", referrer).apply();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    @Nullable
    static String getInstallReferrer() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            InstallReferrerUtil.tryUpdateReferrerInfo(new InstallReferrerUtil.Callback(){

                @Override
                public void onReceiveReferrerUrl(String s) {
                    AppEventsLoggerImpl.setInstallReferrer(s);
                }
            });
            Context ctx = FacebookSdk.getApplicationContext();
            SharedPreferences preferences = ctx.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
            return preferences.getString("install_referrer", null);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void augmentWebView(WebView webView, Context context) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void context2;
            WebView webView2;
            int minorRelease;
            String[] parts = Build.VERSION.RELEASE.split("\\.");
            int majorRelease = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
            int n = minorRelease = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            if (Build.VERSION.SDK_INT < 17 || majorRelease < 4 || majorRelease == 4 && minorRelease <= 1) {
                Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "augmentWebView is only available for Android SDK version >= 17 on devices running Android >= 4.2");
                return;
            }
            webView2.addJavascriptInterface((Object)new FacebookSDKJSInterface((Context)context2), "fbmq_" + FacebookSdk.getApplicationId());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void updateUserProperties(Bundle bundle, String string, GraphRequest.Callback callback) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            void callback2;
            void applicationID;
            Bundle parameters;
            AppEventsLoggerImpl.getAnalyticsExecutor().execute(new Runnable((String)applicationID, (GraphRequest.Callback)callback2){
                final /* synthetic */ String val$applicationID;
                final /* synthetic */ GraphRequest.Callback val$callback;
                {
                    this.val$applicationID = string;
                    this.val$callback = callback;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        String userID = AnalyticsUserIDStore.getUserID();
                        if (userID == null || userID.isEmpty()) {
                            Logger.log(LoggingBehavior.APP_EVENTS, AppEventsLoggerImpl.access$000(), "AppEventsLogger userID cannot be null or empty");
                            return;
                        }
                        Bundle userPropertiesParams = new Bundle();
                        userPropertiesParams.putString("user_unique_id", userID);
                        userPropertiesParams.putBundle("custom_data", parameters);
                        AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(FacebookSdk.getApplicationContext());
                        if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                            userPropertiesParams.putString("advertiser_id", identifiers.getAndroidAdvertiserId());
                        }
                        Bundle data = new Bundle();
                        try {
                            JSONObject userData = BundleJSONConverter.convertToJSON(userPropertiesParams);
                            JSONArray dataArray = new JSONArray();
                            dataArray.put((Object)userData);
                            data.putString("data", dataArray.toString());
                        }
                        catch (JSONException ex) {
                            throw new FacebookException("Failed to construct request", ex);
                        }
                        GraphRequest request = new GraphRequest(AccessToken.getCurrentAccessToken(), String.format(Locale.US, "%s/user_properties", this.val$applicationID), data, HttpMethod.POST, this.val$callback);
                        request.setSkipClientToken(true);
                        request.executeAsync();
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logSdkEvent(String string, Double d, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            if (!eventName.startsWith(ACCOUNT_KIT_EVENT_NAME_PREFIX)) {
                Log.e((String)TAG, (String)"logSdkEvent is deprecated and only supports account kit for legacy, please use logEvent instead");
                return;
            }
            if (FacebookSdk.getAutoLogAppEventsEnabled()) {
                void parameters;
                void valueToSum;
                this.logEvent((String)eventName, (Double)valueToSum, (Bundle)parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public String getApplicationId() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return this.accessTokenAppId.getApplicationId();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    AppEventsLoggerImpl(Context context, String applicationId, AccessToken accessToken) {
        this(Utility.getActivityName(context), applicationId, accessToken);
    }

    AppEventsLoggerImpl(String activityName, String applicationId, AccessToken accessToken) {
        Validate.sdkInitialized();
        this.contextName = activityName;
        if (accessToken == null) {
            accessToken = AccessToken.getCurrentAccessToken();
        }
        if (accessToken != null && !accessToken.isExpired() && (applicationId == null || applicationId.equals(accessToken.getApplicationId()))) {
            this.accessTokenAppId = new AccessTokenAppIdPair(accessToken);
        } else {
            if (applicationId == null) {
                applicationId = Utility.getMetadataApplicationId(FacebookSdk.getApplicationContext());
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, applicationId);
        }
        AppEventsLoggerImpl.initializeTimersIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeTimersIfNeeded() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            Object object = staticLock;
            synchronized (object) {
                if (backgroundExecutor != null) {
                    return;
                }
                backgroundExecutor = new ScheduledThreadPoolExecutor(1);
            }
            Runnable attributionRecheckRunnable = new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        HashSet<String> applicationIds = new HashSet<String>();
                        for (AccessTokenAppIdPair accessTokenAppId : AppEventQueue.getKeySet()) {
                            applicationIds.add(accessTokenAppId.getApplicationId());
                        }
                        for (String applicationId : applicationIds) {
                            FetchedAppSettingsManager.queryAppSettings(applicationId, true);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            };
            backgroundExecutor.scheduleAtFixedRate(attributionRecheckRunnable, 0L, 86400L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEventImplicitly(String string, Double d, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void parameters;
            void valueToSum;
            void eventName;
            this.logEvent((String)eventName, (Double)valueToSum, (Bundle)parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEventImplicitly(String string, BigDecimal bigDecimal, Currency currency, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            Bundle parameters;
            void currency2;
            void purchaseAmount;
            if (purchaseAmount == null || currency2 == null) {
                Utility.logd(TAG, "purchaseAmount and currency cannot be null");
                return;
            }
            if (parameters == null) {
                parameters = new Bundle();
            }
            parameters.putString("fb_currency", currency2.getCurrencyCode());
            this.logEvent((String)eventName, purchaseAmount.doubleValue(), parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void logEvent(String string, Double d, Bundle bundle, boolean bl, @Nullable UUID uUID) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void eventName;
            if (eventName == null || eventName.isEmpty()) {
                return;
            }
            if (FetchedAppGateKeepersManager.getGateKeeperForKey(APP_EVENTS_KILLSWITCH, FacebookSdk.getApplicationId(), false)) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "KillSwitch is enabled and fail to log app event: %s", eventName);
                return;
            }
            try {
                void currentSessionId;
                void isImplicitlyLogged;
                void parameters;
                void valueToSum;
                AppEvent event = new AppEvent(this.contextName, (String)eventName, (Double)valueToSum, (Bundle)parameters, (boolean)isImplicitlyLogged, ActivityLifecycleTracker.isInBackground(), (UUID)currentSessionId);
                AppEventsLoggerImpl.logEvent(event, this.accessTokenAppId);
            }
            catch (JSONException jsonException) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", jsonException.toString());
            }
            catch (FacebookException e) {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event: %s", e.toString());
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logEvent(AppEvent appEvent, AccessTokenAppIdPair accessTokenAppIdPair) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            AppEvent event;
            void accessTokenAppId;
            AppEventQueue.add((AccessTokenAppIdPair)accessTokenAppId, event);
            if (!event.getIsImplicit() && !isActivateAppEventRequested) {
                if (event.getName().equals("fb_mobile_activate_app")) {
                    isActivateAppEventRequested = true;
                } else {
                    Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Warning: Please call AppEventsLogger.activateApp(...)from the long-lived activity's onResume() methodbefore logging other app events.");
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    static void eagerFlush() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            if (AppEventsLoggerImpl.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                AppEventQueue.flush(FlushReason.EAGER_FLUSHING_EVENT);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    private static void notifyDeveloperError(String string) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return;
        }
        try {
            String message;
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", message);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return;
        }
    }

    static Executor getAnalyticsExecutor() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            if (backgroundExecutor == null) {
                AppEventsLoggerImpl.initializeTimersIfNeeded();
            }
            return backgroundExecutor;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getAnonymousAppDeviceGUID(Context context) {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            if (anonymousAppDeviceGUID == null) {
                Object object = staticLock;
                synchronized (object) {
                    Context context2;
                    SharedPreferences preferences;
                    if (anonymousAppDeviceGUID == null && (anonymousAppDeviceGUID = (preferences = context2.getSharedPreferences(APP_EVENT_PREFERENCES, 0)).getString("anonymousAppDeviceGUID", null)) == null) {
                        anonymousAppDeviceGUID = "XZ" + UUID.randomUUID().toString();
                        context2.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit().putString("anonymousAppDeviceGUID", anonymousAppDeviceGUID).apply();
                    }
                }
            }
            return anonymousAppDeviceGUID;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    static /* synthetic */ String access$000() {
        if (CrashShieldHandler.isObjectCrashing(AppEventsLoggerImpl.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventsLoggerImpl.class);
            return null;
        }
    }

    static {
        flushBehavior = AppEventsLogger.FlushBehavior.AUTO;
        staticLock = new Object();
    }
}

