/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LoggingManager;
import com.facebook.internal.logging.monitor.MonitorLoggingManager;
import com.facebook.internal.logging.monitor.MonitorLoggingQueue;
import com.facebook.internal.logging.monitor.MonitorLoggingStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Monitor {
    private static final Random random = new Random();
    private static Integer defaultSamplingRate = 1000;
    private static boolean isEnabled;
    private static final LoggingManager monitorLoggingManager;
    private static final Map<String, Integer> samplingRatesMap;

    private Monitor() {
    }

    public static void enable() {
        if (isEnabled) {
            return;
        }
        isEnabled = true;
        Monitor.loadSamplingRatesMapAsync();
        monitorLoggingManager.flushLoggingStore();
    }

    public static void loadSamplingRatesMapAsync() {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    JSONObject samplingRates = Monitor.fetchSamplingRate();
                    if (samplingRates != null) {
                        Monitor.updateSamplingRateMap(samplingRates);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    static JSONObject fetchSamplingRate() {
        Bundle monitorConfigParams = new Bundle();
        monitorConfigParams.putString("fields", "monitoring_config");
        GraphRequest request = GraphRequest.newGraphPathRequest(null, FacebookSdk.getApplicationId(), null);
        request.setSkipClientToken(true);
        request.setParameters(monitorConfigParams);
        return request.executeAndWait().getJSONObject();
    }

    static void updateSamplingRateMap(JSONObject fetchedSamplingRates) {
        try {
            JSONArray samplingRates = fetchedSamplingRates.getJSONObject("monitoring_config").getJSONArray("sample_rates");
            for (int i = 0; i < samplingRates.length(); ++i) {
                JSONObject keyValuePair = samplingRates.getJSONObject(i);
                String eventName = keyValuePair.getString("key");
                int samplingRate = keyValuePair.getInt("value");
                if ("default".equals(eventName)) {
                    defaultSamplingRate = samplingRate;
                    continue;
                }
                samplingRatesMap.put(eventName, samplingRate);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void addLog(ExternalLog log) {
        if (isEnabled && Monitor.isSampled(log)) {
            monitorLoggingManager.addLog(log);
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static boolean isSampled(ExternalLog log) {
        String eventName = log.getEventName();
        int samplingRate = defaultSamplingRate;
        if (samplingRatesMap.containsKey(eventName)) {
            samplingRate = samplingRatesMap.get(eventName);
        }
        return samplingRate > 0 && random.nextInt(samplingRate) == 0;
    }

    static Integer getDefaultSamplingRate() {
        return defaultSamplingRate;
    }

    static {
        monitorLoggingManager = MonitorLoggingManager.getInstance(MonitorLoggingQueue.getInstance(), MonitorLoggingStore.getInstance());
        samplingRatesMap = new HashMap<String, Integer>();
    }
}

