/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentData {
    private static final String PARAM_TIMESTAMP = "timestamp";
    private static final String PARAM_APP_VERSION = "app_version";
    private static final String PARAM_DEVICE_OS = "device_os_version";
    private static final String PARAM_DEVICE_MODEL = "device_model";
    private static final String PARAM_REASON = "reason";
    private static final String PARAM_CALLSTACK = "callstack";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_FEATURE_NAMES = "feature_names";
    private String filename;
    private Type type;
    @Nullable
    private JSONArray featureNames;
    @Nullable
    private String appVersion;
    @Nullable
    private String cause;
    @Nullable
    private String stackTrace;
    @Nullable
    private Long timestamp;

    private InstrumentData(JSONArray features) {
        this.type = Type.Analysis;
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.featureNames = features;
        this.filename = new StringBuffer().append("analysis_log_").append(this.timestamp.toString()).append(".json").toString();
    }

    private InstrumentData(Throwable e, Type t) {
        this.type = t;
        this.appVersion = Utility.getAppVersion();
        this.cause = InstrumentUtility.getCause(e);
        this.stackTrace = InstrumentUtility.getStackTrace(e);
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.filename = new StringBuffer().append("crash_log_").append(this.timestamp.toString()).append(".json").toString();
    }

    private InstrumentData(File file) {
        this.filename = file.getName();
        this.type = InstrumentData.getType(this.filename);
        JSONObject object = InstrumentUtility.readFile(this.filename, true);
        if (object != null) {
            this.timestamp = object.optLong(PARAM_TIMESTAMP, 0L);
            this.appVersion = object.optString(PARAM_APP_VERSION, null);
            this.cause = object.optString(PARAM_REASON, null);
            this.stackTrace = object.optString(PARAM_CALLSTACK, null);
            this.featureNames = object.optJSONArray(PARAM_FEATURE_NAMES);
        }
    }

    private static Type getType(String filename) {
        if (filename.startsWith("crash_log_")) {
            return Type.CrashReport;
        }
        if (filename.startsWith("shield_log_")) {
            return Type.CrashShield;
        }
        if (filename.startsWith("thread_check_log_")) {
            return Type.ThreadCheck;
        }
        if (filename.startsWith("analysis_log_")) {
            return Type.Analysis;
        }
        return Type.Unknown;
    }

    public int compareTo(InstrumentData data) {
        if (this.timestamp == null) {
            return -1;
        }
        if (data.timestamp == null) {
            return 1;
        }
        return data.timestamp.compareTo(this.timestamp);
    }

    public boolean isValid() {
        switch (this.type) {
            case Analysis: {
                return this.featureNames != null && this.timestamp != null;
            }
            case CrashReport: 
            case CrashShield: 
            case ThreadCheck: {
                return this.stackTrace != null && this.timestamp != null;
            }
        }
        return false;
    }

    public void save() {
        if (!this.isValid()) {
            return;
        }
        InstrumentUtility.writeFile(this.filename, this.toString());
    }

    public void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @Nullable
    public String toString() {
        JSONObject params = this.getParameters();
        if (params == null) {
            return null;
        }
        return params.toString();
    }

    @Nullable
    private JSONObject getParameters() {
        switch (this.type) {
            case Analysis: {
                return this.getAnalysisReportParameters();
            }
            case CrashReport: 
            case CrashShield: 
            case ThreadCheck: {
                return this.getExceptionReportParameters();
            }
        }
        return null;
    }

    @Nullable
    private JSONObject getAnalysisReportParameters() {
        JSONObject object = new JSONObject();
        try {
            if (this.featureNames != null) {
                object.put(PARAM_FEATURE_NAMES, (Object)this.featureNames);
            }
            if (this.timestamp != null) {
                object.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    private JSONObject getExceptionReportParameters() {
        JSONObject object = new JSONObject();
        try {
            object.put(PARAM_DEVICE_OS, (Object)Build.VERSION.RELEASE);
            object.put(PARAM_DEVICE_MODEL, (Object)Build.MODEL);
            if (this.appVersion != null) {
                object.put(PARAM_APP_VERSION, (Object)this.appVersion);
            }
            if (this.timestamp != null) {
                object.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            if (this.cause != null) {
                object.put(PARAM_REASON, (Object)this.cause);
            }
            if (this.stackTrace != null) {
                object.put(PARAM_CALLSTACK, (Object)this.stackTrace);
            }
            if (this.type != null) {
                object.put(PARAM_TYPE, (Object)this.type);
            }
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static class Builder {
        public static InstrumentData load(File file) {
            return new InstrumentData(file);
        }

        public static InstrumentData build(Throwable e, Type t) {
            return new InstrumentData(e, t);
        }

        public static InstrumentData build(JSONArray features) {
            return new InstrumentData(features);
        }
    }

    public static enum Type {
        Unknown,
        Analysis,
        CrashReport,
        CrashShield,
        ThreadCheck;


        public String toString() {
            switch (this) {
                case Analysis: {
                    return "Analysis";
                }
                case CrashReport: {
                    return "CrashReport";
                }
                case CrashShield: {
                    return "CrashShield";
                }
                case ThreadCheck: {
                    return "ThreadCheck";
                }
            }
            return "Unknown";
        }
    }
}

