/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.restrictivedatafilter;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RestrictiveDataManager {
    private static boolean enabled = false;
    private static final String TAG = RestrictiveDataManager.class.getCanonicalName();
    private static final List<RestrictiveParamFilter> restrictiveParamFilters = new ArrayList<RestrictiveParamFilter>();
    private static final Set<String> restrictedEvents = new CopyOnWriteArraySet<String>();
    private static final String REPLACEMENT_STRING = "_removed_";
    private static final String PROCESS_EVENT_NAME = "process_event_name";
    private static final String RESTRICTIVE_PARAM = "restrictive_param";
    private static final String RESTRICTIVE_PARAM_KEY = "_restrictedParams";

    public static void enable() {
        enabled = true;
        RestrictiveDataManager.initialize();
    }

    private static void initialize() {
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (settings == null) {
                return;
            }
            String restrictiveDataSetting = settings.getRestrictiveDataSetting();
            if (restrictiveDataSetting == null || restrictiveDataSetting.isEmpty()) {
                return;
            }
            JSONObject restrictiveData = new JSONObject(restrictiveDataSetting);
            restrictiveParamFilters.clear();
            restrictedEvents.clear();
            Iterator keys = restrictiveData.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject filteredValues = restrictiveData.getJSONObject(key);
                if (filteredValues == null) continue;
                JSONObject restrictiveParamJson = filteredValues.optJSONObject(RESTRICTIVE_PARAM);
                RestrictiveParamFilter restrictiveParamFilter = new RestrictiveParamFilter(key, new HashMap<String, String>());
                if (restrictiveParamJson != null) {
                    restrictiveParamFilter.restrictiveParams = Utility.convertJSONObjectToStringMap(restrictiveParamJson);
                    restrictiveParamFilters.add(restrictiveParamFilter);
                }
                if (!filteredValues.has(PROCESS_EVENT_NAME)) continue;
                restrictedEvents.add(restrictiveParamFilter.eventName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String processEvent(String eventName) {
        if (enabled && RestrictiveDataManager.isRestrictedEvent(eventName)) {
            return REPLACEMENT_STRING;
        }
        return eventName;
    }

    public static void processParameters(Map<String, String> parameters, String eventName) {
        if (!enabled) {
            return;
        }
        HashMap<String, String> restrictedParams = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        for (String key : keys) {
            String type = RestrictiveDataManager.getMatchedRuleType(eventName, key);
            if (type == null) continue;
            restrictedParams.put(key, type);
            parameters.remove(key);
        }
        if (restrictedParams.size() > 0) {
            try {
                JSONObject restrictedJSON = new JSONObject();
                for (Map.Entry entry : restrictedParams.entrySet()) {
                    restrictedJSON.put((String)entry.getKey(), entry.getValue());
                }
                parameters.put(RESTRICTIVE_PARAM_KEY, restrictedJSON.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static String getMatchedRuleType(String eventName, String paramKey) {
        try {
            ArrayList<RestrictiveParamFilter> restrictiveParamFiltersCopy = new ArrayList<RestrictiveParamFilter>(restrictiveParamFilters);
            for (RestrictiveParamFilter filter : restrictiveParamFiltersCopy) {
                if (filter == null || !eventName.equals(filter.eventName)) continue;
                for (String param : filter.restrictiveParams.keySet()) {
                    if (!paramKey.equals(param)) continue;
                    return filter.restrictiveParams.get(param);
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"getMatchedRuleType failed", (Throwable)e);
        }
        return null;
    }

    private static boolean isRestrictedEvent(String eventName) {
        return restrictedEvents.contains(eventName);
    }

    static class RestrictiveParamFilter {
        String eventName;
        Map<String, String> restrictiveParams;

        RestrictiveParamFilter(String eventName, Map<String, String> restrictiveParams) {
            this.eventName = eventName;
            this.restrictiveParams = restrictiveParams;
        }
    }
}

